/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.integration.jei.sagmill;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.integration.jei.RecipeWrapperIRecipe;
import crazypants.enderio.base.integration.jei.energy.EnergyIngredient;
import crazypants.enderio.base.recipe.IRecipe;
import crazypants.enderio.base.recipe.RecipeOutput;
import crazypants.enderio.base.recipe.sagmill.GrindingBall;
import crazypants.enderio.base.recipe.sagmill.SagMillRecipeManager;
import crazypants.enderio.util.Prep;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.item.ItemStack;

public class SagRecipe
extends RecipeWrapperIRecipe {
    public SagRecipe(IRecipe recipe) {
        super(recipe);
    }

    @Override
    public void getIngredients(@Nonnull IIngredients ingredients) {
        NNList<List<ItemStack>> inputStacks = this.recipe.getInputStackAlternatives();
        ArrayList<EnergyIngredient> energies = new ArrayList<EnergyIngredient>();
        if (this.recipe.getBonusType().doChances()) {
            List<ItemStack> balls = SagRecipe.getBalls();
            inputStacks.add(balls);
            for (ItemStack ball : balls) {
                if (ball != null && Prep.isValid(ball)) {
                    energies.add(new EnergyIngredient((int)((float)this.recipe.getEnergyRequired() * SagMillRecipeManager.getInstance().getGrindballFromStack(ball).getPowerMultiplier())));
                    continue;
                }
                energies.add(new EnergyIngredient(this.recipe.getEnergyRequired()));
            }
        } else {
            inputStacks.add(Collections.emptyList());
            energies.add(new EnergyIngredient(this.recipe.getEnergyRequired()));
        }
        ingredients.setInputLists(ItemStack.class, inputStacks);
        ingredients.setInputLists(EnergyIngredient.class, Collections.singletonList(energies));
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        for (RecipeOutput out : this.recipe.getOutputs()) {
            if (!Prep.isValid(out.getOutput())) continue;
            outputs.add(out.getOutput());
        }
        ingredients.setOutputs(ItemStack.class, outputs);
    }

    @Nonnull
    static List<ItemStack> getBalls() {
        NNList<GrindingBall> daBalls = SagMillRecipeManager.getInstance().getBalls();
        ArrayList<ItemStack> res = new ArrayList<ItemStack>();
        res.add(null);
        for (GrindingBall ball : daBalls) {
            res.add(ball.getInput());
        }
        return res;
    }
}

