/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.generator.combustion;

import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.fluid.SmartTank;
import crazypants.enderio.base.lang.LangFluid;
import crazypants.enderio.base.lang.LangPower;
import crazypants.enderio.base.machine.gui.GuiInventoryMachineBase;
import crazypants.enderio.base.machine.gui.IPowerBarData;
import crazypants.enderio.base.machine.gui.PowerBar;
import crazypants.enderio.base.machine.modes.IoMode;
import crazypants.enderio.machines.lang.Lang;
import crazypants.enderio.machines.machine.generator.combustion.CombustionMath;
import crazypants.enderio.machines.machine.generator.combustion.ContainerCombustionGenerator;
import crazypants.enderio.machines.machine.generator.combustion.TileCombustionGenerator;
import java.awt.Color;
import java.awt.Rectangle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

public class GuiCombustionGenerator<T extends TileCombustionGenerator>
extends GuiInventoryMachineBase<T> {
    @Nonnull
    private static final Rectangle RECTANGLE_FUEL_TANK = new Rectangle(48, 21, 15, 47);
    @Nonnull
    private static final Rectangle RECTANGLE_COOLANT_TANK = new Rectangle(114, 21, 15, 47);
    private final int CENTER = 1000;

    public GuiCombustionGenerator(@Nonnull InventoryPlayer par1InventoryPlayer, @Nonnull T te) {
        super(te, (Container)new ContainerCombustionGenerator<T>(par1InventoryPlayer, te), new String[]{"combustion_gen"});
        this.addToolTip(new GuiToolTip(RECTANGLE_COOLANT_TANK, new String[]{""}){

            protected void updateText() {
                this.text.clear();
                FluidStack coolant = ((TileCombustionGenerator)GuiCombustionGenerator.this.getTileEntity()).getCoolantTank().getFluid();
                if (coolant != null) {
                    this.text.add(Lang.GUI_COMBGEN_CTANK.get(coolant.getLocalizedName()));
                } else {
                    this.text.add(Lang.GUI_COMBGEN_CTANK_EMPTY.get());
                }
                this.text.add(LangFluid.MB((IFluidTank)((TileCombustionGenerator)GuiCombustionGenerator.this.getTileEntity()).getCoolantTank()));
            }
        });
        this.addToolTip(new GuiToolTip(RECTANGLE_FUEL_TANK, new String[]{""}){

            protected void updateText() {
                this.text.clear();
                FluidStack fuel = ((TileCombustionGenerator)GuiCombustionGenerator.this.getTileEntity()).getFuelTank().getFluid();
                if (fuel != null) {
                    this.text.add(Lang.GUI_COMBGEN_FTANK.get(fuel.getLocalizedName()));
                } else {
                    this.text.add(Lang.GUI_COMBGEN_FTANK_EMPTY.get());
                }
                this.text.add(LangFluid.MB((IFluidTank)((TileCombustionGenerator)GuiCombustionGenerator.this.getTileEntity()).getFuelTank()));
            }
        });
        this.addDrawingElement(new PowerBar((IPowerBarData)te, this, 16, 14, 42){

            @Override
            protected String getPowerOutputLabel(@Nonnull String rft) {
                return super.getPowerOutputLabel(LangPower.RFt(((TileCombustionGenerator)GuiCombustionGenerator.this.getTileEntity()).getMath().getEnergyPerTick()));
            }
        });
    }

    @Override
    @Nullable
    public Object getIngredientUnderMouse(int mouseX, int mouseY) {
        if (RECTANGLE_COOLANT_TANK.contains(mouseX, mouseY)) {
            return ((TileCombustionGenerator)this.getTileEntity()).getCoolantTank().getFluid();
        }
        if (RECTANGLE_FUEL_TANK.contains(mouseX, mouseY)) {
            return ((TileCombustionGenerator)this.getTileEntity()).getFuelTank().getFluid();
        }
        return super.getIngredientUnderMouse(mouseX, mouseY);
    }

    @Override
    public void renderSlotHighlights(@Nonnull IoMode mode) {
        super.renderSlotHighlights(mode);
        if (mode == IoMode.PULL || mode == IoMode.PUSH_PULL) {
            int x = 46;
            int y = 19;
            int w = 19;
            int h = 51;
            this.renderSlotHighlight(PULL_COLOR, x, y, w, h);
            x = 112;
            this.renderSlotHighlight(PULL_COLOR, x, y, w, h);
        }
    }

    @Override
    protected void func_146976_a(float par1, int par2, int par3) {
        SmartTank fuelTank;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindGuiTexture();
        int sx = (this.field_146294_l - this.field_146999_f) / 2;
        int sy = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(sx, sy, 0, 0, this.field_146999_f, this.field_147000_g);
        TileCombustionGenerator gen = (TileCombustionGenerator)this.getTileEntity();
        CombustionMath math = gen.getMath();
        FontRenderer fr = this.getFontRenderer();
        int output = 0;
        if (gen.isActive()) {
            output = math.getEnergyPerTick();
        }
        String txt = Lang.GUI_COMBGEN_OUTPUT.get(LangPower.RFt(output));
        int sw = fr.func_78256_a(txt);
        fr.func_175063_a(txt, (float)(this.field_147003_i + this.field_146999_f / 2 - sw / 2), (float)(this.field_147009_r + fr.field_78288_b / 2 + 3), ColorUtil.getRGB((Color)Color.WHITE));
        int x = this.field_147003_i + 48;
        int y = this.field_147009_r + 21;
        SmartTank coolantTank = gen.getCoolantTank();
        if (!coolantTank.isEmpty()) {
            x = this.field_147003_i + 114;
            int fluidAmount = coolantTank.getFluidAmount();
            FluidStack fluid = coolantTank.getFluid();
            if (fluidAmount > 1000) {
                RenderUtil.renderGuiTank((FluidStack)fluid, (int)(coolantTank.getCapacity() - 1000), (int)(fluidAmount - 1000), (double)x, (double)y, (double)this.field_73735_i, (double)15.0, (double)47.0);
            }
            if (gen.isActive()) {
                txt = LangFluid.tMB(math.getTicksPerCoolant());
                sw = fr.func_78256_a(txt);
                fr.func_175063_a(txt, (float)(x - sw / 2 + 7), (float)(y + fr.field_78288_b / 2 + 47), ColorUtil.getRGB((Color)Color.WHITE));
            }
            RenderUtil.renderGuiTank((FluidStack)fluid, (int)1000, (int)Math.min(fluidAmount, 1000), (double)(this.field_147003_i + 72), (double)(this.field_147009_r + 28), (double)this.field_73735_i, (double)33.0, (double)33.0);
            this.bindGuiTexture();
            this.func_73729_b(this.field_147003_i + 72, this.field_147009_r + 28, 0, 223, 33, 33);
        }
        if (!(fuelTank = gen.getFuelTank()).isEmpty()) {
            x = this.field_147003_i + 48;
            int fluidAmount = fuelTank.getFluidAmount();
            FluidStack fluid = fuelTank.getFluid();
            if (fluidAmount > 1000) {
                RenderUtil.renderGuiTank((FluidStack)fluid, (int)(fuelTank.getCapacity() - 1000), (int)(fluidAmount - 1000), (double)x, (double)y, (double)this.field_73735_i, (double)15.0, (double)47.0);
            }
            if (gen.isActive()) {
                txt = LangFluid.tMB(math.getTicksPerFuel());
                sw = fr.func_78256_a(txt);
                fr.func_175063_a(txt, (float)(x - sw / 2 + 7), (float)(y + fr.field_78288_b / 2 + 47), ColorUtil.getRGB((Color)Color.WHITE));
            }
            RenderUtil.renderGuiTank((FluidStack)fluid, (int)1000, (int)Math.min(fluidAmount, 1000), (double)(this.field_147003_i + 81), (double)(this.field_147009_r + 38), (double)this.field_73735_i, (double)14.0, (double)14.0);
        }
        this.bindGuiTexture();
        super.func_146976_a(par1, par2, par3);
    }
}

