/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.api.capability;

import arekkuusu.enderskills.api.capability.Capabilities;
import arekkuusu.enderskills.api.helper.NBTHelper;
import arekkuusu.enderskills.api.helper.XPHelper;
import arekkuusu.enderskills.api.registry.Skill;
import arekkuusu.enderskills.common.CommonConfig;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class AdvancementCapability
implements ICapabilitySerializable<NBTTagCompound>,
Capability.IStorage<AdvancementCapability> {
    public Skill[] skillUnlockOrder = new Skill[0];
    public int experienceSpent;
    public int resetCount;
    public double levelProgress;
    public int level;
    public int tabPin = -1;
    public int tabPagePin = -1;
    public double experienceProgress;
    public int experienceLevel;
    public static final String EXPERIENCE_NBT = "experience";
    public static final String EXPERIENCE_SPENT_NBT = "experience_spent";
    public static final String EXPERIENCE_PROGRESS_NBT = "experience_progress";
    public static final String LEVEL_NBT = "level";
    public static final String LEVEL_PROGRESS_NBT = "level_progress";
    public static final String RESET_COUNT_NBT = "reset_count";
    public static final String SKILL_UNLOCK_ORDER_NBT = "skill_unlock_order";
    public static final String TAB_PIN_BHT = "tabPin";
    public static final String TAB_PAGE_PIN_BHT = "tabPagePin";

    public AdvancementCapability() {
        this.level = CommonConfig.getSyncValues().advancement.levels.defaultLevel;
    }

    public int getExperienceTotal(EntityLivingBase entity) {
        return XPHelper.getXPTotal(this.experienceLevel, this.experienceProgress) + (entity instanceof EntityPlayer ? XPHelper.getXPTotal((EntityPlayer)entity) : 0);
    }

    public void addExperienceToTotal(int amount) {
        int totalStored = XPHelper.getXPTotal(this.experienceLevel, this.experienceProgress);
        int totalAdded = totalStored + amount;
        this.experienceLevel = Math.max(XPHelper.getLevelFromXPValue(totalAdded), 0);
        this.experienceProgress = Math.max((double)XPHelper.getLevelProgressFromXPValue(totalAdded), 0.0);
    }

    public void consumeExperienceFromTotal(EntityLivingBase entity, int amount) {
        int totalStored = XPHelper.getXPTotal(this.experienceLevel, this.experienceProgress);
        if (entity instanceof EntityPlayer) {
            if (totalStored < amount) {
                this.experienceProgress = 0.0;
                this.experienceLevel = 0;
                XPHelper.takeXP((EntityPlayer)entity, amount -= totalStored);
            } else {
                this.takeXP(amount);
            }
            this.experienceSpent += amount;
        } else if (totalStored >= amount) {
            this.takeXP(amount);
            this.experienceSpent += amount;
        }
    }

    public void takeXP(int xp) {
        int total = XPHelper.getXPTotal(this.experienceLevel, this.experienceProgress);
        int taken = Math.min(xp, total);
        this.experienceLevel = Math.max(XPHelper.getLevelFromXPValue(total -= taken), 0);
        this.experienceProgress = Math.max((double)XPHelper.getLevelProgressFromXPValue(total), 0.0);
    }

    public static void init() {
        CapabilityManager.INSTANCE.register(AdvancementCapability.class, (Capability.IStorage)new AdvancementCapability(), AdvancementCapability::new);
        MinecraftForge.EVENT_BUS.register((Object)new Handler());
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return this.getCapability(capability, facing) != null;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == Capabilities.ADVANCEMENT ? Capabilities.ADVANCEMENT.cast((Object)this) : null);
    }

    public NBTTagCompound serializeNBT() {
        return (NBTTagCompound)Capabilities.ADVANCEMENT.getStorage().writeNBT(Capabilities.ADVANCEMENT, (Object)this, null);
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        Capabilities.ADVANCEMENT.getStorage().readNBT(Capabilities.ADVANCEMENT, (Object)this, null, (NBTBase)nbt);
    }

    @Nullable
    public NBTBase writeNBT(Capability<AdvancementCapability> capability, AdvancementCapability instance, EnumFacing side) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a(EXPERIENCE_NBT, instance.experienceLevel);
        tag.func_74768_a(EXPERIENCE_SPENT_NBT, instance.experienceSpent);
        tag.func_74780_a(EXPERIENCE_PROGRESS_NBT, instance.experienceProgress);
        tag.func_74768_a(LEVEL_NBT, instance.level);
        tag.func_74780_a(LEVEL_PROGRESS_NBT, instance.levelProgress);
        tag.func_74768_a(RESET_COUNT_NBT, instance.resetCount);
        NBTTagList list = new NBTTagList();
        for (Skill skill : instance.skillUnlockOrder) {
            NBTTagCompound compound = new NBTTagCompound();
            NBTHelper.setRegistry(compound, "skill", skill);
            list.func_74742_a((NBTBase)compound);
        }
        tag.func_74782_a(SKILL_UNLOCK_ORDER_NBT, (NBTBase)list);
        tag.func_74768_a(TAB_PIN_BHT, instance.tabPin);
        tag.func_74768_a(TAB_PAGE_PIN_BHT, instance.tabPagePin);
        return tag;
    }

    public void readNBT(Capability<AdvancementCapability> capability, AdvancementCapability instance, EnumFacing side, NBTBase nbt) {
        NBTTagCompound tag = (NBTTagCompound)nbt;
        instance.experienceLevel = tag.func_74762_e(EXPERIENCE_NBT);
        instance.experienceSpent = tag.func_74762_e(EXPERIENCE_SPENT_NBT);
        instance.experienceProgress = tag.func_74769_h(EXPERIENCE_PROGRESS_NBT);
        instance.level = tag.func_74762_e(LEVEL_NBT);
        instance.levelProgress = tag.func_74769_h(LEVEL_PROGRESS_NBT);
        instance.resetCount = tag.func_74762_e(RESET_COUNT_NBT);
        NBTTagList list = tag.func_150295_c(SKILL_UNLOCK_ORDER_NBT, 10);
        instance.skillUnlockOrder = new Skill[list.func_74745_c()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            instance.skillUnlockOrder[i] = NBTHelper.getRegistry(list.func_150305_b(i), "skill", Skill.class);
        }
        if (tag.func_74764_b(TAB_PIN_BHT)) {
            instance.tabPin = tag.func_74762_e(TAB_PIN_BHT);
        }
        if (tag.func_74764_b(TAB_PAGE_PIN_BHT)) {
            instance.tabPagePin = tag.func_74762_e(TAB_PAGE_PIN_BHT);
        }
    }

    public static class Handler {
        private static final ResourceLocation KEY = new ResourceLocation("enderskills", "XP_ADVANCEMENT");

        @SubscribeEvent
        public void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof EntityLivingBase) {
                event.addCapability(KEY, (ICapabilityProvider)Capabilities.ADVANCEMENT.getDefaultInstance());
            }
        }

        @SubscribeEvent
        public void clonePlayer(PlayerEvent.Clone event) {
            ((AdvancementCapability)event.getEntityPlayer().getCapability(Capabilities.ADVANCEMENT, null)).deserializeNBT(((AdvancementCapability)event.getOriginal().getCapability(Capabilities.ADVANCEMENT, null)).serializeNBT());
        }
    }
}

