/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.api.capability;

import arekkuusu.enderskills.api.capability.Capabilities;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnduranceCapability
implements ICapabilitySerializable<NBTTagCompound>,
Capability.IStorage<EnduranceCapability> {
    private double enduranceDelay;
    private double endurance;
    private double absorption;
    public static final String ENDURANCE_NBT = "endurance";
    public static final String ENDURANCE_DELAY_NBT = "endurance_delay";
    public static final String ENDURANCE_MAX_NBT = "endurance_max";

    public double getAbsorption() {
        return this.absorption;
    }

    public void setAbsorption(double absorption) {
        this.absorption = absorption;
    }

    public double getEndurance() {
        return this.endurance;
    }

    public void setEndurance(double endurance) {
        this.endurance = endurance;
    }

    public double getEnduranceDelay() {
        return this.enduranceDelay;
    }

    public void setEnduranceDelay(double enduranceDelay) {
        this.enduranceDelay = enduranceDelay;
    }

    public double drain(double enduranceNeeded) {
        boolean drain = false;
        if (this.getAbsorption() > 0.0 && enduranceNeeded > 0.0) {
            if (this.getAbsorption() > enduranceNeeded) {
                this.setAbsorption(this.getAbsorption() - enduranceNeeded);
                enduranceNeeded = 0.0;
            } else {
                enduranceNeeded -= this.getAbsorption();
                this.setAbsorption(0.0);
            }
            drain = true;
        }
        if (this.getEndurance() > 0.0 && enduranceNeeded > 0.0) {
            if (this.getEndurance() > enduranceNeeded) {
                this.setEndurance(this.getEndurance() - enduranceNeeded);
                enduranceNeeded = 0.0;
            } else {
                enduranceNeeded -= this.getEndurance();
                this.setEndurance(0.0);
            }
            drain = true;
        }
        if (drain) {
            this.setEnduranceDelay(100.0);
        }
        return enduranceNeeded;
    }

    public static void init() {
        CapabilityManager.INSTANCE.register(EnduranceCapability.class, (Capability.IStorage)new EnduranceCapability(), EnduranceCapability::new);
        MinecraftForge.EVENT_BUS.register((Object)new Handler());
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return this.getCapability(capability, facing) != null;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == Capabilities.ENDURANCE ? Capabilities.ENDURANCE.cast((Object)this) : null);
    }

    public NBTTagCompound serializeNBT() {
        return (NBTTagCompound)Capabilities.ENDURANCE.getStorage().writeNBT(Capabilities.ENDURANCE, (Object)this, null);
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        Capabilities.ENDURANCE.getStorage().readNBT(Capabilities.ENDURANCE, (Object)this, null, (NBTBase)nbt);
    }

    @Nullable
    public NBTBase writeNBT(Capability<EnduranceCapability> capability, EnduranceCapability instance, EnumFacing side) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74780_a(ENDURANCE_NBT, instance.endurance);
        tag.func_74780_a(ENDURANCE_DELAY_NBT, instance.enduranceDelay);
        return tag;
    }

    public void readNBT(Capability<EnduranceCapability> capability, EnduranceCapability instance, EnumFacing side, NBTBase nbt) {
        NBTTagCompound tag = (NBTTagCompound)nbt;
        instance.endurance = tag.func_74769_h(ENDURANCE_NBT);
        instance.enduranceDelay = tag.func_74769_h(ENDURANCE_DELAY_NBT);
    }

    public static class Handler {
        private static final ResourceLocation KEY = new ResourceLocation("enderskills", "ENDURANCE");

        @SubscribeEvent
        public void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof EntityLivingBase) {
                event.addCapability(KEY, (ICapabilityProvider)Capabilities.ENDURANCE.getDefaultInstance());
            }
        }

        @SubscribeEvent
        public void clonePlayer(PlayerEvent.Clone event) {
            ((EnduranceCapability)event.getEntityPlayer().getCapability(Capabilities.ENDURANCE, null)).deserializeNBT(((EnduranceCapability)event.getOriginal().getCapability(Capabilities.ENDURANCE, null)).serializeNBT());
        }
    }
}

