/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.api.capability;

import arekkuusu.enderskills.api.capability.Capabilities;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class PowerBoostCapability
implements ICapabilitySerializable<NBTTagCompound>,
Capability.IStorage<PowerBoostCapability> {
    public float eyeOriginal;
    public float widthOriginal;
    public float heightOriginal;
    public float eyeNew;
    public float widthNew;
    public float heightNew;
    public static final String EYE_ORIGINAL_NBT = "eyeOriginal";
    public static final String WIDTH_ORIGINAL_NBT = "widthOriginal";
    public static final String HEIGHT_ORIGINAL_NBT = "heightOriginal";

    public static void init() {
        CapabilityManager.INSTANCE.register(PowerBoostCapability.class, (Capability.IStorage)new PowerBoostCapability(), PowerBoostCapability::new);
        MinecraftForge.EVENT_BUS.register((Object)new Handler());
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return this.getCapability(capability, facing) != null;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == Capabilities.POWER_BOOST ? Capabilities.POWER_BOOST.cast((Object)this) : null);
    }

    public NBTTagCompound serializeNBT() {
        return (NBTTagCompound)Capabilities.POWER_BOOST.getStorage().writeNBT(Capabilities.POWER_BOOST, (Object)this, null);
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        Capabilities.POWER_BOOST.getStorage().readNBT(Capabilities.POWER_BOOST, (Object)this, null, (NBTBase)nbt);
    }

    @Nullable
    public NBTBase writeNBT(Capability<PowerBoostCapability> capability, PowerBoostCapability instance, EnumFacing side) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74776_a(EYE_ORIGINAL_NBT, instance.eyeOriginal);
        tag.func_74776_a(WIDTH_ORIGINAL_NBT, instance.heightOriginal);
        tag.func_74776_a(HEIGHT_ORIGINAL_NBT, instance.heightOriginal);
        return tag;
    }

    public void readNBT(Capability<PowerBoostCapability> capability, PowerBoostCapability instance, EnumFacing side, NBTBase nbt) {
        NBTTagCompound tag = (NBTTagCompound)nbt;
        instance.eyeOriginal = tag.func_74760_g(EYE_ORIGINAL_NBT);
        instance.widthOriginal = tag.func_74760_g(WIDTH_ORIGINAL_NBT);
        instance.heightOriginal = tag.func_74760_g(HEIGHT_ORIGINAL_NBT);
    }

    public static class Handler {
        private static final ResourceLocation KEY = new ResourceLocation("enderskills", "POWER_BOOST");

        @SubscribeEvent
        public void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof EntityLivingBase) {
                event.addCapability(KEY, (ICapabilityProvider)Capabilities.POWER_BOOST.getDefaultInstance());
            }
        }

        @SubscribeEvent
        public void clonePlayer(PlayerEvent.Clone event) {
            ((PowerBoostCapability)event.getEntityPlayer().getCapability(Capabilities.POWER_BOOST, null)).deserializeNBT(((PowerBoostCapability)event.getOriginal().getCapability(Capabilities.POWER_BOOST, null)).serializeNBT());
        }
    }
}

