/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.api.capability;

import arekkuusu.enderskills.api.capability.Capabilities;
import arekkuusu.enderskills.api.capability.data.SkillGroup;
import arekkuusu.enderskills.api.helper.NBTHelper;
import arekkuusu.enderskills.api.registry.Skill;
import arekkuusu.enderskills.common.skill.ModAbilities;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class SkillGroupCapability
implements ICapabilitySerializable<NBTTagCompound>,
Capability.IStorage<SkillGroupCapability> {
    public static final Function<String, SkillGroup> GROUP_SUPPLIER = s -> new SkillGroup();
    public static final SkillGroup GROUP_EMPTY = new SkillGroup();
    public Map<String, SkillGroup> skillGroupMap = new LinkedHashMap<String, SkillGroup>();
    public static final String GROUP_LIST_NBT = "group_list";
    public static final String GROUP_NAME_NBT = "group_name";
    public static final String GROUP_DATA_NBT = "group_data";

    public SkillGroupCapability() {
        this.putWeight("Defense-Light", ModAbilities.CHARM, 0);
        this.putWeight("Defense-Light", ModAbilities.HEAL_AURA, 1);
        this.putWeight("Defense-Light", ModAbilities.POWER_BOOST, 2);
        this.putWeight("Defense-Light", ModAbilities.HEAL_OTHER, 3);
        this.putWeight("Defense-Light", ModAbilities.HEAL_SELF, 4);
        this.putWeight("Defense-Light", ModAbilities.NEARBY_INVINCIBILITY, 5);
        this.putWeight("Defense-Earth", ModAbilities.TAUNT, 0);
        this.putWeight("Defense-Earth", ModAbilities.WALL, 1);
        this.putWeight("Defense-Earth", ModAbilities.DOME, 2);
        this.putWeight("Defense-Earth", ModAbilities.THORNY, 3);
        this.putWeight("Defense-Earth", ModAbilities.SHOCKWAVE, 4);
        this.putWeight("Defense-Earth", ModAbilities.ANIMATED_STONE_GOLEM, 5);
        this.putWeight("Defense-Electric", ModAbilities.SHOCKING_AURA, 0);
        this.putWeight("Defense-Electric", ModAbilities.ELECTRIC_PULSE, 1);
        this.putWeight("Defense-Electric", ModAbilities.MAGNETIC_PULL, 2);
        this.putWeight("Defense-Electric", ModAbilities.POWER_DRAIN, 3);
        this.putWeight("Defense-Electric", ModAbilities.ENERGIZE, 4);
        this.putWeight("Defense-Electric", ModAbilities.VOLTAIC_SENTINEL, 5);
        this.putWeight("Mobility-Wind", ModAbilities.DASH, 0);
        this.putWeight("Mobility-Wind", ModAbilities.EXTRA_JUMP, 1);
        this.putWeight("Mobility-Wind", ModAbilities.FOG, 2);
        this.putWeight("Mobility-Wind", ModAbilities.SMASH, 3);
        this.putWeight("Mobility-Wind", ModAbilities.HASTEN, 4);
        this.putWeight("Mobility-Wind", ModAbilities.SPEED_BOOST, 5);
        this.putWeight("Mobility-Void", ModAbilities.WARP, 0);
        this.putWeight("Mobility-Void", ModAbilities.INVISIBILITY, 1);
        this.putWeight("Mobility-Void", ModAbilities.HOVER, 2);
        this.putWeight("Mobility-Void", ModAbilities.UNSTABLE_PORTAL, 3);
        this.putWeight("Mobility-Void", ModAbilities.PORTAL, 4);
        this.putWeight("Mobility-Void", ModAbilities.TELEPORT, 5);
        this.putWeight("Offense-Void", ModAbilities.SHADOW, 0);
        this.putWeight("Offense-Void", ModAbilities.GLOOM, 1);
        this.putWeight("Offense-Void", ModAbilities.SHADOW_JAB, 2);
        this.putWeight("Offense-Void", ModAbilities.GAS_CLOUD, 3);
        this.putWeight("Offense-Void", ModAbilities.GRASP, 4);
        this.putWeight("Offense-Void", ModAbilities.BLACK_HOLE, 5);
        this.putWeight("Offense-Blood", ModAbilities.BLEED, 0);
        this.putWeight("Offense-Blood", ModAbilities.BLOOD_POOL, 1);
        this.putWeight("Offense-Blood", ModAbilities.CONTAMINATE, 2);
        this.putWeight("Offense-Blood", ModAbilities.LIFE_STEAL, 3);
        this.putWeight("Offense-Blood", ModAbilities.SYPHON, 4);
        this.putWeight("Offense-Blood", ModAbilities.SACRIFICE, 5);
        this.putWeight("Offense-Wind", ModAbilities.SLASH, 0);
        this.putWeight("Offense-Wind", ModAbilities.PUSH, 1);
        this.putWeight("Offense-Wind", ModAbilities.PULL, 2);
        this.putWeight("Offense-Wind", ModAbilities.CRUSH, 3);
        this.putWeight("Offense-Wind", ModAbilities.UPDRAFT, 4);
        this.putWeight("Offense-Wind", ModAbilities.SUFFOCATE, 5);
        this.putWeight("Offense-Fire", ModAbilities.FIRE_SPIRIT, 0);
        this.putWeight("Offense-Fire", ModAbilities.FLAMING_BREATH, 1);
        this.putWeight("Offense-Fire", ModAbilities.FLAMING_RAIN, 2);
        this.putWeight("Offense-Fire", ModAbilities.FOCUS_FLAME, 3);
        this.putWeight("Offense-Fire", ModAbilities.FIREBALL, 4);
        this.putWeight("Offense-Fire", ModAbilities.EXPLODE, 5);
    }

    public boolean hasWeight(String group, Skill skill) {
        return this.skillGroupMap.containsKey(group) && this.skillGroupMap.get((Object)group).map.containsKey((Object)skill);
    }

    public void putWeight(String group, Skill skill, int weight) {
        SkillGroup skillGroup = this.skillGroupMap.computeIfAbsent(group, GROUP_SUPPLIER);
        skillGroup.map.put((Object)skill, weight);
    }

    public void removeWeight(String group, Skill skill) {
        if (this.skillGroupMap.containsKey(group)) {
            this.skillGroupMap.get((Object)group).map.remove((Object)skill);
            if (this.skillGroupMap.get((Object)group).map.isEmpty()) {
                this.skillGroupMap.remove(group);
            }
        }
    }

    public int getWeight(String group, Skill skill) {
        SkillGroup skillGroup = this.skillGroupMap.getOrDefault(group, GROUP_EMPTY);
        return (Integer)skillGroup.map.getOrDefault((Object)skill, (Object)Integer.MAX_VALUE);
    }

    public SkillGroup getGroup(String group) {
        return this.skillGroupMap.get(group);
    }

    public Map<String, SkillGroup> getGroups() {
        return this.skillGroupMap;
    }

    public void clearWeight() {
        this.skillGroupMap.clear();
    }

    public static void init() {
        CapabilityManager.INSTANCE.register(SkillGroupCapability.class, (Capability.IStorage)new SkillGroupCapability(), SkillGroupCapability::new);
        MinecraftForge.EVENT_BUS.register((Object)new Handler());
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return this.getCapability(capability, facing) != null;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == Capabilities.WEIGHT ? Capabilities.WEIGHT.cast((Object)this) : null);
    }

    public NBTTagCompound serializeNBT() {
        return (NBTTagCompound)Capabilities.WEIGHT.getStorage().writeNBT(Capabilities.WEIGHT, (Object)this, null);
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        Capabilities.WEIGHT.getStorage().readNBT(Capabilities.WEIGHT, (Object)this, null, (NBTBase)nbt);
    }

    @Nullable
    public NBTBase writeNBT(Capability<SkillGroupCapability> capability, SkillGroupCapability instance, EnumFacing side) {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList skillWeightList = new NBTTagList();
        for (Map.Entry<String, SkillGroup> set : instance.skillGroupMap.entrySet()) {
            NBTTagCompound compound = new NBTTagCompound();
            NBTHelper.setString(compound, GROUP_NAME_NBT, set.getKey());
            NBTHelper.setNBT(compound, GROUP_DATA_NBT, set.getValue().serializeNBT());
            skillWeightList.func_74742_a((NBTBase)compound);
        }
        tag.func_74782_a(GROUP_LIST_NBT, (NBTBase)skillWeightList);
        return tag;
    }

    public void readNBT(Capability<SkillGroupCapability> capability, SkillGroupCapability instance, EnumFacing side, NBTBase nbt) {
        instance.skillGroupMap.clear();
        NBTTagCompound tag = (NBTTagCompound)nbt;
        NBTTagList skillWeightList = tag.func_150295_c(GROUP_LIST_NBT, 10);
        for (int i = 0; i < skillWeightList.func_74745_c(); ++i) {
            NBTTagCompound compound = skillWeightList.func_150305_b(i);
            String name = NBTHelper.getString(compound, GROUP_NAME_NBT);
            SkillGroup group = new SkillGroup(NBTHelper.getNBTTag(compound, GROUP_DATA_NBT));
            instance.skillGroupMap.put(name, group);
        }
    }

    public static class Handler {
        private static final ResourceLocation KEY = new ResourceLocation("enderskills", "skill_group");

        @SubscribeEvent
        public void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof EntityLivingBase) {
                event.addCapability(KEY, (ICapabilityProvider)Capabilities.WEIGHT.getDefaultInstance());
            }
        }

        @SubscribeEvent
        public void clonePlayer(PlayerEvent.Clone event) {
            ((SkillGroupCapability)event.getEntityPlayer().getCapability(Capabilities.WEIGHT, null)).deserializeNBT(((SkillGroupCapability)event.getOriginal().getCapability(Capabilities.WEIGHT, null)).serializeNBT());
        }
    }
}

