/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.api.capability;

import arekkuusu.enderskills.api.capability.Capabilities;
import arekkuusu.enderskills.api.capability.data.SkillData;
import arekkuusu.enderskills.api.capability.data.SkillHolder;
import arekkuusu.enderskills.api.capability.data.SkillInfo;
import arekkuusu.enderskills.api.helper.NBTHelper;
import arekkuusu.enderskills.api.registry.Skill;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;

public class SkilledEntityCapability
implements ICapabilitySerializable<NBTTagCompound>,
Capability.IStorage<SkilledEntityCapability> {
    public Map<Skill, SkillInfo> skillPlayerInfoMap = Maps.newHashMap();
    public List<SkillHolder> skillHolders = Lists.newLinkedList();
    public static final String SKILL_LIST_NBT = "skill_list";
    public static final String HOLDER_LIST_NBT = "holder_list";
    public static final String SKILL_NBT = "skill";
    public static final String SKILL_INFO_NBT = "skill_info";

    public Map<Skill, SkillInfo> getAllOwned() {
        return this.skillPlayerInfoMap;
    }

    public Optional<SkillInfo> getOwned(Skill skill) {
        return Optional.ofNullable(this.skillPlayerInfoMap.get((Object)skill));
    }

    public boolean isOwned(Skill skill) {
        return this.skillPlayerInfoMap.containsKey((Object)skill);
    }

    public void addOwned(Skill skill) {
        if (!this.isOwned(skill)) {
            this.skillPlayerInfoMap.put(skill, skill.createInfo(new NBTTagCompound()));
        }
    }

    public void removeOwned(Skill skill) {
        this.skillPlayerInfoMap.remove((Object)skill);
    }

    public void clearOwned() {
        this.skillPlayerInfoMap.clear();
    }

    public List<SkillHolder> getActives() {
        return this.skillHolders;
    }

    public Optional<SkillHolder> getActive(Skill skill) {
        return this.skillHolders.stream().filter(h -> h.data.skill == skill && !h.isDead()).findFirst();
    }

    public boolean isActive(Skill skill) {
        return this.skillHolders.stream().anyMatch(h -> h.data.skill == skill && !h.isDead());
    }

    public void activate(SkillHolder holder) {
        if (holder.data.overrides != null) {
            switch (holder.data.overrides) {
                case EQUAL: {
                    this.skillHolders.forEach(h -> {
                        if (h.data.skill == holder.data.skill && h.data.id.equals(holder.data.id)) {
                            h.setDead();
                        }
                    });
                }
                case SAME: {
                    this.skillHolders.forEach(h -> {
                        if (h.data.skill == holder.data.skill) {
                            h.setDead();
                        }
                    });
                    break;
                }
                case ID: {
                    this.skillHolders.forEach(h -> {
                        if (h.data.id.equals(holder.data.id)) {
                            h.setDead();
                        }
                    });
                    break;
                }
            }
        }
        this.skillHolders.add(holder);
    }

    public void deactivate(Skill skill) {
        for (SkillHolder holder : this.skillHolders) {
            if (holder.data.skill != skill) continue;
            holder.setDead();
        }
    }

    public void deactivate(Skill skill, SkillData data) {
        for (SkillHolder holder : this.skillHolders) {
            if (holder.data.skill != skill || !data.id.equals(holder.data.id)) continue;
            holder.setDead();
        }
    }

    public void clearActive() {
        this.skillHolders.forEach(SkillHolder::setDead);
    }

    public static void init() {
        CapabilityManager.INSTANCE.register(SkilledEntityCapability.class, (Capability.IStorage)new SkilledEntityCapability(), SkilledEntityCapability::new);
        MinecraftForge.EVENT_BUS.register((Object)new Handler());
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return this.getCapability(capability, facing) != null;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == Capabilities.SKILLED_ENTITY ? Capabilities.SKILLED_ENTITY.cast((Object)this) : null);
    }

    public NBTTagCompound serializeNBT() {
        return (NBTTagCompound)Capabilities.SKILLED_ENTITY.getStorage().writeNBT(Capabilities.SKILLED_ENTITY, (Object)this, null);
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        Capabilities.SKILLED_ENTITY.getStorage().readNBT(Capabilities.SKILLED_ENTITY, (Object)this, null, (NBTBase)nbt);
    }

    @Nullable
    public NBTBase writeNBT(Capability<SkilledEntityCapability> capability, SkilledEntityCapability instance, EnumFacing side) {
        NBTTagCompound compound;
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList attributeList = new NBTTagList();
        NBTTagList skillHolderList = new NBTTagList();
        for (Map.Entry<Skill, SkillInfo> set : instance.skillPlayerInfoMap.entrySet()) {
            compound = new NBTTagCompound();
            NBTHelper.setResourceLocation(compound, SKILL_NBT, set.getKey().getRegistryName());
            compound.func_74782_a(SKILL_INFO_NBT, (NBTBase)set.getValue().serializeNBT());
            attributeList.func_74742_a((NBTBase)compound);
        }
        for (SkillHolder skillHolder : instance.skillHolders) {
            compound = skillHolder.serializeNBT();
            skillHolderList.func_74742_a((NBTBase)compound);
        }
        tag.func_74782_a(SKILL_LIST_NBT, (NBTBase)attributeList);
        tag.func_74782_a(HOLDER_LIST_NBT, (NBTBase)skillHolderList);
        return tag;
    }

    public void readNBT(Capability<SkilledEntityCapability> capability, SkilledEntityCapability instance, EnumFacing side, NBTBase nbt) {
        NBTTagCompound compound;
        int i;
        instance.skillPlayerInfoMap.clear();
        instance.skillHolders.clear();
        NBTTagCompound tag = (NBTTagCompound)nbt;
        NBTTagList attributeList = tag.func_150295_c(SKILL_LIST_NBT, 10);
        NBTTagList skillHolderList = tag.func_150295_c(HOLDER_LIST_NBT, 10);
        IForgeRegistry registry = GameRegistry.findRegistry(Skill.class);
        for (i = 0; i < attributeList.func_74745_c(); ++i) {
            compound = attributeList.func_150305_b(i);
            ResourceLocation location = NBTHelper.getResourceLocation(compound, SKILL_NBT);
            Skill skill = (Skill)registry.getValue(location);
            SkillInfo info = skill.createInfo(compound.func_74775_l(SKILL_INFO_NBT));
            instance.skillPlayerInfoMap.put(skill, info);
        }
        for (i = 0; i < skillHolderList.func_74745_c(); ++i) {
            compound = skillHolderList.func_150305_b(i);
            instance.skillHolders.add(new SkillHolder(compound));
        }
    }

    public static class Handler {
        private static final ResourceLocation KEY = new ResourceLocation("enderskills", "skilled_entity");

        @SubscribeEvent
        public void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof EntityLivingBase) {
                event.addCapability(KEY, (ICapabilityProvider)Capabilities.SKILLED_ENTITY.getDefaultInstance());
            }
        }

        @SubscribeEvent
        public void clonePlayer(PlayerEvent.Clone event) {
            ((SkilledEntityCapability)event.getEntityPlayer().getCapability(Capabilities.SKILLED_ENTITY, null)).deserializeNBT(((SkilledEntityCapability)event.getOriginal().getCapability(Capabilities.SKILLED_ENTITY, null)).serializeNBT());
        }
    }
}

