/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.api.capability.data;

import arekkuusu.enderskills.api.capability.data.nbt.WatcherManager;
import arekkuusu.enderskills.api.helper.NBTHelper;
import arekkuusu.enderskills.api.registry.Skill;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.INBTSerializable;

public final class SkillData
implements INBTSerializable<NBTTagCompound> {
    public String id;
    public WatcherManager watcher;
    public Overrides overrides;
    public NBTTagCompound nbt;
    public Skill skill;
    public int time;

    public SkillData(NBTTagCompound nbt, String id, Skill skill, Overrides overrides, WatcherManager.Watcher[] trackers, int time) {
        this.id = id;
        this.nbt = nbt;
        this.time = time;
        this.skill = skill;
        this.overrides = overrides;
        this.watcher = new WatcherManager();
        for (WatcherManager.Watcher tracker : trackers) {
            this.watcher.add(tracker);
        }
    }

    public SkillData(NBTTagCompound tag) {
        this.deserializeNBT(tag);
    }

    public SkillData copy() {
        return new SkillData(this.serializeNBT());
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        this.writeNBT(compound);
        return compound;
    }

    public void deserializeNBT(NBTTagCompound compound) {
        this.readNBT(compound);
    }

    public void writeNBT(NBTTagCompound compound) {
        NBTHelper.setString(compound, "id", this.id);
        if (this.overrides != null) {
            NBTHelper.setInteger(compound, "overrides", this.overrides.ordinal());
        }
        NBTHelper.setRegistry(compound, "skill", this.skill);
        NBTHelper.setInteger(compound, "time", this.time);
        NBTHelper.setNBT(compound, "nbt", this.nbt);
        NBTTagList list1 = new NBTTagList();
        for (WatcherManager.Watcher watcher : this.watcher.entries.keySet()) {
            list1.func_74742_a((NBTBase)new NBTTagInt(WatcherManager.WATCHERS.indexOf(watcher)));
        }
        this.watcher.entries.forEach((key, value) -> value.onWrite(this));
        compound.func_74782_a("watchers", (NBTBase)list1);
    }

    public void readNBT(NBTTagCompound compound) {
        this.id = NBTHelper.getString(compound, "id");
        this.overrides = NBTHelper.hasTag(compound, "overrides") ? Overrides.values()[NBTHelper.getInteger(compound, "overrides")] : null;
        this.skill = NBTHelper.getRegistry(compound, "skill", Skill.class);
        this.time = compound.func_74762_e("time");
        this.nbt = compound.func_74775_l("nbt");
        NBTTagList list1 = compound.func_150295_c("watchers", 3);
        this.watcher = new WatcherManager();
        for (int i = 0; i < list1.func_74745_c(); ++i) {
            this.watcher.add(WatcherManager.WATCHERS.get(list1.func_186858_c(i)));
        }
        this.watcher.entries.forEach((key, value) -> value.onRead(this));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SkillData data = (SkillData)o;
        return this.nbt.equals((Object)data.nbt);
    }

    public int hashCode() {
        return Objects.hash(this.nbt);
    }

    public static Builder of(Skill skill) {
        return new Builder(skill);
    }

    public static enum Overrides {
        EQUAL,
        SAME,
        ID,
        NONE;

    }

    public static class Builder {
        public int time;
        public String id;
        public Skill skill;
        public NBTTagCompound tag;
        public Overrides overrides;
        public WatcherManager.Watcher[] tracker;

        public Builder(Skill skill) {
            this.skill = skill;
            this.id = UUID.randomUUID().toString();
            this.tag = new NBTTagCompound();
            this.overrides = Overrides.NONE;
            this.tracker = new WatcherManager.Watcher[0];
        }

        public Builder put(NBTTagCompound tag, WatcherManager.Watcher ... tracker) {
            this.tag = tag.func_74737_b();
            this.tracker = tracker;
            return this;
        }

        public Builder overrides(Overrides overrides) {
            this.overrides = overrides;
            return this;
        }

        public Builder with(int time) {
            this.time = time;
            return this;
        }

        public Builder by(Entity owner) {
            return this.by(owner.func_110124_au().toString());
        }

        public Builder by(UUID id) {
            return this.by(id.toString());
        }

        public Builder by(UUID a, UUID b) {
            return this.by(a.toString() + ":" + b.toString());
        }

        public Builder by(String id) {
            this.id = id;
            return this;
        }

        public SkillData create() {
            return new SkillData(this.tag, this.id, this.skill, this.overrides, this.tracker, this.time);
        }
    }
}

