/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.api.helper;

import arekkuusu.enderskills.api.EnderSkillsAPI;
import arekkuusu.enderskills.api.registry.Skill;
import com.expression.parser.Parser;
import com.expression.parser.util.ParserResult;
import com.expression.parser.util.Point;
import it.unimi.dsi.fastutil.ints.Int2DoubleArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;

public class ExpressionHelper {
    public static final Function<String, FunctionInfo> EXPRESSION_PARSER_SUPPLIER = ExpressionHelper::parse;
    public static final String EXPRESSION_REGEX = "^\\(([\\+\\-\\d]+)\\)\\{(.+)\\}$";

    public static double getExpression(Skill skill, String function, int min, int max) {
        return ExpressionHelper.getExpression(skill.getRegistryName(), function, min, max);
    }

    public static double getExpression(Skill skill, String[] functionArray, int min, int max) {
        return ExpressionHelper.getExpression(skill.getRegistryName(), functionArray, min, max);
    }

    public static double getExpression(ResourceLocation location, String function, int min, int max) {
        Int2DoubleArrayMap map = EnderSkillsAPI.EXPRESSION_CACHE.computeIfAbsent((Tuple<ResourceLocation, String>)new Tuple((Object)location, (Object)function), EnderSkillsAPI.EXPRESSION_CACHE_SUPPLIER);
        if (!map.containsKey(min)) {
            Point x = new Point("x", String.valueOf(min));
            Point y = new Point("y", String.valueOf(max));
            ParserResult result = Parser.eval(function, x, y);
            map.put(min, result.getValue().doubleValue());
        }
        return map.get(min);
    }

    public static double getExpression(ResourceLocation location, String[] functionArray, int min, int max) {
        Object2ObjectMap map = (Object2ObjectMap)EnderSkillsAPI.EXPRESSION_FUNCTION_CACHE.computeIfAbsent(location, EnderSkillsAPI.EXPRESSION_FUNCTION_CACHE_SUPPLIER);
        FunctionInfo match = null;
        FunctionInfo temp = null;
        for (String s : functionArray) {
            FunctionInfo info = (FunctionInfo)map.computeIfAbsent((Object)s, EXPRESSION_PARSER_SUPPLIER);
            if (info.matches(min) && ExpressionHelper.isNotOverride(temp, info, min)) {
                match = info;
            }
            temp = info;
        }
        return match != null ? ExpressionHelper.getExpression(location, match.function, min, max) : 0.0;
    }

    public static boolean isNotOverride(@Nullable FunctionInfo prev, FunctionInfo next, int min) {
        return prev == null || next.condition != FunctionInfo.Condition.MinusInfinite || prev.condition == FunctionInfo.Condition.PlusInfinite && min > prev.min || prev.condition == FunctionInfo.Condition.Between && min > prev.max || prev.condition == FunctionInfo.Condition.MinusInfinite && min > prev.min;
    }

    public static FunctionInfo parse(String string) {
        Pattern pattern = Pattern.compile(EXPRESSION_REGEX);
        Matcher matcher = pattern.matcher(string.trim());
        if (matcher.matches()) {
            String condition = matcher.group(1).trim().replace(" ", "");
            String function = matcher.group(2).trim();
            if (condition.endsWith("+")) {
                int min = Integer.parseInt(condition.substring(0, condition.length() - 1));
                return new FunctionInfo(FunctionInfo.Condition.PlusInfinite, function, min);
            }
            if (condition.startsWith("-")) {
                int min = Integer.parseInt(condition.substring(1));
                return new FunctionInfo(FunctionInfo.Condition.MinusInfinite, function, min);
            }
            if (condition.contains("-")) {
                int index = condition.indexOf(45);
                int min = Integer.parseInt(condition.substring(0, index));
                int max = Integer.parseInt(condition.substring(index + 1));
                return new FunctionInfo(FunctionInfo.Condition.Between, function, min, max);
            }
            int min = Integer.parseInt(condition);
            return new FunctionInfo(FunctionInfo.Condition.Equal, function, min);
        }
        throw new IllegalStateException("[ExpressionHelper] - Expression " + string + " is not valid, might be missing a { or }");
    }

    public static class FunctionInfo {
        public Condition condition;
        public String function;
        public int min;
        public int max;

        public FunctionInfo(Condition condition, String function, int min, int max) {
            this.condition = condition;
            this.function = function;
            this.min = min;
            this.max = max;
        }

        public FunctionInfo(Condition condition, String function, int min) {
            this.condition = condition;
            this.function = function;
            this.min = min;
            this.max = -1;
        }

        public boolean matches(int level) {
            return this.condition.test(level, this.min, this.max);
        }

        public static enum Condition {
            PlusInfinite{

                @Override
                boolean test(int level, int levelMin, int levelMax) {
                    return level >= levelMin;
                }
            }
            ,
            MinusInfinite{

                @Override
                boolean test(int level, int levelMin, int levelMax) {
                    return level <= levelMin;
                }
            }
            ,
            Between{

                @Override
                boolean test(int level, int levelMin, int levelMax) {
                    return level >= levelMin && level <= levelMax;
                }
            }
            ,
            Equal{

                @Override
                boolean test(int level, int levelMin, int levelMax) {
                    return level == levelMin;
                }
            };


            abstract boolean test(int var1, int var2, int var3);
        }
    }
}

