/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.api.helper;

import arekkuusu.enderskills.api.helper.WorldHelper;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class NBTHelper {
    public static NBTTagCompound fixNBT(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            stack.func_77982_d(tagCompound);
        }
        return tagCompound;
    }

    public static void setByte(NBTTagCompound compound, String tag, byte i) {
        compound.func_74774_a(tag, i);
    }

    public static void setInteger(NBTTagCompound compound, String tag, int i) {
        compound.func_74768_a(tag, i);
    }

    public static void setFloat(NBTTagCompound compound, String tag, float i) {
        compound.func_74776_a(tag, i);
    }

    public static void setDouble(NBTTagCompound compound, String tag, double i) {
        compound.func_74780_a(tag, i);
    }

    public static void setBoolean(NBTTagCompound compound, String tag, boolean i) {
        compound.func_74757_a(tag, i);
    }

    public static void setString(NBTTagCompound compound, String tag, String i) {
        compound.func_74778_a(tag, i);
    }

    public static void setUUID(NBTTagCompound compound, String tag, UUID i) {
        compound.func_186854_a(tag, i);
    }

    public static byte getByte(NBTTagCompound compound, String tag) {
        return compound.func_74771_c(tag);
    }

    public static int getInteger(NBTTagCompound compound, String tag) {
        return compound.func_74762_e(tag);
    }

    public static float getFloat(NBTTagCompound compound, String tag) {
        return compound.func_74760_g(tag);
    }

    public static double getDouble(NBTTagCompound compound, String tag) {
        return compound.func_74769_h(tag);
    }

    public static boolean getBoolean(NBTTagCompound compound, String tag) {
        return compound.func_74767_n(tag);
    }

    public static String getString(NBTTagCompound compound, String tag) {
        return compound.func_74779_i(tag);
    }

    @Nullable
    public static UUID getUUID(NBTTagCompound compound, String tag) {
        return compound.func_186855_b(tag) ? compound.func_186857_a(tag) : null;
    }

    public static <T extends NBTBase> T setNBT(NBTTagCompound compound, String tag, T base) {
        compound.func_74782_a(tag, base);
        return base;
    }

    public static boolean hasTag(NBTTagCompound compound, String tag, int type) {
        return compound != null && compound.func_150297_b(tag, type);
    }

    public static boolean hasTag(NBTTagCompound compound, String tag) {
        return compound != null && compound.func_74764_b(tag);
    }

    public static void setArray(NBTTagCompound compound, String tag, String ... array) {
        NBTTagList list = new NBTTagList();
        for (String s : array) {
            list.func_74742_a((NBTBase)new NBTTagString(s));
        }
        compound.func_74782_a(tag, (NBTBase)list);
    }

    public static String[] getArray(NBTTagCompound compound, String tag) {
        NBTTagList list = compound.func_150295_c(tag, 8);
        String[] array = new String[list.func_74745_c()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            array[i] = list.func_150307_f(i);
        }
        return array;
    }

    public static void setBlockPos(NBTTagCompound compound, String tag, @Nullable BlockPos pos) {
        if (pos == null) {
            pos = BlockPos.field_177992_a;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("x", pos.func_177958_n());
        nbt.func_74768_a("y", pos.func_177956_o());
        nbt.func_74768_a("z", pos.func_177952_p());
        compound.func_74782_a(tag, (NBTBase)nbt);
    }

    public static BlockPos getBlockPos(NBTTagCompound compound, String tag) {
        BlockPos pos = BlockPos.field_177992_a;
        if (NBTHelper.hasTag(compound, tag, 10)) {
            NBTTagCompound nbt = compound.func_74775_l(tag);
            int x = nbt.func_74762_e("x");
            int y = nbt.func_74762_e("y");
            int z = nbt.func_74762_e("z");
            pos = pos.func_177982_a(x, y, z);
        }
        return pos;
    }

    public static void setVector(NBTTagCompound compound, String tag, Vec3d vec) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74780_a("x", vec.field_72450_a);
        nbt.func_74780_a("y", vec.field_72448_b);
        nbt.func_74780_a("z", vec.field_72449_c);
        compound.func_74782_a(tag, (NBTBase)nbt);
    }

    public static Vec3d getVector(NBTTagCompound compound, String tag) {
        Vec3d vec = Vec3d.field_186680_a;
        if (NBTHelper.hasTag(compound, tag, 10)) {
            NBTTagCompound nbt = compound.func_74775_l(tag);
            double x = nbt.func_74769_h("x");
            double y = nbt.func_74769_h("y");
            double z = nbt.func_74769_h("z");
            vec = vec.func_72441_c(x, y, z);
        }
        return vec;
    }

    public static <T extends IForgeRegistryEntry<T>> void setRegistry(NBTTagCompound compound, String tag, IForgeRegistryEntry.Impl<T> instance) {
        NBTHelper.setResourceLocation(compound, tag, Objects.requireNonNull(instance.getRegistryName()));
    }

    public static <T extends IForgeRegistryEntry.Impl<T>> T getRegistry(NBTTagCompound compound, String tag, Class<T> registry) {
        ResourceLocation location = NBTHelper.getResourceLocation(compound, tag);
        return (T)((IForgeRegistryEntry.Impl)GameRegistry.findRegistry(registry).getValue(location));
    }

    public static void setResourceLocation(NBTTagCompound compound, String tag, ResourceLocation location) {
        compound.func_74778_a(tag, location.toString());
    }

    public static ResourceLocation getResourceLocation(NBTTagCompound compound, String tag) {
        return new ResourceLocation(compound.func_74779_i(tag));
    }

    public static void setWorld(NBTTagCompound compound, String tag, World world) {
        compound.func_74768_a(tag, world.field_73011_w.getDimension());
    }

    public static World getWorld(NBTTagCompound compound, String tag) {
        return FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER ? DimensionManager.getWorld((int)compound.func_74762_e(tag)) : Minecraft.func_71410_x().field_71439_g.field_70170_p;
    }

    public static <T extends Enum<T>> void setEnum(NBTTagCompound compound, T t, String tag) {
        compound.func_74778_a(tag, ((IStringSerializable)t).func_176610_l());
    }

    public static <T extends Enum<T>> Optional<T> getEnum(Class<T> clazz, NBTTagCompound compound, String tag) {
        String value = compound.func_74779_i(tag);
        return Stream.of(clazz.getEnumConstants()).filter(e -> ((IStringSerializable)e).func_176610_l().equals(value)).findAny();
    }

    public static NBTTagCompound getNBTTag(NBTTagCompound compound, String tag) {
        return NBTHelper.hasTag(compound, tag, 10) ? compound.func_74775_l(tag) : new NBTTagCompound();
    }

    public static Optional<NBTTagList> getNBTList(NBTTagCompound compound, String tag) {
        return NBTHelper.hasTag(compound, tag, 9) ? Optional.of(compound.func_150295_c(tag, 10)) : Optional.empty();
    }

    public static void setEntity(NBTTagCompound compound, Entity entity, String subtag) {
        NBTTagCompound nbt = NBTHelper.getNBTTag(compound, "entity");
        NBTTagCompound tag = NBTHelper.getNBTTag(nbt, subtag);
        NBTHelper.setUUID(tag, "uuid", entity.func_110124_au());
        NBTHelper.setWorld(tag, "world", entity.func_130014_f_());
        NBTHelper.setNBT(nbt, subtag, tag);
        NBTHelper.setNBT(compound, "entity", nbt);
    }

    @Nullable
    public static <T extends Entity> T getEntity(Class<T> ent, NBTTagCompound compound, String subtag) {
        NBTTagCompound nbt = NBTHelper.getNBTTag(compound, "entity");
        NBTTagCompound tag = NBTHelper.getNBTTag(nbt, subtag);
        UUID u = NBTHelper.getUUID(tag, "uuid");
        World w = NBTHelper.getWorld(tag, "world");
        return WorldHelper.getEntity(ent, w, u);
    }

    public static boolean hasUniqueID(NBTTagCompound compound, String tag) {
        return compound != null && compound.func_186855_b(tag);
    }

    public static void removeTag(NBTTagCompound compound, String tag) {
        if (compound != null && compound.func_74764_b(tag)) {
            compound.func_82580_o(tag);
        }
    }
}

