/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.api.helper;

import arekkuusu.enderskills.api.helper.TeamHelper;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public final class RayTraceHelper {
    public static boolean isBlockTrace(RayTraceResult result) {
        return result.field_72313_a == RayTraceResult.Type.BLOCK;
    }

    public static boolean isEntityTrace(@Nullable RayTraceResult result, Predicate<Entity> predicate) {
        return result != null && result.field_72313_a == RayTraceResult.Type.ENTITY && result.field_72308_g instanceof EntityLivingBase && predicate.test((Object)result.field_72308_g);
    }

    public static List<Entity> getEntitiesInCone(Entity source, double distance, double degrees, Predicate<Entity> predicate) {
        Vec3d eyesVector = source.func_174824_e(1.0f);
        Vec3d lookVector = source.func_70676_i(1.0f);
        Vec3d targetVector = eyesVector.func_72441_c(lookVector.field_72450_a * distance, lookVector.field_72448_b * distance, lookVector.field_72449_c * distance);
        AxisAlignedBB bb = new AxisAlignedBB(targetVector.field_72450_a - distance, targetVector.field_72448_b - distance, targetVector.field_72449_c - distance, targetVector.field_72450_a + distance, targetVector.field_72448_b + distance, targetVector.field_72449_c + distance);
        ArrayList entities = Lists.newArrayList();
        for (Entity entity : source.field_70170_p.func_175674_a(source, bb, predicate)) {
            if (!RayTraceHelper.isTargetCone(entity, source, degrees)) continue;
            entities.add(entity);
        }
        return entities;
    }

    public static boolean isTargetCone(Entity source, Entity target, double fov) {
        double pointBDistance;
        Vec3d pointB;
        Vec3d positionTarget = target.func_174824_e(1.0f);
        Vec3d lookTarget = target.func_70040_Z().func_72432_b();
        Vec3d positionAttacker = source.func_174824_e(1.0f);
        Vec3d origin = new Vec3d(0.0, 0.0, 0.0);
        Vec3d pointA = lookTarget.func_178787_e(positionTarget).func_178788_d(positionTarget);
        double pointADistance = pointA.func_72438_d(pointB = positionAttacker.func_178788_d(positionTarget));
        if (pointADistance < (pointBDistance = pointB.func_72438_d(origin))) {
            double b;
            double ab = pointA.field_72450_a * pointB.field_72450_a + pointA.field_72448_b * pointB.field_72448_b + pointA.field_72449_c * pointB.field_72449_c;
            double a = Math.sqrt(Math.pow(pointA.field_72450_a, 2.0) + Math.pow(pointA.field_72448_b, 2.0) + Math.pow(pointA.field_72449_c, 2.0));
            double angle = Math.acos(ab / (a * (b = Math.sqrt(Math.pow(pointB.field_72450_a, 2.0) + Math.pow(pointB.field_72448_b, 2.0) + Math.pow(pointB.field_72449_c, 2.0))))) * 57.29577951308232;
            return angle > -fov && angle < fov;
        }
        return false;
    }

    public static Optional<Entity> getEntityLookedAt(Entity source, double distance, Predicate<Entity> predicate) {
        World world = source.func_130014_f_();
        Vec3d eyesVector = source.func_174824_e(1.0f);
        Vec3d lookVector = source.func_70676_i(1.0f);
        Vec3d targetVector = eyesVector.func_72441_c(lookVector.field_72450_a * distance, lookVector.field_72448_b * distance, lookVector.field_72449_c * distance);
        RayTraceResult traceBlocks = RayTraceHelper.rayTraceBlocks(world, eyesVector, targetVector);
        if (traceBlocks != null) {
            distance = traceBlocks.field_72307_f.func_72438_d(eyesVector);
            targetVector = eyesVector.func_72441_c(lookVector.field_72450_a * distance, lookVector.field_72448_b * distance, lookVector.field_72449_c * distance);
        }
        return Optional.ofNullable(RayTraceHelper.rayTraceEntitiesExcept(world, eyesVector, targetVector, (Predicate<Entity>)Predicates.and(e -> e != source, predicate))).map(ray -> ray.field_72308_g);
    }

    public static Optional<Vec3d> getVecLookedAt(Entity source, double distance) {
        World world = source.func_130014_f_();
        Vec3d eyesVector = source.func_174824_e(1.0f);
        Vec3d lookVector = source.func_70676_i(1.0f);
        Vec3d targetVector = eyesVector.func_72441_c(lookVector.field_72450_a * distance, lookVector.field_72448_b * distance, lookVector.field_72449_c * distance);
        RayTraceResult traceBlocks = RayTraceHelper.rayTraceBlocks(world, eyesVector, targetVector);
        return Optional.of(traceBlocks != null ? traceBlocks.field_72307_f : targetVector);
    }

    public static Optional<BlockPos> getPosLookedAt(Entity source, double distance) {
        World world = source.func_130014_f_();
        Vec3d eyesVector = source.func_174824_e(1.0f);
        Vec3d lookVector = source.func_70676_i(1.0f);
        Vec3d targetVector = eyesVector.func_72441_c(lookVector.field_72450_a * distance, lookVector.field_72448_b * distance, lookVector.field_72449_c * distance);
        RayTraceResult traceBlocks = RayTraceHelper.rayTraceBlocks(world, eyesVector, targetVector);
        return Optional.ofNullable(traceBlocks != null && traceBlocks.field_72313_a == RayTraceResult.Type.BLOCK ? traceBlocks.func_178782_a() : null);
    }

    public static Optional<Entity> getEntityLookedAt(Entity source, double distance) {
        World world = source.func_130014_f_();
        Vec3d eyesVector = source.func_174824_e(1.0f);
        Vec3d lookVector = source.func_70676_i(1.0f);
        Vec3d targetVector = eyesVector.func_72441_c(lookVector.field_72450_a * distance, lookVector.field_72448_b * distance, lookVector.field_72449_c * distance);
        RayTraceResult traceBlocks = RayTraceHelper.rayTraceEntitiesExcept(world, eyesVector, targetVector, (Predicate<Entity>)((Predicate)e -> e != source));
        return Optional.ofNullable(traceBlocks != null && traceBlocks.field_72313_a == RayTraceResult.Type.ENTITY ? traceBlocks.field_72308_g : null);
    }

    public static Optional<BlockPos> getFloorLookedAt(Entity source, double distanceForward, double distanceDown) {
        World world = source.func_130014_f_();
        Vec3d eyesVector = source.func_174824_e(1.0f);
        Vec3d lookVector = source.func_70676_i(1.0f);
        Vec3d targetVector = eyesVector.func_72441_c(lookVector.field_72450_a * distanceForward, lookVector.field_72448_b * distanceForward, lookVector.field_72449_c * distanceForward);
        RayTraceResult traceBlocks = RayTraceHelper.rayTraceBlocks(world, eyesVector, targetVector);
        if (traceBlocks == null || traceBlocks.field_72313_a != RayTraceResult.Type.BLOCK) {
            Vec3d vec = traceBlocks != null ? traceBlocks.field_72307_f : targetVector;
            BlockPos pos = new BlockPos(vec);
            IBlockState state = world.func_180495_p(pos);
            int i = 0;
            while (i++ < (int)distanceDown + (int)Math.ceil(source.field_70131_O) && state.func_185890_d((IBlockAccess)world, pos) == Block.field_185506_k) {
                pos = pos.func_177977_b();
                vec = vec.func_178786_a(0.0, 1.0, 0.0);
                state = world.func_180495_p(pos);
            }
            if (state.func_185890_d((IBlockAccess)world, pos) != Block.field_185506_k) {
                traceBlocks = new RayTraceResult(vec, EnumFacing.UP, pos);
            }
        }
        return Optional.ofNullable(traceBlocks != null && traceBlocks.field_72313_a == RayTraceResult.Type.BLOCK ? traceBlocks.func_178782_a() : null);
    }

    public static RayTraceResult forwardsRaycast(Entity projectile, boolean includeEntities, boolean ignoreExcludedEntity, Entity excludedEntity) {
        double d0 = projectile.field_70165_t;
        double d1 = projectile.field_70163_u;
        double d2 = projectile.field_70161_v;
        double d3 = projectile.field_70159_w;
        double d4 = projectile.field_70181_x;
        double d5 = projectile.field_70179_y;
        World world = projectile.field_70170_p;
        Vec3d vec3d = new Vec3d(d0, d1, d2);
        Vec3d vec3d1 = new Vec3d(d0 + d3, d1 + d4, d2 + d5);
        RayTraceResult raytraceresult = world.func_147447_a(vec3d, vec3d1, false, true, false);
        if (includeEntities) {
            if (raytraceresult != null) {
                vec3d1 = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
            }
            Entity entity = null;
            List list = world.func_175674_a(projectile, projectile.func_174813_aQ().func_72321_a(d3, d4, d5).func_186662_g(1.0), Predicates.and(TeamHelper.NOT_CREATIVE, e -> e != excludedEntity));
            double d6 = 0.0;
            for (Entity entity1 : list) {
                double d7;
                AxisAlignedBB axisalignedbb;
                RayTraceResult raytraceresult1;
                if (!entity1.func_70067_L() || !ignoreExcludedEntity && entity1.func_70028_i(excludedEntity) || entity1.field_70145_X || (raytraceresult1 = (axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)0.3f)).func_72327_a(vec3d, vec3d1)) == null || !((d7 = vec3d.func_72436_e(raytraceresult1.field_72307_f)) < d6) && d6 != 0.0) continue;
                entity = entity1;
                d6 = d7;
            }
            if (entity != null) {
                raytraceresult = new RayTraceResult(entity);
            }
        }
        return raytraceresult;
    }

    @Nullable
    public static RayTraceResult rayTraceEntitiesExcept(World world, Vec3d vecFrom, Vec3d vecTo, Predicate<Entity> predicate) {
        if (!(Double.isNaN(vecFrom.field_72450_a) || Double.isNaN(vecFrom.field_72448_b) || Double.isNaN(vecFrom.field_72449_c))) {
            if (!(Double.isNaN(vecTo.field_72450_a) || Double.isNaN(vecTo.field_72448_b) || Double.isNaN(vecTo.field_72449_c))) {
                Vec3d difference = vecTo.func_178788_d(vecFrom);
                double distance = vecFrom.func_72438_d(vecTo);
                AxisAlignedBB bb = new AxisAlignedBB(new BlockPos(vecFrom)).func_72321_a(difference.field_72450_a * distance, difference.field_72448_b * distance, difference.field_72449_c * distance).func_72314_b(1.0, 1.0, 1.0);
                List list = world.func_175647_a(Entity.class, bb, predicate);
                Entity hitEntity = null;
                Vec3d hitVec = null;
                double minDistance = distance;
                for (Entity entity : list) {
                    AxisAlignedBB axisalignedbb = entity.func_174813_aQ().func_186662_g((double)entity.func_70111_Y());
                    RayTraceResult raytraceresult = axisalignedbb.func_72327_a(vecFrom, vecTo);
                    if (axisalignedbb.func_72318_a(vecFrom)) {
                        if (!(minDistance >= 0.0)) continue;
                        hitEntity = entity;
                        hitVec = raytraceresult == null ? vecFrom : raytraceresult.field_72307_f;
                        minDistance = 0.0;
                        continue;
                    }
                    if (raytraceresult == null) continue;
                    double distanceToEntity = vecFrom.func_72438_d(raytraceresult.field_72307_f);
                    if (distanceToEntity < minDistance || minDistance == 0.0) {
                        hitEntity = entity;
                        hitVec = raytraceresult.field_72307_f;
                        continue;
                    }
                    hitEntity = entity;
                    hitVec = raytraceresult.field_72307_f;
                    minDistance = distanceToEntity;
                }
                if (hitEntity != null) {
                    return new RayTraceResult(hitEntity, hitVec);
                }
                return null;
            }
            return null;
        }
        return null;
    }

    @Nullable
    public static RayTraceResult rayTraceBlocks(World world, Vec3d vecFrom, Vec3d vecTo) {
        if (!(Double.isNaN(vecFrom.field_72450_a) || Double.isNaN(vecFrom.field_72448_b) || Double.isNaN(vecFrom.field_72449_c))) {
            if (!(Double.isNaN(vecTo.field_72450_a) || Double.isNaN(vecTo.field_72448_b) || Double.isNaN(vecTo.field_72449_c))) {
                int i = MathHelper.func_76128_c((double)vecTo.field_72450_a);
                int j = MathHelper.func_76128_c((double)vecTo.field_72448_b);
                int k = MathHelper.func_76128_c((double)vecTo.field_72449_c);
                int l = MathHelper.func_76128_c((double)vecFrom.field_72450_a);
                int i1 = MathHelper.func_76128_c((double)vecFrom.field_72448_b);
                int j1 = MathHelper.func_76128_c((double)vecFrom.field_72449_c);
                BlockPos blockpos = new BlockPos(l, i1, j1);
                IBlockState iblockstate = world.func_180495_p(blockpos);
                Block block = iblockstate.func_177230_c();
                if (iblockstate.func_185890_d((IBlockAccess)world, blockpos) != Block.field_185506_k && block.func_176209_a(iblockstate, false)) {
                    return iblockstate.func_185910_a(world, blockpos, vecFrom, vecTo);
                }
                int k1 = 200;
                while (k1-- >= 0) {
                    EnumFacing enumfacing;
                    if (Double.isNaN(vecFrom.field_72450_a) || Double.isNaN(vecFrom.field_72448_b) || Double.isNaN(vecFrom.field_72449_c)) {
                        return null;
                    }
                    if (l == i && i1 == j && j1 == k) {
                        return null;
                    }
                    boolean flag2 = true;
                    boolean flag = true;
                    boolean flag1 = true;
                    double d0 = 999.0;
                    double d1 = 999.0;
                    double d2 = 999.0;
                    if (i > l) {
                        d0 = (double)l + 1.0;
                    } else if (i < l) {
                        d0 = (double)l + 0.0;
                    } else {
                        flag2 = false;
                    }
                    if (j > i1) {
                        d1 = (double)i1 + 1.0;
                    } else if (j < i1) {
                        d1 = (double)i1 + 0.0;
                    } else {
                        flag = false;
                    }
                    if (k > j1) {
                        d2 = (double)j1 + 1.0;
                    } else if (k < j1) {
                        d2 = (double)j1 + 0.0;
                    } else {
                        flag1 = false;
                    }
                    double d3 = 999.0;
                    double d4 = 999.0;
                    double d5 = 999.0;
                    double d6 = vecTo.field_72450_a - vecFrom.field_72450_a;
                    double d7 = vecTo.field_72448_b - vecFrom.field_72448_b;
                    double d8 = vecTo.field_72449_c - vecFrom.field_72449_c;
                    if (flag2) {
                        d3 = (d0 - vecFrom.field_72450_a) / d6;
                    }
                    if (flag) {
                        d4 = (d1 - vecFrom.field_72448_b) / d7;
                    }
                    if (flag1) {
                        d5 = (d2 - vecFrom.field_72449_c) / d8;
                    }
                    if (d3 == -0.0) {
                        d3 = -1.0E-4;
                    }
                    if (d4 == -0.0) {
                        d4 = -1.0E-4;
                    }
                    if (d5 == -0.0) {
                        d5 = -1.0E-4;
                    }
                    if (d3 < d4 && d3 < d5) {
                        enumfacing = i > l ? EnumFacing.WEST : EnumFacing.EAST;
                        vecFrom = new Vec3d(d0, vecFrom.field_72448_b + d7 * d3, vecFrom.field_72449_c + d8 * d3);
                    } else if (d4 < d5) {
                        enumfacing = j > i1 ? EnumFacing.DOWN : EnumFacing.UP;
                        vecFrom = new Vec3d(vecFrom.field_72450_a + d6 * d4, d1, vecFrom.field_72449_c + d8 * d4);
                    } else {
                        enumfacing = k > j1 ? EnumFacing.NORTH : EnumFacing.SOUTH;
                        vecFrom = new Vec3d(vecFrom.field_72450_a + d6 * d5, vecFrom.field_72448_b + d7 * d5, d2);
                    }
                    l = MathHelper.func_76128_c((double)vecFrom.field_72450_a) - (enumfacing == EnumFacing.EAST ? 1 : 0);
                    i1 = MathHelper.func_76128_c((double)vecFrom.field_72448_b) - (enumfacing == EnumFacing.UP ? 1 : 0);
                    j1 = MathHelper.func_76128_c((double)vecFrom.field_72449_c) - (enumfacing == EnumFacing.SOUTH ? 1 : 0);
                    blockpos = new BlockPos(l, i1, j1);
                    IBlockState state = world.func_180495_p(blockpos);
                    Block block1 = state.func_177230_c();
                    if (state.func_185890_d((IBlockAccess)world, blockpos) == Block.field_185506_k || !block1.func_176209_a(state, false)) continue;
                    return state.func_185910_a(world, blockpos, vecFrom, vecTo);
                }
                return null;
            }
            return null;
        }
        return null;
    }
}

