/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.api.helper;

import net.minecraft.entity.player.EntityPlayer;

public class XPHelper {
    public static int takeXP(EntityPlayer player, int xp) {
        int total = XPHelper.getXPTotal(player);
        int taken = Math.min(xp, total);
        XPHelper.setXP(player, total -= taken);
        return taken;
    }

    public static void giveXP(EntityPlayer player, int xp) {
        XPHelper.setXP(player, XPHelper.getXPTotal(player) + xp);
    }

    public static void setXP(EntityPlayer player, int xp) {
        player.field_71068_ca = Math.max(XPHelper.getLevelFromXPValue(xp), 0);
        player.field_71106_cc = Math.max(XPHelper.getLevelProgressFromXPValue(xp), 0.0f);
        player.field_71067_cb = xp;
    }

    public static int getXPTotal(int level, double current) {
        return (int)((double)XPHelper.getXPValueFromLevel(level) + (double)XPHelper.getXPValueToNextLevel(level) * current);
    }

    public static int getXPTotal(EntityPlayer player) {
        return (int)((float)XPHelper.getXPValueFromLevel(player.field_71068_ca) + (float)XPHelper.getXPValueToNextLevel(player.field_71068_ca) * player.field_71106_cc);
    }

    public static int getLevelFromXPValue(int value) {
        int level = value >= XPHelper.getXPValueFromLevel(30) ? (int)(0.07142857142857142 * (Math.sqrt(56.0 * (double)value - 32511.0) + 303.0)) : (value >= XPHelper.getXPValueFromLevel(15) ? (int)(0.16666666666666666 * (Math.sqrt(24.0 * (double)value - 5159.0) + 59.0)) : (int)((double)value / 17.0));
        return level;
    }

    public static float getLevelProgressFromXPValue(int value) {
        if (value == 0) {
            return 0.0f;
        }
        int level = XPHelper.getLevelFromXPValue(value);
        float needed = XPHelper.getXPValueFromLevel(level);
        float next = XPHelper.getXPValueToNextLevel(level);
        float difference = (float)value - needed;
        return difference / next;
    }

    public static int getXPValueFromLevel(int level) {
        int val = level >= 30 ? (int)(3.5 * Math.pow(level, 2.0) - 151.5 * (double)level + 2220.0) : (level >= 15 ? (int)(1.5 * Math.pow(level, 2.0) - 29.5 * (double)level + 360.0) : 17 * level);
        return val;
    }

    public static int getXPValueToNextLevel(int level) {
        int val = level >= 30 ? 7 * level - 148 : (level >= 15 ? 3 * level - 28 : 17);
        return val;
    }
}

