/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.api.registry;

import arekkuusu.enderskills.api.capability.Capabilities;
import arekkuusu.enderskills.api.capability.data.SkillData;
import arekkuusu.enderskills.api.capability.data.SkillHolder;
import arekkuusu.enderskills.api.capability.data.SkillInfo;
import arekkuusu.enderskills.common.network.PacketHelper;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Skill
extends IForgeRegistryEntry.Impl<Skill> {
    private final Properties properties;

    public Skill(Properties properties) {
        this.properties = properties;
    }

    public void use(EntityLivingBase entity, SkillInfo skillInfo) {
    }

    public void begin(EntityLivingBase entity, SkillData data) {
    }

    public void update(EntityLivingBase entity, SkillData data, int tick) {
    }

    public void end(EntityLivingBase entity, SkillData data) {
    }

    public void apply(EntityLivingBase entity, SkillData data) {
        Capabilities.get((Entity)entity).ifPresent(skills -> skills.activate(new SkillHolder(data)));
    }

    public void unapply(EntityLivingBase entity) {
        Capabilities.get((Entity)entity).ifPresent(skills -> skills.deactivate(this));
    }

    public void unapply(EntityLivingBase entity, SkillData data) {
        Capabilities.get((Entity)entity).ifPresent(skills -> skills.deactivate(this, data));
    }

    public void sync(EntityLivingBase entity, SkillData data) {
        PacketHelper.sendSkillUseResponsePacket(entity, data);
    }

    public void async(EntityLivingBase entity) {
        PacketHelper.sendSkillRemoveResponsePacket(entity, this);
    }

    public void async(EntityLivingBase entity, SkillData data) {
        PacketHelper.sendSkillDataRemoveResponsePacket(entity, data);
    }

    public void sync(EntityLivingBase entity) {
        PacketHelper.sendSkillSync((EntityPlayerMP)entity, this);
    }

    public Properties getProperties() {
        return this.properties;
    }

    @Nonnull
    @Deprecated
    public SkillInfo createInfo(NBTTagCompound compound) {
        return new SkillInfo(compound);
    }

    public static class Properties {
        boolean isKeyBound;
        boolean hasStatusIcon;
        boolean hasTexture;

        public boolean isKeyBound() {
            return this.isKeyBound;
        }

        public Properties setKeyBound() {
            this.isKeyBound = true;
            return this;
        }

        public boolean hasStatusIcon() {
            return this.hasStatusIcon;
        }

        public Properties setHasStatusIcon() {
            this.hasStatusIcon = true;
            return this;
        }

        public boolean hasTexture() {
            return this.hasTexture;
        }

        public Properties setHasTexture() {
            this.hasTexture = true;
            return this;
        }
    }
}

