/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.api.util;

import arekkuusu.enderskills.api.util.Quat;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class Vector {
    public static final Vector ZERO = new Vector(0.0, 0.0, 0.0);
    public static final Vector ONE = new Vector(1.0, 1.0, 1.0);
    public static final Vector X = new Vector(1.0, 0.0, 0.0);
    public static final Vector Y = new Vector(0.0, 1.0, 0.0);
    public static final Vector Z = new Vector(0.0, 0.0, 1.0);
    public static final Vector Forward = new Vector(0.0, 0.0, 1.0);
    public static final Vector Left = new Vector(-1.0, 0.0, 0.0);
    public static final Vector Right = new Vector(1.0, 0.0, 0.0);
    public static final Vector Backward = new Vector(0.0, 0.0, -1.0);
    public final double x;
    public final double y;
    public final double z;

    public Vector(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector(BlockPos pos) {
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
    }

    public Vector(Vec3d vec3d) {
        this.x = vec3d.field_72450_a;
        this.y = vec3d.field_72448_b;
        this.z = vec3d.field_72449_c;
    }

    public Vector subtract(Vector vec) {
        return this.addVector(-vec.x, -vec.y, -vec.z);
    }

    public Vector add(Vector vec) {
        return this.addVector(vec.x, vec.y, vec.z);
    }

    public Vector addVector(double x, double y, double z) {
        return new Vector(this.x + x, this.y + y, this.z + z);
    }

    public Vector multiply(Vector vec) {
        return new Vector(this.x * vec.x, this.y * vec.y, this.z * vec.z);
    }

    public Vector multiply(double factor) {
        return new Vector(this.x * factor, this.y * factor, this.z * factor);
    }

    public Vector divide(double divisor) {
        return new Vector(this.x / divisor, this.y / divisor, this.z / divisor);
    }

    public Vector cross(Vector vec) {
        return this.cross(vec.x, vec.y, vec.z);
    }

    public Vector cross(double x, double y, double z) {
        double newX = this.y * z - this.z * y;
        double newY = this.z * x - this.x * z;
        double newZ = this.x * y - this.y * x;
        return new Vector(newX, newY, newZ);
    }

    public Vector normalize() {
        double d0 = MathHelper.func_76133_a((double)(this.x * this.x + this.y * this.y + this.z * this.z));
        return d0 < 1.0E-4 ? ZERO : new Vector(this.x / d0, this.y / d0, this.z / d0);
    }

    public Vector offset(Vector direction, double distance) {
        return this.add(direction.multiply(distance));
    }

    public Vector perpendicular() {
        if (this.z == 0.0) {
            double d = this.y;
            double d1 = -this.x;
            return new Vector(d, d1, 0.0);
        }
        double d = this.z;
        double d1 = -this.y;
        return new Vector(0.0, d, d1);
    }

    public Vector rotate(Quat quaternion) {
        double vx = this.x;
        double vy = this.y;
        double vz = this.z;
        double rx = quaternion.x;
        double ry = quaternion.y;
        double rz = quaternion.z;
        double rw = quaternion.w;
        double tx = 2.0 * (ry * vz - rz * vy);
        double ty = 2.0 * (rz * vx - rx * vz);
        double tz = 2.0 * (rx * vy - ry * vx);
        double cx = ry * tz - rz * ty;
        double cy = rz * tx - rx * tz;
        double cz = rx * ty - ry * tx;
        double newX = vx + rw * tx + cx;
        double newY = vy + rw * ty + cy;
        double newZ = vz + rw * tz + cz;
        return new Vector(newX, newY, newZ);
    }

    public Vector rotateRandom(Random random, float angle) {
        Quat quatX = Quat.fromAxisAngleRad(X, (random.nextFloat() - 0.5f) * angle * (float)Math.PI / 180.0f);
        Quat quatY = Quat.fromAxisAngleRad(Y, (random.nextFloat() - 0.5f) * angle * (float)Math.PI / 180.0f);
        Quat quatZ = Quat.fromAxisAngleRad(Z, (random.nextFloat() - 0.5f) * angle * (float)Math.PI / 180.0f);
        Quat rotation = quatX.multiply(quatY).multiply(quatZ);
        return this.rotate(rotation);
    }

    public static Vector fromSpherical(double yaw, double pitch) {
        double clampedPitch = pitch > 90.0 || pitch < -90.0 ? Math.IEEEremainder(pitch, 180.0) : pitch;
        double clampedYaw = yaw > 180.0 || yaw < -180.0 ? Math.IEEEremainder(yaw, 360.0) : yaw;
        return Vector.fromSphericalRad((float)Math.toRadians(clampedYaw), (float)Math.toRadians(clampedPitch));
    }

    public static Vector fromSphericalRad(float yaw, float pitch) {
        double sinYaw = MathHelper.func_76126_a((float)yaw);
        double sinPitch = MathHelper.func_76126_a((float)pitch);
        double cosYaw = MathHelper.func_76134_b((float)yaw);
        double cosPitch = MathHelper.func_76134_b((float)pitch);
        return new Vector(-sinYaw * cosPitch, -sinPitch, cosYaw * cosPitch);
    }

    public double toYaw() {
        return Math.atan2(this.x, this.z) * (double)57.29578f - 90.0;
    }

    public double toPitch() {
        return MathHelper.func_181159_b((double)this.y, (double)MathHelper.func_76133_a((double)(this.x * this.x + this.z * this.z))) * 57.29577951308232;
    }

    public Vec3d toVec3d() {
        return new Vec3d(this.x, this.y, this.z);
    }

    public Vector copy() {
        return new Vector(this.x, this.y, this.z);
    }
}

