/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.client;

import net.minecraft.world.BossInfo;
import net.minecraftforge.common.config.Config;

@Config(modid="enderskills", name="enderskills/client")
public final class ClientConfig {
    @Config.LangKey(value="enderskills.config.render")
    public static RenderValues RENDER_CONFIG = new RenderValues();

    public static class RenderValues {
        public final SkillGroup skillGroup = new SkillGroup();
        public final Endurance endurance = new Endurance();
        public final Rendering rendering = new Rendering();

        public static enum Orientation {
            VERTICAL,
            HORIZONTAL;

        }

        public static class Rendering {
            @Config.Comment(value={"Use vanilla render effects on the more fancy renders (for low end graphics cards)"})
            public boolean vanilla = false;
            @Config.Comment(value={"Check this if even the vanilla renders are killing your fps"})
            public boolean helpMyFramesAreDying = false;
            @Config.Comment(value={"Check this if shaders are broken to turn them off"})
            public boolean helpMyShadersAreDying = false;
            @Config.Comment(value={"Particle Spawning Chance"})
            @Config.RangeDouble(min=0.0, max=1.0)
            @Config.SlidingOption
            public double particleSpawning = 1.0;
        }

        public static class Endurance {
            public boolean renderOverlay = true;
            public double scale = 1.0;
            public int size = 182;
            public int posX = 5;
            public int posY = 5;
            public BossInfo.Color color = BossInfo.Color.BLUE;
            public BossInfo.Overlay overlay = BossInfo.Overlay.NOTCHED_20;
            public Orientation orientation = Orientation.HORIZONTAL;
        }

        public static class SkillGroup {
            public boolean renderUnowned = false;
            public boolean renderOverlay = true;
            public boolean renderControls = true;
            public double scale = 1.0;
            public int posX = 5;
            public int posY = 50;
            public int step = 17;
            public boolean inverse = false;
            public Orientation orientation = Orientation.VERTICAL;
        }
    }
}

