/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.client.gui.data;

import arekkuusu.enderskills.api.capability.AdvancementCapability;
import arekkuusu.enderskills.api.capability.Capabilities;
import arekkuusu.enderskills.client.gui.GuiScreenSkillAdvancements;
import arekkuusu.enderskills.client.gui.data.ISkillAdvancement;
import arekkuusu.enderskills.client.gui.data.SkillAdvancementCondition;
import arekkuusu.enderskills.client.gui.data.SkillAdvancementInfo;
import arekkuusu.enderskills.client.gui.widgets.GuiConfirmation;
import arekkuusu.enderskills.common.network.PacketHelper;
import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;

public class SkillAdvancementConditionSimple
extends SkillAdvancementCondition {
    public final Set<SkillAdvancementCondition> conditions = Sets.newLinkedHashSet();
    public final SkillAdvancementInfo info;
    public final int row;
    public final int column;

    public SkillAdvancementConditionSimple(SkillAdvancementInfo info, int row, int column) {
        this.info = info;
        this.row = row;
        this.column = column;
    }

    @Override
    public boolean canUpgrade() {
        return this.conditions.isEmpty() || this.conditions.stream().allMatch(SkillAdvancementCondition::isUpgraded);
    }

    @Override
    public boolean isUpgraded() {
        return Capabilities.get((Entity)Minecraft.func_71410_x().field_71439_g).filter(c -> c.isOwned(this.info.skill)).isPresent();
    }

    public boolean upgrade() {
        if (this.info.skill instanceof ISkillAdvancement) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            ISkillAdvancement.Requirement requirement = ((ISkillAdvancement)((Object)this.info.skill)).getRequirement((EntityLivingBase)player);
            Optional<AdvancementCapability> capability = Capabilities.advancement((Entity)player);
            if (capability.isPresent()) {
                AdvancementCapability c = capability.get();
                if (c.level >= requirement.getLevels() && c.getExperienceTotal((EntityLivingBase)player) >= requirement.getXp()) {
                    PacketHelper.sendSkillUpgradeRequestPacket(Minecraft.func_71410_x().field_71439_g, this.info.skill);
                    return true;
                }
                String title = this.isUpgraded() ? "Can't upgrade" : "Can't Unlock";
                String description = "\u00a74Not enough funds.\u00a7r";
                GuiScreenSkillAdvancements.confirmation = new GuiConfirmation(Minecraft.func_71410_x(), title, description, g -> {}, false, true, false);
                GuiScreenSkillAdvancements.confirmation.initGui();
                return false;
            }
        } else {
            PacketHelper.sendSkillUpgradeRequestPacket(Minecraft.func_71410_x().field_71439_g, this.info.skill);
            return true;
        }
        return false;
    }

    public void addCondition(SkillAdvancementCondition advancement) {
        this.conditions.add(advancement);
    }
}

