/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.client.gui.widgets;

import arekkuusu.enderskills.client.gui.GuiScreenSkillAdvancements;
import arekkuusu.enderskills.client.gui.widgets.GuiCustomButton;
import arekkuusu.enderskills.client.util.helper.RenderMisc;
import arekkuusu.enderskills.client.util.helper.TextHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;

public class GuiConfirmation
extends Gui {
    public GuiButton buttonYes;
    public GuiButton buttonNo;
    public final Consumer<GuiConfirmation> function;
    public final Minecraft mc;
    public final String title;
    public final boolean canConfirm;
    public final boolean canNegate;
    public final boolean isShifting;
    public final String description;
    public boolean allowUserInput;
    public int timer;
    public int width;
    public int height;
    public int x;
    public int y;

    public GuiConfirmation(Minecraft mc, String title, String description, Consumer<GuiConfirmation> function, boolean canConfirm, boolean canNegate, boolean isShifting) {
        this.mc = mc;
        this.function = function;
        this.description = description;
        this.title = title;
        this.canConfirm = canConfirm;
        this.canNegate = canNegate;
        this.isShifting = isShifting;
        this.allowUserInput = true;
        this.timer = 5;
    }

    public void initGui() {
        ScaledResolution scaledresolution = new ScaledResolution(this.mc);
        this.width = scaledresolution.func_78326_a();
        this.height = scaledresolution.func_78328_b();
        this.x = this.width / 2;
        this.y = this.height / 2;
        int titleWidth = this.mc.field_71466_p.func_78256_a(this.title);
        List<String> descriptionLines = this.getDescriptionLines();
        ArrayList<String> descriptionFormattedLines = new ArrayList<String>();
        for (String descriptionLine : descriptionLines) {
            int s = this.mc.field_71466_p.func_78256_a(descriptionLine);
            if (titleWidth >= s) continue;
            titleWidth = s;
        }
        for (String descriptionLine : descriptionLines) {
            if (!descriptionLine.isEmpty()) {
                descriptionFormattedLines.addAll(TextHelper.findOptimalLines(this.mc, descriptionLine, titleWidth));
                continue;
            }
            descriptionFormattedLines.add("");
        }
        this.buttonYes = new GuiCustomButton(0, this.x - 25, this.y + 5 + descriptionFormattedLines.size() * this.mc.field_71466_p.field_78288_b, 12, 10, "", 35, 107, 12, 10, 0);
        this.buttonNo = new GuiCustomButton(1, this.x + 13, this.y + 5 + descriptionFormattedLines.size() * this.mc.field_71466_p.field_78288_b, 11, 11, "", 47, 108, 11, 11, 0);
        this.buttonYes.field_146124_l = false;
        this.buttonNo.field_146124_l = false;
    }

    public void update() {
        if (this.timer > 0) {
            --this.timer;
        }
        if (this.timer == 0) {
            this.buttonYes.field_146124_l = this.allowUserInput && this.canConfirm;
            this.buttonNo.field_146124_l = this.allowUserInput && this.canNegate;
        }
    }

    public void drawGui(int mouseX, int mouseY, float partialTicks) {
        this.func_73733_a(0, 0, this.mc.field_71443_c, this.mc.field_71440_d, -1072689136, -804253680);
        this.mc.field_71446_o.func_110577_a(GuiScreenSkillAdvancements.WIDGETS);
        int titleWidth = this.mc.field_71466_p.func_78256_a(this.title);
        ArrayList<String> descriptionLines = Lists.newArrayList((Object[])this.description.split("\n"));
        ArrayList<String> descriptionFormattedLines = new ArrayList<String>();
        for (String string : descriptionLines) {
            int s = this.mc.field_71466_p.func_78256_a(string);
            if (titleWidth >= s) continue;
            titleWidth = s;
        }
        boolean recalculateWidth = false;
        if (titleWidth > this.width / 3) {
            titleWidth = this.width / 3;
            recalculateWidth = true;
        }
        for (String descriptionLine : descriptionLines) {
            if (!descriptionLine.isEmpty()) {
                descriptionFormattedLines.addAll(TextHelper.findOptimalLines(this.mc, descriptionLine, titleWidth));
                continue;
            }
            descriptionFormattedLines.add("");
        }
        descriptionLines = descriptionFormattedLines;
        if (recalculateWidth) {
            titleWidth = this.mc.field_71466_p.func_78256_a(this.title);
            for (String descriptionLine : descriptionLines) {
                int s = this.mc.field_71466_p.func_78256_a(descriptionLine);
                if (titleWidth >= s) continue;
                titleWidth = s;
            }
        }
        int n = Math.max(titleWidth + 8, 50);
        int xOffset = this.x - n / 2;
        int yOffset = this.y - 26;
        RenderMisc.draw8Rect(xOffset, yOffset, n, 50 + descriptionLines.size() * this.mc.field_71466_p.field_78288_b);
        this.func_73729_b(xOffset - 4, yOffset + 3, 0, 103, 4, 26);
        GuiConfirmation.func_152125_a((int)xOffset, (int)(yOffset + 3), (float)5.0f, (float)103.0f, (int)1, (int)26, (int)n, (int)26, (float)256.0f, (float)256.0f);
        this.func_73729_b(xOffset + n, yOffset + 3, 7, 103, 4, 26);
        if (this.isShifting) {
            GuiConfirmation.func_152125_a((int)(xOffset - 7), (int)(yOffset - 5), (float)82.0f, (float)4.0f, (int)18, (int)18, (int)14, (int)14, (float)256.0f, (float)256.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179094_E();
            GlStateManager.func_179139_a((double)0.6, (double)0.6, (double)0.6);
            this.mc.field_71466_p.func_175065_a(TextHelper.translate("gui.advancement.locked", new Object[0]), (float)(xOffset + 9) / 0.6f, (float)(yOffset - 1) / 0.6f, -1, true);
            double mSize = Math.pow(0.6, -1.0);
            GlStateManager.func_179139_a((double)mSize, (double)mSize, (double)mSize);
            GlStateManager.func_179121_F();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.field_71466_p.func_175065_a(this.title, (float)(xOffset + 4), (float)(yOffset + 9), -1, true);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int i = 0; i < descriptionLines.size(); ++i) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.mc.field_71466_p.func_175065_a((String)descriptionLines.get(i), (float)(xOffset + 4), (float)(yOffset + 9 + 17 + i * this.mc.field_71466_p.field_78288_b), -1, false);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        this.buttonYes.func_191745_a(this.mc, mouseX, mouseY, partialTicks);
        this.buttonNo.func_191745_a(this.mc, mouseX, mouseY, partialTicks);
    }

    public List<String> getDescriptionLines() {
        int titleWidth = this.mc.field_71466_p.func_78256_a(this.title);
        ArrayList<String> descriptionLines = Lists.newArrayList((Object[])this.description.split("\n"));
        ArrayList<String> descriptionFormattedLines = new ArrayList<String>();
        for (String descriptionLine : descriptionLines) {
            int s = this.mc.field_71466_p.func_78256_a(descriptionLine) - 25;
            if (titleWidth >= s) continue;
            titleWidth = s;
        }
        if (titleWidth > this.width / 3) {
            titleWidth = this.width / 3;
        }
        for (String descriptionLine : descriptionLines) {
            if (!descriptionLine.isEmpty()) {
                descriptionFormattedLines.addAll(TextHelper.findOptimalLines(this.mc, descriptionLine, titleWidth + 20));
                continue;
            }
            descriptionFormattedLines.add("");
        }
        descriptionLines = descriptionFormattedLines;
        return descriptionLines;
    }

    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0) {
            if (this.canConfirm && this.buttonYes.func_146116_c(this.mc, mouseX, mouseY)) {
                this.buttonYes.func_146113_a(this.mc.func_147118_V());
                this.actionPerformed(this.buttonYes);
            }
            if (this.canNegate && this.buttonNo.func_146116_c(this.mc, mouseX, mouseY)) {
                this.buttonNo.func_146113_a(this.mc.func_147118_V());
                this.actionPerformed(this.buttonNo);
            }
        }
    }

    public void actionPerformed(GuiButton button) {
        if (button.field_146127_k == 0 || button.field_146127_k == 1) {
            GuiScreenSkillAdvancements.confirmation = null;
        }
        if (button.field_146127_k == 0) {
            this.confirm();
        }
        this.allowUserInput = false;
    }

    public void confirm() {
        this.mc.func_152344_a(() -> this.function.accept(this));
    }
}

