/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.client.gui.widgets;

import java.util.Random;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;

public enum SkillAdvancementTabType {
    ABOVE(0, 0, 28, 32, 8),
    BELOW(84, 0, 28, 32, 8),
    LEFT(0, 65, 32, 28, 5),
    RIGHT(96, 65, 32, 28, 5);

    public static final int MAX_TABS;
    private final int textureX;
    private final int textureY;
    private final int width;
    private final int height;
    private final int max;

    private SkillAdvancementTabType(int textureX, int textureY, int widthIn, int heightIn, int max) {
        this.textureX = textureX;
        this.textureY = textureY;
        this.width = widthIn;
        this.height = heightIn;
        this.max = max;
    }

    public int getMax() {
        return this.max;
    }

    public void draw(Gui guiIn, int x, int y, boolean selected, int index, int color) {
        long seed = 0L;
        Random random = new Random(seed += (long)(index + color));
        int variation = random.nextInt(2);
        int i = this.textureX + this.width * variation;
        float r = (float)(color >>> 16 & 0xFF) / 256.0f;
        float g = (float)(color >>> 8 & 0xFF) / 256.0f;
        float b = (float)(color & 0xFF) / 256.0f;
        int j = selected ? this.textureY + this.height : this.textureY;
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)1.0f);
        guiIn.func_73729_b(x + this.getX(index), y + this.getY(index), i, j, this.width, this.height);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public int getX(int index) {
        switch (this) {
            case ABOVE: {
                return 7 + this.width * index;
            }
            case BELOW: {
                return 14 + this.width * index;
            }
            case LEFT: {
                return -this.width + 10;
            }
            case RIGHT: {
                return 242;
            }
        }
        throw new UnsupportedOperationException("Don't know what this tab type is!" + (Object)((Object)this));
    }

    public int getY(int index) {
        switch (this) {
            case ABOVE: {
                return -this.height + 9;
            }
            case BELOW: {
                return 159;
            }
            case LEFT: 
            case RIGHT: {
                return 7 + this.height * index;
            }
        }
        throw new UnsupportedOperationException("Don't know what this tab type is!" + (Object)((Object)this));
    }

    public boolean isMouseOver(int p_192654_1_, int p_192654_2_, int p_192654_3_, int p_192654_4_, int p_192654_5_) {
        int i = p_192654_1_ + this.getX(p_192654_3_);
        int j = p_192654_2_ + this.getY(p_192654_3_);
        return p_192654_4_ > i && p_192654_4_ < i + this.width && p_192654_5_ > j && p_192654_5_ < j + this.height;
    }

    static {
        int i = 0;
        for (SkillAdvancementTabType tab : SkillAdvancementTabType.values()) {
            i += tab.max;
        }
        MAX_TABS = i;
    }
}

