/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.client.proxy;

import arekkuusu.enderskills.api.registry.Skill;
import arekkuusu.enderskills.api.util.Vector;
import arekkuusu.enderskills.client.ClientConfig;
import arekkuusu.enderskills.client.keybind.KeyBounds;
import arekkuusu.enderskills.client.proxy.Events;
import arekkuusu.enderskills.client.render.ModRenders;
import arekkuusu.enderskills.client.render.effect.Lightning;
import arekkuusu.enderskills.client.render.effect.LightningManager;
import arekkuusu.enderskills.client.render.effect.ParticleBase;
import arekkuusu.enderskills.client.render.effect.ParticleLuminescence;
import arekkuusu.enderskills.client.render.effect.ParticleManager;
import arekkuusu.enderskills.client.util.ResourceLibrary;
import arekkuusu.enderskills.client.util.ShaderLibrary;
import arekkuusu.enderskills.client.util.SpriteLibrary;
import arekkuusu.enderskills.client.util.helper.ModelHelper;
import arekkuusu.enderskills.client.util.helper.RenderMisc;
import arekkuusu.enderskills.client.util.resource.ShaderManager;
import arekkuusu.enderskills.common.proxy.IProxy;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(modid="enderskills", value={Side.CLIENT})
public class ClientProxy
implements IProxy {
    public static final ParticleManager PARTICLE_RENDERER = new ParticleManager();
    public static final LightningManager LIGHTNING_MANAGER = new LightningManager();

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        ModelHelper.registerModels();
    }

    @SubscribeEvent
    public static void stitchTextures(TextureStitchEvent event) {
        TextureMap map = event.getMap();
        ResourceLibrary.ATLAS_SET.forEach(arg_0 -> ((TextureMap)map).func_174942_a(arg_0));
        for (Map.Entry entry : GameRegistry.findRegistry(Skill.class).getEntries()) {
            if (!((Skill)((Object)entry.getValue())).getProperties().hasTexture()) continue;
            map.func_174942_a(ResourceLibrary.createAtlasTexture(((ResourceLocation)entry.getKey()).func_110624_b(), "skills", ((ResourceLocation)entry.getKey()).func_110623_a()));
        }
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)ShaderManager.INSTANCE);
        SpriteLibrary.preInit();
        ModRenders.preInit();
    }

    @Override
    public void init(FMLInitializationEvent event) {
        KeyBounds.init();
        ShaderLibrary.init();
        ModRenders.init();
        RenderMisc.init();
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        ModRenders.postInit();
    }

    @Override
    public EntityPlayer getPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public void addToQueue(Runnable runnable) {
        Events.QUEUE.add(runnable);
    }

    @Override
    public void spawnParticle(World world, Vec3d pos, Vec3d speed, float scale, int age, int rgb, ResourceLocation location) {
        if (ClientProxy.canParticleSpawn()) {
            PARTICLE_RENDERER.add(new ParticleBase(world, pos, speed, scale, age, rgb, location));
        }
    }

    @Override
    public void spawnParticleLuminescence(World world, Vec3d pos, Vec3d speed, float scale, int age, ResourceLocation location) {
        if (ClientProxy.canParticleSpawn()) {
            PARTICLE_RENDERER.add(new ParticleLuminescence(world, pos, speed, scale, age, location));
        }
    }

    @Override
    public void spawnLightning(World world, Vector from, Vector to, int generations, float offset, int age, int rgb, boolean branch) {
        LIGHTNING_MANAGER.add(new Lightning(from, to, generations, offset, age, rgb, branch));
    }

    @Override
    public void playSound(World world, Vec3d vec, SoundEvent event, SoundCategory category, float volume) {
        float pitch = (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f;
        world.func_184134_a(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, event, category, volume, pitch, false);
    }

    public static boolean canParticleSpawn() {
        float chance;
        int setting = Minecraft.func_71410_x().field_71474_y.field_74362_aa;
        switch (setting) {
            case 1: {
                chance = 0.6f * (float)ClientConfig.RENDER_CONFIG.rendering.particleSpawning;
                break;
            }
            case 2: {
                chance = 0.2f * (float)ClientConfig.RENDER_CONFIG.rendering.particleSpawning;
                break;
            }
            default: {
                chance = (float)ClientConfig.RENDER_CONFIG.rendering.particleSpawning;
            }
        }
        return Math.random() < (double)chance;
    }

    public static boolean isOptifineInstalled() {
        return FMLClientHandler.instance().hasOptifine();
    }
}

