/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.client.proxy;

import arekkuusu.enderskills.api.capability.Capabilities;
import arekkuusu.enderskills.api.capability.SkillGroupCapability;
import arekkuusu.enderskills.api.capability.SkilledEntityCapability;
import arekkuusu.enderskills.api.capability.data.SkillGroup;
import arekkuusu.enderskills.api.capability.data.SkillHolder;
import arekkuusu.enderskills.api.capability.data.SkillInfo;
import arekkuusu.enderskills.api.event.SkillUpgradeSyncEvent;
import arekkuusu.enderskills.api.helper.NBTHelper;
import arekkuusu.enderskills.api.registry.Skill;
import arekkuusu.enderskills.client.ClientConfig;
import arekkuusu.enderskills.client.gui.GuiScreenSkillAdvancements;
import arekkuusu.enderskills.client.keybind.KeyBounds;
import arekkuusu.enderskills.client.proxy.ClientProxy;
import arekkuusu.enderskills.client.render.skill.SkillRendererDispatcher;
import arekkuusu.enderskills.client.util.ResourceLibrary;
import arekkuusu.enderskills.client.util.helper.TextHelper;
import arekkuusu.enderskills.common.network.PacketHelper;
import arekkuusu.enderskills.common.skill.attribute.mobility.Endurance;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="enderskills", value={Side.CLIENT})
public class Events {
    public static boolean hideOverlay = false;
    public static int skillGroupPrev = 0;
    public static int skillGroup = 0;
    public static String skillGroupName = "";
    public static EnumFacing.AxisDirection rotate = EnumFacing.AxisDirection.POSITIVE;
    public static final Queue<Runnable> QUEUE = new LinkedList<Runnable>();

    @SubscribeEvent
    public static void onSkillUpgradeSync(SkillUpgradeSyncEvent event) {
        if (GuiScreenSkillAdvancements.onSkillUpgradeRunnable != null) {
            GuiScreenSkillAdvancements.onSkillUpgradeRunnable.run();
            GuiScreenSkillAdvancements.onSkillUpgradeRunnable = null;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onKeyPressHideOverlay(InputEvent.KeyInputEvent event) {
        if (KeyBounds.hideOverlay.func_151468_f()) {
            hideOverlay = !hideOverlay;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onKeyPress(InputEvent.KeyInputEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        Capabilities.get((Entity)player).ifPresent(skills -> Capabilities.weight((Entity)player).ifPresent(weight -> {
            if (KeyBounds.skillGroupRotateLeft.func_151468_f()) {
                Events.rotateSkillGroup(weight, true);
                List<Tuple<Skill, SkillInfo>> display = Events.getGroup(skills, weight);
                if (!display.isEmpty()) {
                    player.func_146105_b((ITextComponent)TextHelper.getTextComponent("rotate_skill_group", skillGroupName), true);
                }
                rotate = EnumFacing.AxisDirection.NEGATIVE;
                return;
            }
            if (KeyBounds.skillGroupRotateRight.func_151468_f()) {
                Events.rotateSkillGroup(weight, false);
                List<Tuple<Skill, SkillInfo>> display = Events.getGroup(skills, weight);
                if (!display.isEmpty()) {
                    player.func_146105_b((ITextComponent)TextHelper.getTextComponent("rotate_skill_group", skillGroupName), true);
                }
                rotate = EnumFacing.AxisDirection.POSITIVE;
                return;
            }
            List<KeyBinding> skillUseList = KeyBounds.skillUseList;
            for (int i = 0; i < skillUseList.size(); ++i) {
                KeyBinding binding = skillUseList.get(i);
                if (!binding.func_151468_f()) continue;
                List<Tuple<Skill, SkillInfo>> display = Events.getGroup(skills, weight);
                if (i + 1 > display.size()) {
                    return;
                }
                Skill skill = (Skill)((Object)((Object)((Object)display.get(i).func_76341_a())));
                if (!skill.getProperties().isKeyBound()) break;
                PacketHelper.sendSkillUseRequestPacket(player, skill);
                break;
            }
        }));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onGroupRender(RenderGameOverlayEvent.Post event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        Minecraft mc = Minecraft.func_71410_x();
        if (!ClientConfig.RENDER_CONFIG.skillGroup.renderOverlay || mc.field_71441_e == null || event.getType() != RenderGameOverlayEvent.ElementType.EXPERIENCE || mc.func_147113_T()) {
            return;
        }
        Capabilities.get((Entity)player).ifPresent(skills -> Capabilities.weight((Entity)player).ifPresent(weight -> {
            if (!ClientConfig.RENDER_CONFIG.skillGroup.renderUnowned && skills.getAllOwned().isEmpty()) {
                return;
            }
            List<Tuple<Skill, SkillInfo>> display = Events.getGroup(skills, weight);
            if (!ClientConfig.RENDER_CONFIG.skillGroup.renderUnowned && display.isEmpty()) {
                if (!weight.skillGroupMap.isEmpty()) {
                    Events.rotateSkillGroup(weight, rotate == EnumFacing.AxisDirection.NEGATIVE);
                    display = Events.getGroup(skills, weight);
                    if (!display.isEmpty()) {
                        player.func_146105_b((ITextComponent)TextHelper.getTextComponent("rotate_skill_group", skillGroupName), true);
                    }
                }
                return;
            }
            if (hideOverlay) {
                return;
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            boolean horizontal = ClientConfig.RENDER_CONFIG.skillGroup.orientation == ClientConfig.RenderValues.Orientation.HORIZONTAL;
            double scale = ClientConfig.RENDER_CONFIG.skillGroup.scale;
            double mSize = Math.pow(scale, -1.0);
            int size = (int)(scale * 16.0);
            int posX = ClientConfig.RENDER_CONFIG.skillGroup.posX + 1;
            int posY = ClientConfig.RENDER_CONFIG.skillGroup.posY + 1;
            int i = ClientConfig.RENDER_CONFIG.skillGroup.inverse ? display.size() : 0;
            int step = ClientConfig.RENDER_CONFIG.skillGroup.step;
            int x = (int)((double)posX / scale);
            int y = (int)((double)posY / scale);
            GlStateManager.func_179094_E();
            GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
            mc.func_110434_K().func_110577_a(ResourceLibrary.SKILL_BACKGROUND);
            if (horizontal) {
                Events.drawTexturedRectangle(x, y, 0, 32, 5, size * 2, 5, 32, 64);
                Events.drawTexturedRectangle(x + 5, y, 6, 32, display.size() * step - 3, size * 2, 20, 32, 64);
                Events.drawTexturedRectangle(display.size() * step + x + 2, y, 27, 32, 5, size * 2, 5, 32, 64);
            } else {
                Events.drawTexturedRectangle(x, y, 0, 0, size * 2, 5, 32, 5, 64);
                Events.drawTexturedRectangle(x, y + 5, 0, 6, size * 2, display.size() * step - 3, 32, 20, 64);
                Events.drawTexturedRectangle(x, display.size() * step + y + 2, 0, 27, size * 2, 5, 32, 5, 64);
            }
            Events.renderText(TextHelper.translate("skill_group.title", new Object[0]), x, y - 2, 0.5, 0xFFFFFF);
            GlStateManager.func_179139_a((double)mSize, (double)mSize, (double)mSize);
            GlStateManager.func_179121_F();
            x = posX + 4;
            y = posY + 4;
            while (ClientConfig.RENDER_CONFIG.skillGroup.inverse ? i > 0 : i < display.size()) {
                Tuple<Skill, SkillInfo> entry = display.get(i);
                Skill skill = (Skill)((Object)((Object)((Object)entry.func_76341_a())));
                SkillInfo info = (SkillInfo)entry.func_76340_b();
                GlStateManager.func_179094_E();
                GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
                mc.func_110434_K().func_110577_a(ResourceLibrary.SKILL_BACKGROUND);
                Events.drawTexturedRectangle(x, y, 48, 0, size, size, 16, 16, 64);
                mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
                int cool = info instanceof SkillInfo.IInfoCooldown ? ((SkillInfo.IInfoCooldown)((Object)info)).getCooldown() / 20 : 0;
                boolean hasCool = cool > 0 || info == null;
                float color = hasCool ? 0.4f : 1.0f;
                GlStateManager.func_179131_c((float)color, (float)color, (float)color, (float)1.0f);
                Events.drawSprite(x, y, ResourceLibrary.getSkillTexture(skill), size);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                double remaining = Events.getOwnerActiveRemainingTime(skill);
                if (remaining != -1.0) {
                    GlStateManager.func_179090_x();
                    double progress = 1.0 - remaining;
                    int height = (int)(progress * (double)size);
                    Tessellator tessellator = Tessellator.func_178181_a();
                    BufferBuilder bufferbuilder = tessellator.func_178180_c();
                    bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                    bufferbuilder.func_181662_b((double)x, (double)(y + size), 0.0).func_181666_a(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
                    bufferbuilder.func_181662_b((double)(x + size), (double)(y + size), 0.0).func_181666_a(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
                    bufferbuilder.func_181662_b((double)(x + size), (double)(y + height), 0.0).func_181666_a(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
                    bufferbuilder.func_181662_b((double)x, (double)(y + height), 0.0).func_181666_a(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
                    tessellator.func_78381_a();
                    GlStateManager.func_179098_w();
                }
                if (ClientConfig.RENDER_CONFIG.skillGroup.renderControls && skill.getProperties().isKeyBound() && i < KeyBounds.skillUseList.size()) {
                    KeyBinding binding = KeyBounds.skillUseList.get(i);
                    String control = binding.getKeyModifier().getLocalizedComboName(binding.func_151463_i());
                    Events.renderText(control, x, y + 14, 0.3, hasCool ? 9199709 : 8453920);
                }
                if (hasCool && info != null) {
                    Events.renderText(TextHelper.translate("cooldown.timer", cool), x + 1, y + 1, 0.5, 0xFFFFFF);
                }
                GlStateManager.func_179139_a((double)mSize, (double)mSize, (double)mSize);
                GlStateManager.func_179121_F();
                switch (ClientConfig.RENDER_CONFIG.skillGroup.orientation) {
                    case VERTICAL: {
                        y += step;
                        break;
                    }
                    case HORIZONTAL: {
                        x += step;
                    }
                }
                ++i;
            }
        }));
    }

    @Deprecated
    public static double getOwnerActiveRemainingTime(Skill skill) {
        EntityPlayerSP thePlayer = Minecraft.func_71410_x().field_71439_g;
        return Capabilities.get((Entity)thePlayer).flatMap(c -> c.getActives().stream().filter(a -> a.data.skill == skill && NBTHelper.getEntity(EntityPlayer.class, a.data.nbt, "owner") == thePlayer).findFirst()).map(a -> {
            int maxTime = a.data.time;
            if (maxTime == -1) {
                return 1.0;
            }
            int time = a.tick;
            return 1.0 - (double)time / (double)maxTime;
        }).orElse(-1.0);
    }

    public static List<Tuple<Skill, SkillInfo>> getGroup(SkilledEntityCapability skills, SkillGroupCapability weight) {
        ArrayList<Tuple<Skill, SkillInfo>> display = new ArrayList<Tuple<Skill, SkillInfo>>(6);
        int index = 0;
        for (Map.Entry<String, SkillGroup> groupEntry : weight.getGroups().entrySet()) {
            if (index == skillGroup) {
                SkillGroup group = groupEntry.getValue();
                for (Map.Entry integerEntry : group.map.entrySet()) {
                    Skill skill = (Skill)((Object)integerEntry.getKey());
                    if (!skill.getProperties().hasStatusIcon() || !ClientConfig.RENDER_CONFIG.skillGroup.renderUnowned && !skills.isOwned(skill)) continue;
                    display.add((Tuple<Skill, SkillInfo>)new Tuple((Object)skill, skills.getOwned(skill).orElse(null)));
                }
                display.sort((a, b) -> {
                    int e1Weight = (Integer)group.map.get(a.func_76341_a());
                    int e2Weight = (Integer)group.map.get(b.func_76341_a());
                    return Integer.compare(e1Weight, e2Weight);
                });
                break;
            }
            ++index;
        }
        return display;
    }

    public static void rotateSkillGroup(SkillGroupCapability weight, boolean inverse) {
        int groupSize = weight.skillGroupMap.size();
        skillGroupPrev = skillGroup;
        if ((skillGroup += inverse ? -1 : 1) < 0) {
            skillGroup = groupSize;
        }
        if (skillGroup > groupSize) {
            skillGroup = 0;
        }
        int index = 0;
        for (String name : weight.getGroups().keySet()) {
            if (index == skillGroup) {
                skillGroupName = name;
                break;
            }
            ++index;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEnduranceRender(RenderGameOverlayEvent.Post event) {
        if (hideOverlay) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        Minecraft mc = Minecraft.func_71410_x();
        if (!ClientConfig.RENDER_CONFIG.endurance.renderOverlay || mc.field_71441_e == null || event.getType() != RenderGameOverlayEvent.ElementType.EXPERIENCE || mc.func_147113_T()) {
            return;
        }
        Capabilities.endurance((Entity)player).ifPresent(capability -> {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            double endurance = capability.getEndurance() + capability.getAbsorption();
            double enduranceMax = player.func_110148_a(Endurance.MAX_ENDURANCE).func_111126_e() + capability.getAbsorption();
            boolean horizontal = ClientConfig.RENDER_CONFIG.endurance.orientation == ClientConfig.RenderValues.Orientation.HORIZONTAL;
            double scale = ClientConfig.RENDER_CONFIG.endurance.scale;
            double mSize = Math.pow(scale, -1.0);
            int posX = ClientConfig.RENDER_CONFIG.endurance.posX + 1;
            int posY = ClientConfig.RENDER_CONFIG.endurance.posY + 1;
            int width = ClientConfig.RENDER_CONFIG.endurance.size;
            int fillWidth = (int)((float)endurance / (float)enduranceMax * (float)width + 1.0f);
            int fill = (int)((float)endurance / (float)enduranceMax * 182.0f + 1.0f);
            int x = (int)((double)posX / scale);
            int y = (int)((double)posY / scale);
            GlStateManager.func_179094_E();
            GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
            mc.func_110434_K().func_110577_a(horizontal ? ResourceLibrary.ENDURANCE_BACKGROUND : ResourceLibrary.ENDURANCE_BACKGROUND_);
            GlStateManager.func_179094_E();
            if (horizontal) {
                Events.drawTexturedRectangle(x, y, 0, 245, width + 8, 11, 190, 11, 256);
            } else {
                Events.drawTexturedRectangle(x, y, 245, 0, 11, width + 8, 11, 190, 256);
            }
            x += horizontal ? 4 : 3;
            y += horizontal ? 3 : 4;
            if (horizontal) {
                Events.drawTexturedRectangle(x, y, 0, ClientConfig.RENDER_CONFIG.endurance.color.ordinal() * 5 * 2, width, 5, 182, 5, 256);
                if (fill > 0) {
                    Events.drawTexturedRectangle(x, y, 0, ClientConfig.RENDER_CONFIG.endurance.color.ordinal() * 5 * 2 + 5, fillWidth, 5, fill, 5, 256);
                    Events.drawTexturedRectangle(x, y, 0, 80 + (ClientConfig.RENDER_CONFIG.endurance.overlay.ordinal() - 1) * 5 * 2 + 5, fillWidth, 5, fill, 5, 256);
                }
            } else {
                Events.drawTexturedRectangle(x, y, ClientConfig.RENDER_CONFIG.endurance.color.ordinal() * 5 * 2, 0, 5, width, 5, 182, 256);
                if (fill > 0) {
                    Events.drawTexturedRectangle(x, y, ClientConfig.RENDER_CONFIG.endurance.color.ordinal() * 5 * 2 + 5, 0, 5, fillWidth, 5, fill, 256);
                    Events.drawTexturedRectangle(x, y, 80 + (ClientConfig.RENDER_CONFIG.endurance.overlay.ordinal() - 1) * 5 * 2 + 5, 0, 5, fillWidth, 5, fill, 256);
                }
            }
            if (horizontal) {
                Events.renderText(TextHelper.translate("endurance.title", (int)endurance, (int)enduranceMax), x - 4, y - 5, 0.5, 0xFFFFFF);
                String text = TextHelper.translate("endurance.amount", (int)endurance, (int)enduranceMax);
                Events.renderText(text, x - mc.field_71466_p.func_78256_a(text) / 2 + width / 2, y, 0.8, 0xFFFFFF);
            } else {
                Events.renderText(TextHelper.translate("endurance.title", (int)endurance, (int)enduranceMax), x - 4, y - 5, 0.5, 0xFFFFFF);
                String text = TextHelper.translate("endurance.amount", (int)endurance, (int)enduranceMax);
                Events.renderText(text, x, y - mc.field_71466_p.field_78288_b / 2 + width / 2, 0.8, 0xFFFFFF);
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179139_a((double)mSize, (double)mSize, (double)mSize);
            GlStateManager.func_179121_F();
        });
    }

    public static void renderText(String text, int xCoord, int yCoord, double textScale, int color) {
        FontRenderer fontRender = Minecraft.func_71410_x().field_71466_p;
        GlStateManager.func_179094_E();
        GlStateManager.func_179139_a((double)textScale, (double)textScale, (double)textScale);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        fontRender.func_175063_a(text, (float)xCoord / (float)textScale, (float)yCoord / (float)textScale, color);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        double mSize = Math.pow(textScale, -1.0);
        GlStateManager.func_179139_a((double)mSize, (double)mSize, (double)mSize);
        GlStateManager.func_179121_F();
    }

    public static void drawSprite(int xCoord, int yCoord, ResourceLocation texture, int size) {
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(texture.toString());
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)xCoord, (double)(yCoord + size), 0.0).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94210_h()).func_181675_d();
        bufferbuilder.func_181662_b((double)(xCoord + size), (double)(yCoord + size), 0.0).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94210_h()).func_181675_d();
        bufferbuilder.func_181662_b((double)(xCoord + size), (double)yCoord, 0.0).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94206_g()).func_181675_d();
        bufferbuilder.func_181662_b((double)xCoord, (double)yCoord, 0.0).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94206_g()).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawTexturedRectangle(int x, int y, int textureX, int textureY, int width, int height, int widthU, int heightV, int textureSize) {
        float texturePixel = 1.0f / (float)textureSize;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a((double)((float)textureX * texturePixel), (double)((float)(textureY + heightV) * texturePixel)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)((float)(textureX + widthU) * texturePixel), (double)((float)(textureY + heightV) * texturePixel)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a((double)((float)(textureX + widthU) * texturePixel), (double)((float)textureY * texturePixel)).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)((float)textureX * texturePixel), (double)((float)textureY * texturePixel)).func_181675_d();
        tessellator.func_78381_a();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ClientProxy.LIGHTNING_MANAGER.update();
            ClientProxy.PARTICLE_RENDERER.update();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRenderAfterWorld(RenderWorldLastEvent event) {
        GlStateManager.func_179094_E();
        ClientProxy.LIGHTNING_MANAGER.renderAll(event.getPartialTicks());
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        ClientProxy.PARTICLE_RENDERER.renderAll(event.getPartialTicks());
        GlStateManager.func_179121_F();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onNextTickExecute(TickEvent.ClientTickEvent event) {
        if (event.side == Side.CLIENT && event.phase == TickEvent.Phase.END) {
            Runnable runnable;
            while ((runnable = QUEUE.poll()) != null) {
                runnable.run();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEntityTickActive(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving().func_130014_f_().field_72995_K) {
            EntityLivingBase entity = event.getEntityLiving();
            Capabilities.get((Entity)entity).ifPresent(skills -> {
                Iterator<SkillHolder> iterator = skills.getActives().iterator();
                while (iterator.hasNext()) {
                    SkillHolder holder = iterator.next();
                    holder.tick(entity);
                    if (!holder.isDead()) continue;
                    iterator.remove();
                }
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEntityTickCooldown(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving().func_130014_f_().field_72995_K) {
            EntityLivingBase entity = event.getEntityLiving();
            Capabilities.get((Entity)entity).ifPresent(skills -> {
                for (Map.Entry<Skill, SkillInfo> entry : skills.getAllOwned().entrySet()) {
                    SkillInfo skillInfo = entry.getValue();
                    if (!(skillInfo instanceof SkillInfo.IInfoCooldown) || !((SkillInfo.IInfoCooldown)((Object)skillInfo)).hasCooldown()) continue;
                    ((SkillInfo.IInfoCooldown)((Object)skillInfo)).setCooldown(((SkillInfo.IInfoCooldown)((Object)skillInfo)).getCooldown() - 1);
                }
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingPostRender(RenderLivingEvent.Post<EntityLivingBase> event) {
        Capabilities.get((Entity)event.getEntity()).ifPresent(skills -> {
            if (event.getEntity() == Minecraft.func_71410_x().field_71439_g && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
                return;
            }
            for (SkillHolder skillHolder : skills.getActives()) {
                SkillRendererDispatcher.INSTANCE.getRenderer(skillHolder.data.skill).render((Entity)event.getEntity(), event.getX(), event.getY(), event.getZ(), event.getPartialRenderTick(), skillHolder);
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerScreenRender(RenderWorldLastEvent event) {
        if (Minecraft.func_71410_x().func_175598_ae().field_78733_k == null) {
            return;
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74320_O != 0) {
            return;
        }
        if (Minecraft.func_71410_x().field_71439_g.func_184613_cA()) {
            return;
        }
        Capabilities.get((Entity)Minecraft.func_71410_x().field_71439_g).ifPresent(skills -> {
            for (SkillHolder skillHolder : skills.getActives()) {
                SkillRendererDispatcher.INSTANCE.getRenderer(skillHolder.data.skill).render((Entity)Minecraft.func_71410_x().field_71439_g, 0.0, 0.0, 0.0, event.getPartialTicks(), skillHolder);
            }
        });
    }
}

