/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.client.render.effect;

import arekkuusu.enderskills.api.util.Quat;
import arekkuusu.enderskills.api.util.Vector;
import arekkuusu.enderskills.client.util.ResourceLibrary;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class Lightning {
    public List<LightningSegment> segments = Lists.newArrayList();
    public final Random rand = new Random();
    public final int generations;
    public final boolean branch;
    public final int age;
    public TextureAtlasSprite particleTexture;
    public float particleRed;
    public float particleGreen;
    public float particleBlue;
    public float offset;
    public int ticks;
    Vector direction;

    public Lightning(Vector from, Vector to, int generations, float offset, int age, int rgb, boolean branch) {
        this.segments.add(new LightningSegment(from, to));
        this.generations = generations;
        this.branch = branch;
        this.offset = offset;
        this.age = age;
        float r = (float)(rgb >>> 16 & 0xFF) / 256.0f;
        float g = (float)(rgb >>> 8 & 0xFF) / 256.0f;
        float b = (float)(rgb & 0xFF) / 256.0f;
        this.setRBGColorF(r, g, b);
        this.setParticleTexture(ResourceLibrary.VOLT_PARTICLE);
        this.direction = from.subtract(to).normalize().perpendicular().normalize().rotateRandom(this.rand, 180.0f).normalize().multiply(0.15);
    }

    public void make() {
        ArrayList branched = Lists.newArrayList();
        for (int i = 0; i < this.generations; ++i) {
            ArrayList temp = Lists.newArrayList();
            for (LightningSegment segment : this.segments) {
                Vector from = segment.from;
                Vector to = segment.to;
                Vector mid = this.average(from, to);
                Vector midOffset = to.subtract(from);
                mid = mid.add(midOffset.normalize().cross(Vector.ONE).multiply(Vector.fromSpherical(this.rand.nextFloat() * 360.0f, this.rand.nextFloat() * 180.0f - 90.0f).multiply(this.offset)));
                if (this.branch && i < 2) {
                    Vector direction = mid.subtract(from);
                    float xAngle = (20.0f + 10.0f * this.rand.nextFloat()) * (float)(this.rand.nextBoolean() ? 1 : -1);
                    float zAngle = (20.0f + 10.0f * this.rand.nextFloat()) * (float)(this.rand.nextBoolean() ? 1 : -1);
                    Quat x = Quat.fromAxisAngleRad(Vector.Forward, (float)Math.toRadians(xAngle));
                    Quat z = Quat.fromAxisAngleRad(Vector.Right, (float)Math.toRadians(zAngle));
                    Vector splitEnd = direction.rotate(x.multiply(z)).multiply(0.8).add(mid);
                    LightningSegment sub = new LightningSegment(mid.copy(), splitEnd);
                    temp.add(sub);
                }
                LightningSegment one = new LightningSegment(from, mid.copy());
                LightningSegment two = new LightningSegment(mid.copy(), to);
                temp.add(one);
                temp.add(two);
                if (!branched.isEmpty() && !branched.contains(segment)) continue;
                branched.add(two);
            }
            this.segments = temp;
            this.offset /= 2.0f;
        }
    }

    private Vector average(Vector one, Vector two) {
        return one.add(two).divide(2.0);
    }

    public void onUpdate() {
        int size = this.segments.size();
        for (int i = 0; i < size; ++i) {
            Vector vector = this.direction.multiply(i == size / 2 ? 1.0 : (i < size / 2 ? (double)i / ((double)size / 2.0) : 1.0 - ((double)i - (double)size / 2.0) / ((double)size / 2.0)));
            if (i + 1 >= size - 1) continue;
            LightningSegment segmentA = this.segments.get(i);
            LightningSegment segmentB = this.segments.get(i + 1);
            segmentA.to = segmentA.to.add(vector);
            segmentB.from = segmentB.from.add(vector);
        }
        ++this.ticks;
    }

    public boolean isAlive() {
        return this.ticks < this.age;
    }

    public void renderParticle(BufferBuilder buffer, float partialTicks) {
        for (LightningSegment s : this.segments) {
            s.render(buffer, partialTicks);
        }
    }

    public void setRBGColorF(float particleRedIn, float particleGreenIn, float particleBlueIn) {
        this.particleRed = particleRedIn;
        this.particleGreen = particleGreenIn;
        this.particleBlue = particleBlueIn;
    }

    public void setParticleTexture(ResourceLocation texture) {
        this.particleTexture = Minecraft.func_71410_x().func_147117_R().func_110572_b(texture.toString());
    }

    private class LightningSegment {
        Vector from;
        Vector to;

        LightningSegment(Vector from, Vector to) {
            this.from = from;
            this.to = to;
        }

        void render(BufferBuilder buff, float partialTicks) {
            this.renderCurrentTextureAroundAxis(buff, this.from, this.to, 0.0, partialTicks);
            this.renderCurrentTextureAroundAxis(buff, this.from, this.to, 90.0, partialTicks);
        }

        private void renderCurrentTextureAroundAxis(BufferBuilder buf, Vector from, Vector to, double angle, float partialTicks) {
            Vector distance = to.subtract(from);
            from = from.offset(distance, -0.1);
            to = to.offset(distance, 0.1);
            Vector direction = to.subtract(from).normalize();
            Vector perpendicular = direction.cross(Vector.ONE).normalize();
            Vector rotatedPerp = perpendicular.rotate(Quat.fromAxisAngleRad(direction, (float)Math.toRadians(angle))).normalize();
            Vector perpFrom = rotatedPerp.multiply(0.15);
            Vector perpTo = rotatedPerp.multiply(0.15);
            double uMin = 0.0;
            double uMax = 1.0;
            double vMin = 0.0;
            double vMax = 1.0;
            int light = 255;
            if (Lightning.this.particleTexture != null) {
                uMin = Lightning.this.particleTexture.func_94209_e();
                uMax = Lightning.this.particleTexture.func_94212_f();
                vMin = Lightning.this.particleTexture.func_94206_g();
                vMax = Lightning.this.particleTexture.func_94210_h();
            }
            Vector vec = from.add(perpFrom.multiply(-1.0));
            buf.func_181662_b(vec.x, vec.y, vec.z).func_187315_a(uMax, vMax).func_181666_a(Lightning.this.particleRed, Lightning.this.particleGreen, Lightning.this.particleBlue, 1.0f).func_187314_a(light, light).func_181675_d();
            vec = from.add(perpFrom);
            buf.func_181662_b(vec.x, vec.y, vec.z).func_187315_a(uMax, vMin).func_181666_a(Lightning.this.particleRed, Lightning.this.particleGreen, Lightning.this.particleBlue, 1.0f).func_187314_a(light, light).func_181675_d();
            vec = to.add(perpTo);
            buf.func_181662_b(vec.x, vec.y, vec.z).func_187315_a(uMin, vMin).func_181666_a(Lightning.this.particleRed, Lightning.this.particleGreen, Lightning.this.particleBlue, 1.0f).func_187314_a(light, light).func_181675_d();
            vec = to.add(perpTo.multiply(-1.0));
            buf.func_181662_b(vec.x, vec.y, vec.z).func_187315_a(uMin, vMax).func_181666_a(Lightning.this.particleRed, Lightning.this.particleGreen, Lightning.this.particleBlue, 1.0f).func_187314_a(light, light).func_181675_d();
        }
    }
}

