/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.client.render.entity;

import arekkuusu.enderskills.client.ClientConfig;
import arekkuusu.enderskills.client.proxy.ClientProxy;
import arekkuusu.enderskills.client.render.effect.ParticleVanilla;
import arekkuusu.enderskills.client.render.model.ModelCrush;
import arekkuusu.enderskills.client.render.skill.SkillRenderer;
import arekkuusu.enderskills.client.util.ShaderLibrary;
import arekkuusu.enderskills.client.util.helper.GLHelper;
import arekkuusu.enderskills.common.entity.EntityCrush;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;

public class EntityCrushRenderer
extends Render<EntityCrush> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("enderskills", "textures/entity/crush.png");
    public final ModelCrush model = new ModelCrush();

    public EntityCrushRenderer(RenderManager manager) {
        super(manager);
    }

    public void doRender(EntityCrush entity, double x, double y, double z, float entityYaw, float partialTicks) {
        float animationProgress;
        if (entity.lifeTicks % 10 == 0) {
            Vec3d vec = entity.func_174791_d();
            for (int i = 1; i < 2; ++i) {
                if (!(entity.field_70170_p.field_73012_v.nextDouble() < 0.6) || !ClientProxy.canParticleSpawn()) continue;
                double posX = vec.field_72450_a + (entity.field_70170_p.field_73012_v.nextDouble() - 0.5) * (double)entity.field_70130_N;
                double posY = vec.field_72448_b - 0.5 * entity.field_70170_p.field_73012_v.nextDouble();
                double posZ = vec.field_72449_c + (entity.field_70170_p.field_73012_v.nextDouble() - 0.5) * (double)entity.field_70130_N;
                double motionX = (entity.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.25;
                double motionZ = (entity.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.25;
                ParticleVanilla vanilla = new ParticleVanilla(entity.field_70170_p, new Vec3d(posX, posY, posZ), new Vec3d(motionX, 0.4, motionZ), 12.0f, 25, 0xFFFFFF, 0);
                vanilla.setCanCollide(true);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)vanilla);
            }
        }
        if ((animationProgress = entity.getAnimationProgress(partialTicks)) != 0.0f) {
            float scale = entity.getSize() * 2.0f;
            if (animationProgress > 0.9f) {
                scale = (float)((double)scale * ((double)(1.0f - animationProgress) / (double)0.1f));
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179129_p();
            this.func_180548_c(entity);
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            GLHelper.BLEND_NORMAL.blend();
            if (!ClientConfig.RENDER_CONFIG.rendering.helpMyFramesAreDying) {
                ShaderLibrary.ALPHA.begin();
                ShaderLibrary.ALPHA.set("alpha", SkillRenderer.getDiffuseBlend(22 - entity.lifeTicks, 22, 0.4f));
            }
            GlStateManager.func_179140_f();
            GlStateManager.func_179147_l();
            GlStateManager.func_179137_b((double)-0.5, (double)0.0, (double)-0.5);
            GlStateManager.func_179114_b((float)(90.0f - entity.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)(-scale), (float)(-scale), (float)(-scale));
            GlStateManager.func_179109_b((float)0.0f, (float)-0.626f, (float)0.0f);
            this.model.func_78088_a(entity, animationProgress, 0.0f, 0.0f, entity.field_70177_z, entity.field_70125_A, 0.03125f);
            GlStateManager.func_179084_k();
            GlStateManager.func_179145_e();
            if (!ClientConfig.RENDER_CONFIG.rendering.helpMyFramesAreDying) {
                ShaderLibrary.ALPHA.end();
            }
            GLHelper.BLEND_NORMAL.blend();
            GlStateManager.func_179089_o();
            GlStateManager.func_179121_F();
            super.func_76986_a((Entity)entity, x, y, z, entityYaw, partialTicks);
        }
    }

    protected ResourceLocation getEntityTexture(EntityCrush entity) {
        return TEXTURE;
    }
}

