/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.client.render.skill;

import arekkuusu.enderskills.client.proxy.ClientProxy;
import arekkuusu.enderskills.client.render.entity.EntityThrowableDataRenderer;
import arekkuusu.enderskills.client.render.skill.ProjectileBlood;
import arekkuusu.enderskills.client.render.skill.SkillRenderer;
import arekkuusu.enderskills.client.util.ResourceLibrary;
import arekkuusu.enderskills.common.EnderSkills;
import arekkuusu.enderskills.common.entity.placeable.EntityPlaceableBloodPool;
import arekkuusu.enderskills.common.entity.throwable.EntityThrowableData;
import arekkuusu.enderskills.common.skill.ModAbilities;
import arekkuusu.enderskills.common.skill.ability.offence.blood.BloodPool;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BloodPoolRenderer
extends SkillRenderer<BloodPool> {
    public BloodPoolRenderer() {
        EntityThrowableDataRenderer.add(ModAbilities.BLOOD_POOL, (IRenderFactory<? super EntityThrowableData>)((IRenderFactory)ProjectileBlood::new));
    }

    @SideOnly(value=Side.CLIENT)
    public static class Placeable
    extends Render<EntityPlaceableBloodPool> {
        public Placeable(RenderManager renderManager) {
            super(renderManager);
        }

        public void doRender(EntityPlaceableBloodPool entity, double x, double y, double z, float entityYaw, float partialTicks) {
            GlStateManager.func_179094_E();
            RenderHelper.func_74518_a();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            Vec3d originVec = entity.func_174791_d();
            for (BlockPos pos : entity.getTerrainBlocks()) {
                if (entity.field_70173_aa % 5 == 0 && entity.field_70170_p.field_73012_v.nextDouble() < 0.005 && ClientProxy.canParticleSpawn()) {
                    double posX = (double)pos.func_177958_n() + 1.0 * entity.field_70170_p.field_73012_v.nextDouble();
                    double posY = (double)pos.func_177956_o() + 1.0 + 0.1 * entity.field_70170_p.field_73012_v.nextDouble();
                    double posZ = (double)pos.func_177952_p() + 1.0 * entity.field_70170_p.field_73012_v.nextDouble();
                    EnderSkills.getProxy().spawnParticle(entity.field_70170_p, new Vec3d(posX, posY, posZ), new Vec3d(0.0, 0.05, 0.0), 2.0f, 50, 6882051, ResourceLibrary.DROPLET);
                }
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)(x - originVec.field_72450_a), (double)(y - originVec.field_72448_b), (double)(z - originVec.field_72449_c));
                this.func_110776_a(this.getEntityTexture(entity));
                TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().getTextureExtry(ResourceLibrary.BLOOD.toString());
                if (sprite == null) {
                    sprite = Minecraft.func_71410_x().func_147117_R().func_174944_f();
                }
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder buffer = tessellator.func_178180_c();
                buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
                float fading = MathHelper.func_76131_a((float)(1.0f - (float)(entity.func_180425_c().func_185332_f(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()) / ((double)entity.getRadius() * 1.5))), (float)0.0f, (float)1.0f);
                double yOffset = 0.005;
                double xPos = pos.func_177958_n();
                double yPos = pos.func_177956_o() + 1;
                double zPos = pos.func_177952_p();
                double uMin = sprite.func_94209_e();
                double vMin = sprite.func_94206_g();
                double uMax = sprite.func_94212_f();
                double vMax = sprite.func_94210_h();
                int color = -1;
                int a = (int)((float)(color >> 24 & 0xFF) * fading);
                int r = color >> 16 & 0xFF;
                int g = color >> 8 & 0xFF;
                int b = color & 0xFF;
                int brightness = Minecraft.func_71410_x().field_71441_e.func_175626_b(pos.func_177984_a(), 0);
                int light1 = brightness >> 16 & 0xFFFF;
                int light2 = brightness & 0xFFFF;
                double width = 1.0;
                buffer.func_181662_b(xPos + width, yPos + yOffset, zPos).func_181669_b(r, g, b, a).func_187315_a(uMax, vMin).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b(xPos + width, yPos + yOffset, zPos + 1.0).func_181669_b(r, g, b, a).func_187315_a(uMax, vMax).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b(xPos, yPos + yOffset, zPos + 1.0).func_181669_b(r, g, b, a).func_187315_a(uMin, vMax).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b(xPos, yPos + yOffset, zPos).func_181669_b(r, g, b, a).func_187315_a(uMin, vMin).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b(xPos, yPos + yOffset, zPos).func_181669_b(r, g, b, a).func_187315_a(uMin, vMin).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b(xPos, yPos + yOffset, zPos + 1.0).func_181669_b(r, g, b, a).func_187315_a(uMin, vMax).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b(xPos + width, yPos + yOffset, zPos + 1.0).func_181669_b(r, g, b, a).func_187315_a(uMax, vMax).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b(xPos + width, yPos + yOffset, zPos).func_181669_b(r, g, b, a).func_187315_a(uMax, vMin).func_187314_a(light1, light2).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179084_k();
            RenderHelper.func_74519_b();
            GlStateManager.func_179121_F();
        }

        @Nonnull
        protected ResourceLocation getEntityTexture(EntityPlaceableBloodPool entity) {
            return TextureMap.field_110575_b;
        }
    }
}

