/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.client.render.skill;

import arekkuusu.enderskills.api.capability.data.SkillHolder;
import arekkuusu.enderskills.api.util.Vector;
import arekkuusu.enderskills.client.render.entity.EntityThrowableDataRenderer;
import arekkuusu.enderskills.client.render.skill.ProjectileLight;
import arekkuusu.enderskills.client.render.skill.SkillRenderer;
import arekkuusu.enderskills.client.util.ResourceLibrary;
import arekkuusu.enderskills.client.util.helper.RenderMisc;
import arekkuusu.enderskills.common.EnderSkills;
import arekkuusu.enderskills.common.entity.throwable.EntityThrowableData;
import arekkuusu.enderskills.common.skill.ModAbilities;
import arekkuusu.enderskills.common.skill.SkillHelper;
import arekkuusu.enderskills.common.skill.ability.defense.light.Charm;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class CharmRenderer
extends SkillRenderer<Charm> {
    private static final ResourceLocation SHADER = new ResourceLocation("enderskills", "shaders/post/charm.json");

    public CharmRenderer() {
        MinecraftForge.EVENT_BUS.register((Object)new Events());
        EntityThrowableDataRenderer.add(ModAbilities.CHARM, (IRenderFactory<? super EntityThrowableData>)((IRenderFactory)ProjectileLight::new));
    }

    @Override
    public void render(Entity entity, double x, double y, double z, float partialTicks, SkillHolder skillHolder) {
        if (entity.field_70173_aa % 10 == 0 && entity.field_70170_p.field_73012_v.nextDouble() < 0.02) {
            Vec3d vec = entity.func_174824_e(1.0f);
            double posX = vec.field_72450_a + entity.field_70170_p.field_73012_v.nextDouble() - 0.5;
            double posY = vec.field_72448_b + entity.field_70170_p.field_73012_v.nextDouble() - 0.5;
            double posZ = vec.field_72449_c + entity.field_70170_p.field_73012_v.nextDouble() - 0.5;
            EnderSkills.getProxy().spawnParticle(entity.field_70170_p, new Vec3d(posX, posY, posZ), new Vec3d(0.0, 0.01, 0.0), 2.0f, 50, 0xFFFFFF, ResourceLibrary.ANGRY);
        }
        Optional.ofNullable(SkillHelper.getOwner(skillHolder.data)).ifPresent(owner -> {
            Vector from = RenderMisc.getRenderViewVector(entity, partialTicks);
            Vector to = RenderMisc.getRenderViewVector((Entity)owner, partialTicks).subtract(from);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            GlStateManager.func_179147_l();
            GlStateManager.func_179140_f();
            GL11.glEnable((int)2852);
            GL11.glLineWidth((float)2.0f);
            GL11.glLineStipple((int)1, (short)255);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
            buffer.func_181662_b(0.0, (double)(entity.field_70131_O / 2.0f), 0.0).func_181666_a(1.0f, 0.0f, 0.0f, 0.5f).func_181675_d();
            buffer.func_181662_b(to.x, to.y + (double)owner.func_70047_e() - 0.1, to.z).func_181666_a(1.0f, 0.0f, 0.0f, 0.5f).func_181675_d();
            tessellator.func_78381_a();
            GL11.glLineStipple((int)1, (short)-1);
            GL11.glLineWidth((float)1.0f);
            GL11.glDisable((int)2852);
            GlStateManager.func_179145_e();
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        });
    }

    @SideOnly(value=Side.CLIENT)
    public static class Events {
        public boolean wasActive = false;

        @SubscribeEvent
        public void playerTick(TickEvent.ClientTickEvent event) {
            if (event.type == TickEvent.Type.CLIENT) {
                EntityRenderer renderer = Minecraft.func_71410_x().field_71460_t;
                if (SkillHelper.isActive((Entity)Minecraft.func_71410_x().field_71439_g, ModAbilities.CHARM)) {
                    if (!this.wasActive) {
                        renderer.func_175069_a(SHADER);
                        this.wasActive = true;
                    }
                } else if (this.wasActive) {
                    if (renderer.func_147706_e() != null && renderer.func_147706_e().func_148022_b() != null && SHADER.toString().equals(renderer.func_147706_e().func_148022_b())) {
                        renderer.func_181022_b();
                    }
                    this.wasActive = false;
                }
            }
        }
    }
}

