/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.client.render.skill;

import arekkuusu.enderskills.api.util.Vector;
import arekkuusu.enderskills.client.proxy.ClientProxy;
import arekkuusu.enderskills.client.render.entity.EntityPlaceableDataRenderer;
import arekkuusu.enderskills.client.render.entity.EntityThrowableDataRenderer;
import arekkuusu.enderskills.client.render.skill.SkillRenderer;
import arekkuusu.enderskills.client.util.ResourceLibrary;
import arekkuusu.enderskills.common.EnderSkills;
import arekkuusu.enderskills.common.entity.placeable.EntityPlaceableData;
import arekkuusu.enderskills.common.entity.throwable.EntityThrowableData;
import arekkuusu.enderskills.common.skill.ModAbilities;
import arekkuusu.enderskills.common.skill.ability.offence.fire.Fireball;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class FireballRenderer
extends SkillRenderer<Fireball> {
    public FireballRenderer() {
        EntityPlaceableDataRenderer.add(ModAbilities.FIREBALL, (IRenderFactory<? super EntityPlaceableData>)((IRenderFactory)Placeable::new));
        EntityThrowableDataRenderer.add(ModAbilities.FIREBALL, (IRenderFactory<? super EntityThrowableData>)((IRenderFactory)Projectile::new));
    }

    public static class Projectile
    extends Render<EntityThrowableData> {
        protected Projectile(RenderManager renderManager) {
            super(renderManager);
        }

        public void doRender(EntityThrowableData entity, double x, double y, double z, float entityYaw, float partialTicks) {
            float particleProgress = Math.min((float)entity.field_70173_aa / ((float)entity.getLifeTime() / 5.0f), 1.0f);
            float particleScale = 0.5f + 5.0f * particleProgress;
            for (int i = 0; i < 6; ++i) {
                if (!ClientProxy.canParticleSpawn()) continue;
                Vec3d vec = entity.func_174824_e(1.0f);
                Vec3d motion = new Vec3d(entity.field_70169_q, entity.field_70167_r + (double)entity.func_70047_e(), entity.field_70166_s).func_178788_d(vec);
                double offset = entity.field_70170_p.field_73012_v.nextDouble();
                double posX = vec.field_72450_a + (double)(entity.field_70130_N / 2.0f) * (entity.field_70170_p.field_73012_v.nextDouble() - 0.5) + motion.field_72450_a * offset;
                double posY = vec.field_72448_b + (double)(entity.field_70131_O / 2.0f) * (entity.field_70170_p.field_73012_v.nextDouble() - 0.5) + motion.field_72448_b * offset;
                double posZ = vec.field_72449_c + (double)(entity.field_70130_N / 2.0f) * (entity.field_70170_p.field_73012_v.nextDouble() - 0.5) + motion.field_72449_c * offset;
                Vector speedVec = Vector.Right.rotateRandom(entity.field_70170_p.field_73012_v, 360.0f).multiply(0.025 * entity.field_70170_p.field_73012_v.nextDouble());
                EnderSkills.getProxy().spawnParticleLuminescence(entity.field_70170_p, new Vec3d(posX, posY, posZ), speedVec.toVec3d(), particleScale, 60, ResourceLibrary.GLOW);
            }
        }

        @Nullable
        protected ResourceLocation getEntityTexture(EntityThrowableData entity) {
            return null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class Placeable
    extends Render<EntityPlaceableData> {
        protected Placeable(RenderManager renderManager) {
            super(renderManager);
        }

        public void doRender(EntityPlaceableData entity, double x, double y, double z, float entityYaw, float partialTicks) {
            double scale = (double)(entity.getRadius() * 2.0f) * MathHelper.func_151237_a((double)((double)entity.tick / 5.0), (double)0.0, (double)1.0);
            if (entity.tick % 5 == 0 && entity.field_70170_p.field_73012_v.nextDouble() < 0.4 && ClientProxy.canParticleSpawn()) {
                Vec3d vec = entity.func_174791_d();
                double posX = vec.field_72450_a + scale * (entity.field_70170_p.field_73012_v.nextDouble() - 0.5);
                double posY = vec.field_72448_b + scale * (entity.field_70170_p.field_73012_v.nextDouble() - 0.5);
                double posZ = vec.field_72449_c + scale * (entity.field_70170_p.field_73012_v.nextDouble() - 0.5);
                entity.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, posX, posY, posZ, 0.0, 0.0, 0.0, new int[0]);
            }
        }

        @Nullable
        protected ResourceLocation getEntityTexture(EntityPlaceableData entity) {
            return null;
        }
    }
}

