/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.client.render.skill;

import arekkuusu.enderskills.api.util.Vector;
import arekkuusu.enderskills.client.proxy.ClientProxy;
import arekkuusu.enderskills.client.render.entity.EntityPlaceableDataRenderer;
import arekkuusu.enderskills.client.render.skill.SkillRenderer;
import arekkuusu.enderskills.client.util.ResourceLibrary;
import arekkuusu.enderskills.common.EnderSkills;
import arekkuusu.enderskills.common.entity.placeable.EntityPlaceableData;
import arekkuusu.enderskills.common.skill.ModAbilities;
import arekkuusu.enderskills.common.skill.ability.offence.fire.FlamingBreath;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class FlamingBreathRenderer
extends SkillRenderer<FlamingBreath> {
    public FlamingBreathRenderer() {
        EntityPlaceableDataRenderer.add(ModAbilities.FLAMING_BREATH, (IRenderFactory<? super EntityPlaceableData>)((IRenderFactory)Placeable::new));
    }

    @SideOnly(value=Side.CLIENT)
    public static class Placeable
    extends Render<EntityPlaceableData> {
        protected Placeable(RenderManager renderManager) {
            super(renderManager);
        }

        public void doRender(EntityPlaceableData entity, double x, double y, double z, float entityYaw, float partialTicks) {
            if (entity.tick % 2 == 0) {
                Vector vec = new Vector(entity.func_70040_Z()).normalize();
                double distance = entity.getRadius();
                double posX = entity.field_70165_t;
                double posY = entity.field_70163_u;
                double posZ = entity.field_70161_v;
                for (int j = 1; j < 2; ++j) {
                    if (!ClientProxy.canParticleSpawn()) continue;
                    Vector speedVec = vec.rotateRandom(entity.field_70170_p.field_73012_v, 80.0f).multiply(distance * (double)j / 3.0);
                    Vector posVec = vec.rotateRandom(entity.field_70170_p.field_73012_v, 80.0f).multiply(distance * entity.field_70170_p.field_73012_v.nextDouble()).addVector(posX, posY, posZ);
                    speedVec = new Vector(speedVec.x / 10.0, speedVec.y / 10.0, speedVec.z / 10.0);
                    EnderSkills.getProxy().spawnParticleLuminescence(entity.field_70170_p, posVec.toVec3d(), speedVec.toVec3d(), 15.0f, 25, ResourceLibrary.GLOW);
                }
            }
        }

        @Nullable
        protected ResourceLocation getEntityTexture(EntityPlaceableData entity) {
            return null;
        }
    }
}

