/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.client.render.skill;

import arekkuusu.enderskills.api.helper.NBTHelper;
import arekkuusu.enderskills.client.render.skill.SkillRenderer;
import arekkuusu.enderskills.common.network.PacketHelper;
import arekkuusu.enderskills.common.skill.ModAbilities;
import arekkuusu.enderskills.common.skill.ModEffects;
import arekkuusu.enderskills.common.skill.SkillHelper;
import arekkuusu.enderskills.common.skill.ability.mobility.wind.Fog;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class FogRenderer
extends SkillRenderer<Fog> {
    public FogRenderer() {
        MinecraftForge.EVENT_BUS.register((Object)new Events());
    }

    @SideOnly(value=Side.CLIENT)
    public static class Events {
        @SubscribeEvent
        public void onLivingRender(RenderLivingEvent.Post<EntityLivingBase> event) {
            EntityPlayerSP thePlayer = Minecraft.func_71410_x().field_71439_g;
            SkillHelper.getActiveFrom((Entity)event.getEntity(), ModAbilities.FOG).ifPresent(data -> Optional.ofNullable(NBTHelper.getEntity(EntityLivingBase.class, data.nbt, "owner")).ifPresent(user -> {
                if (thePlayer != user && user == event.getEntity()) {
                    PacketHelper.sendBlindedUseRequestPacket(thePlayer, data);
                }
            }));
        }

        @SubscribeEvent
        public void onSoundEffect(PlaySoundAtEntityEvent event) {
            if (SkillHelper.isActive(event.getEntity(), ModEffects.BLINDED)) {
                event.setVolume(event.getVolume() * 0.5f);
            }
        }

        @SubscribeEvent
        public void onFogDensityRender(EntityViewRenderEvent.FogDensity event) {
            if (!SkillHelper.isActive(event.getEntity(), ModEffects.BLINDED) && SkillHelper.isActive(event.getEntity(), ModAbilities.FOG)) {
                GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
                event.setDensity(0.02f);
                event.setCanceled(true);
            }
        }
    }
}

