/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.client.render.skill;

import arekkuusu.enderskills.client.ClientConfig;
import arekkuusu.enderskills.client.proxy.ClientProxy;
import arekkuusu.enderskills.client.render.effect.ParticleVanilla;
import arekkuusu.enderskills.client.render.entity.EntityPlaceableDataRenderer;
import arekkuusu.enderskills.client.render.entity.EntityThrowableDataRenderer;
import arekkuusu.enderskills.client.render.skill.ProjectileVoid;
import arekkuusu.enderskills.client.render.skill.SkillRenderer;
import arekkuusu.enderskills.client.util.ResourceLibrary;
import arekkuusu.enderskills.client.util.ShaderLibrary;
import arekkuusu.enderskills.client.util.helper.GLHelper;
import arekkuusu.enderskills.client.util.helper.RenderMisc;
import arekkuusu.enderskills.common.entity.placeable.EntityPlaceableData;
import arekkuusu.enderskills.common.entity.throwable.EntityThrowableData;
import arekkuusu.enderskills.common.skill.ModAbilities;
import arekkuusu.enderskills.common.skill.ability.offence.ender.GasCloud;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GasCloudRenderer
extends SkillRenderer<GasCloud> {
    private static final ResourceLocation PLACEABLE = new ResourceLocation("enderskills", "textures/entity/gas_cloud.png");

    public GasCloudRenderer() {
        EntityPlaceableDataRenderer.add(ModAbilities.GAS_CLOUD, (IRenderFactory<? super EntityPlaceableData>)((IRenderFactory)Placeable::new));
        EntityThrowableDataRenderer.add(ModAbilities.GAS_CLOUD, (IRenderFactory<? super EntityThrowableData>)((IRenderFactory)ProjectileVoid::new));
    }

    @SideOnly(value=Side.CLIENT)
    public static class Placeable
    extends Render<EntityPlaceableData> {
        public final int[] colors = new int[]{1966132, 2492226, 3149903, 3676251, 4202088, 4662390, 5122692, 5979276, 6835350, 7757215, 8613545};

        public Placeable(RenderManager renderManager) {
            super(renderManager);
        }

        public void doRender(EntityPlaceableData entity, double x, double y, double z, float entityYaw, float partialTicks) {
            double scale = (double)(entity.getRadius() * 2.0f) * MathHelper.func_151237_a((double)((double)entity.tick / 5.0), (double)0.0, (double)1.0);
            if (entity.tick % 2 == 0) {
                for (int i = 0; i < 4; ++i) {
                    if (!(entity.field_70170_p.field_73012_v.nextDouble() < 0.8) || !ClientProxy.canParticleSpawn()) continue;
                    Vec3d vec = entity.func_174791_d();
                    double posX = vec.field_72450_a + scale * (entity.field_70170_p.field_73012_v.nextDouble() - 0.5);
                    double posY = vec.field_72448_b + scale * (entity.field_70170_p.field_73012_v.nextDouble() - 0.5);
                    double posZ = vec.field_72449_c + scale * (entity.field_70170_p.field_73012_v.nextDouble() - 0.5);
                    float particleScale = 5.0f + 5.0f * (float)entity.field_70170_p.field_73012_v.nextGaussian();
                    ParticleVanilla vanilla = new ParticleVanilla(entity.field_70170_p, new Vec3d(posX, posY, posZ), new Vec3d(0.0, 0.0, 0.0), particleScale, 100, this.colors[entity.field_70170_p.field_73012_v.nextInt(this.colors.length - 1)], 0);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)vanilla);
                }
            }
            if (MinecraftForgeClient.getRenderPass() != 1) {
                return;
            }
            scale = (double)entity.getRadius() * MathHelper.func_151237_a((double)((double)entity.tick / 10.0), (double)0.0, (double)1.0);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            if (!ClientConfig.RENDER_CONFIG.rendering.helpMyFramesAreDying && !ClientConfig.RENDER_CONFIG.rendering.helpMyShadersAreDying) {
                if (!ClientConfig.RENDER_CONFIG.rendering.vanilla) {
                    ShaderLibrary.UNIVERSE.begin();
                    ShaderLibrary.UNIVERSE.set("dimensions", Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
                    ShaderLibrary.UNIVERSE.set("yaw", Minecraft.func_71410_x().field_71439_g.field_70177_z * 2.0f * (float)Math.PI / 360.0f);
                    ShaderLibrary.UNIVERSE.set("pitch", -(Minecraft.func_71410_x().field_71439_g.field_70125_A * 2.0f * (float)Math.PI / 360.0f));
                    ShaderLibrary.UNIVERSE.set("color", 0.36f, 0.12f, 0.4f);
                    ShaderLibrary.UNIVERSE.set("ticks", RenderMisc.getRenderPlayerTime());
                    ShaderLibrary.UNIVERSE.set("alpha", SkillRenderer.getDiffuseBlend(entity.tick, entity.getLifeTime(), 0.6f));
                } else {
                    ShaderLibrary.UNIVERSE_DEFAULT.begin();
                    ShaderLibrary.UNIVERSE_DEFAULT.set("yaw", Minecraft.func_71410_x().field_71439_g.field_70177_z * 2.0f * (float)Math.PI / 360.0f);
                    ShaderLibrary.UNIVERSE_DEFAULT.set("pitch", -(Minecraft.func_71410_x().field_71439_g.field_70125_A * 2.0f * (float)Math.PI / 360.0f));
                    ShaderLibrary.UNIVERSE_DEFAULT.set("time", RenderMisc.getRenderPlayerTime());
                    ShaderLibrary.UNIVERSE_DEFAULT.set("alpha", SkillRenderer.getDiffuseBlend(entity.tick, entity.getLifeTime(), 0.6f));
                }
            } else {
                GLHelper.BLEND_SRC_ALPHA$ONE.blend();
                ShaderLibrary.ALPHA.begin();
                ShaderLibrary.ALPHA.set("alpha", SkillRenderer.getDiffuseBlend(entity.tick, entity.getLifeTime(), 0.6f));
            }
            GlStateManager.func_179140_f();
            GlStateManager.func_179147_l();
            this.func_110776_a(this.getEntityTexture(entity));
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b(-scale, -scale, -scale).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(scale, -scale, -scale).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(scale, scale, -scale).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(-scale, scale, -scale).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b(-scale, scale, -scale).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b(scale, scale, -scale).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(scale, -scale, -scale).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(-scale, -scale, -scale).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(scale, -scale, scale).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(-scale, -scale, scale).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(-scale, scale, scale).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(scale, scale, scale).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b(scale, scale, scale).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b(-scale, scale, scale).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(-scale, -scale, scale).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(scale, -scale, scale).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(-scale, -scale, scale).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(-scale, -scale, -scale).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(-scale, scale, -scale).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(-scale, scale, scale).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b(-scale, scale, scale).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b(-scale, scale, -scale).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(-scale, -scale, -scale).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(-scale, -scale, scale).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(scale, -scale, -scale).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(scale, -scale, scale).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(scale, scale, scale).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(scale, scale, -scale).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b(scale, scale, -scale).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b(scale, scale, scale).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(scale, -scale, scale).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(scale, -scale, -scale).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(scale, scale, -scale).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(scale, scale, scale).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(-scale, scale, scale).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b(-scale, scale, -scale).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(-scale, scale, -scale).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(-scale, scale, scale).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b(scale, scale, scale).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(scale, scale, -scale).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(scale, -scale, -scale).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(scale, -scale, scale).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(-scale, -scale, scale).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b(-scale, -scale, -scale).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(-scale, -scale, -scale).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(-scale, -scale, scale).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b(scale, -scale, scale).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(scale, -scale, -scale).func_187315_a(1.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179084_k();
            GlStateManager.func_179145_e();
            if (!ClientConfig.RENDER_CONFIG.rendering.helpMyFramesAreDying && !ClientConfig.RENDER_CONFIG.rendering.helpMyShadersAreDying) {
                if (!ClientConfig.RENDER_CONFIG.rendering.vanilla) {
                    ShaderLibrary.UNIVERSE.end();
                } else {
                    ShaderLibrary.UNIVERSE_DEFAULT.end();
                }
            } else {
                ShaderLibrary.ALPHA.end();
                GLHelper.BLEND_NORMAL.blend();
            }
            GlStateManager.func_179121_F();
        }

        @Nonnull
        protected ResourceLocation getEntityTexture(EntityPlaceableData entity) {
            if (!ClientConfig.RENDER_CONFIG.rendering.helpMyFramesAreDying) {
                if (!ClientConfig.RENDER_CONFIG.rendering.vanilla) {
                    return ResourceLibrary.DARK_BACKGROUND;
                }
                return ResourceLibrary.PORTAL_BACKGROUND;
            }
            return PLACEABLE;
        }
    }
}

