/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.client.render.skill;

import arekkuusu.enderskills.api.capability.data.SkillHolder;
import arekkuusu.enderskills.api.util.Quat;
import arekkuusu.enderskills.api.util.Vector;
import arekkuusu.enderskills.client.ClientConfig;
import arekkuusu.enderskills.client.render.entity.EntityThrowableDataRenderer;
import arekkuusu.enderskills.client.render.skill.ProjectileVoid;
import arekkuusu.enderskills.client.render.skill.SkillRenderer;
import arekkuusu.enderskills.client.util.ResourceLibrary;
import arekkuusu.enderskills.client.util.ShaderLibrary;
import arekkuusu.enderskills.client.util.helper.GLHelper;
import arekkuusu.enderskills.client.util.helper.RenderMisc;
import arekkuusu.enderskills.common.entity.throwable.EntityThrowableData;
import arekkuusu.enderskills.common.skill.ModAbilities;
import arekkuusu.enderskills.common.skill.SkillHelper;
import arekkuusu.enderskills.common.skill.ability.offence.ender.Gloom;
import com.google.common.collect.Lists;
import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Quaternion;

@SideOnly(value=Side.CLIENT)
public class GloomRenderer
extends SkillRenderer<Gloom> {
    public static final List<Beam> BEAMS = Lists.newArrayList();

    public GloomRenderer() {
        EntityThrowableDataRenderer.add(ModAbilities.GLOOM, (IRenderFactory<? super EntityThrowableData>)((IRenderFactory)ProjectileVoid::new));
        MinecraftForge.EVENT_BUS.register((Object)new Events());
    }

    @Override
    public void render(Entity entity, double x, double y, double z, float partialTicks, SkillHolder skillHolder) {
        EntityLivingBase owner;
        if (skillHolder.tick == 1 && (owner = SkillHelper.getOwner(skillHolder.data)) != null) {
            BEAMS.add(new Beam(entity, (Entity)owner));
        }
    }

    public static class Beam {
        public final WeakReference<Entity> referenceFrom;
        public final WeakReference<Entity> referenceTo;
        public final int maxLifeTime = 20;
        public int lifeTime;

        public Beam(Entity entityFrom, Entity entityTo) {
            this.referenceFrom = new WeakReference<Entity>(entityFrom);
            this.referenceTo = new WeakReference<Entity>(entityTo);
        }

        public void render(float partial) {
            Entity source = (Entity)this.referenceFrom.get();
            Entity entity = (Entity)this.referenceTo.get();
            if (source != null && entity != null) {
                float blend = SkillRenderer.getSmoothBlend(this.lifeTime, 20, 1.0f);
                if (!ClientConfig.RENDER_CONFIG.rendering.helpMyFramesAreDying && !ClientConfig.RENDER_CONFIG.rendering.helpMyShadersAreDying) {
                    if (!ClientConfig.RENDER_CONFIG.rendering.vanilla) {
                        ShaderLibrary.UNIVERSE.begin();
                        ShaderLibrary.UNIVERSE.set("dimensions", Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
                        ShaderLibrary.UNIVERSE.set("yaw", Minecraft.func_71410_x().field_71439_g.field_70177_z * 2.0f * (float)Math.PI / 360.0f);
                        ShaderLibrary.UNIVERSE.set("pitch", -(Minecraft.func_71410_x().field_71439_g.field_70125_A * 2.0f * (float)Math.PI / 360.0f));
                        ShaderLibrary.UNIVERSE.set("color", 0.36f, 0.12f, 0.4f);
                        ShaderLibrary.UNIVERSE.set("ticks", RenderMisc.getRenderPlayerTime());
                        ShaderLibrary.UNIVERSE.set("alpha", SkillRenderer.getDiffuseBlend(this.lifeTime, 20, 0.6f * blend));
                    } else {
                        ShaderLibrary.UNIVERSE_DEFAULT.begin();
                        ShaderLibrary.UNIVERSE_DEFAULT.set("yaw", Minecraft.func_71410_x().field_71439_g.field_70177_z * 2.0f * (float)Math.PI / 360.0f);
                        ShaderLibrary.UNIVERSE_DEFAULT.set("pitch", -(Minecraft.func_71410_x().field_71439_g.field_70125_A * 2.0f * (float)Math.PI / 360.0f));
                        ShaderLibrary.UNIVERSE_DEFAULT.set("time", RenderMisc.getRenderPlayerTime());
                        ShaderLibrary.UNIVERSE_DEFAULT.set("alpha", SkillRenderer.getDiffuseBlend(this.lifeTime, 20, 0.6f * blend));
                    }
                } else {
                    ShaderLibrary.ALPHA.begin();
                    ShaderLibrary.ALPHA.set("alpha", SkillRenderer.getDiffuseBlend(this.lifeTime, 20, 0.6f * blend));
                }
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder buffer = tessellator.func_178180_c();
                buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                Vector from = this.makePartialPosition(source, partial).addVector(0.0, source.field_70131_O / 2.0f, 0.0);
                Vector to = this.makePartialPosition(entity, partial).addVector(0.0, entity.field_70131_O / 2.0f, 0.0);
                this.renderTextureAroundAxis(buffer, from, to, 0.0, partial);
                this.renderTextureAroundAxis(buffer, from, to, 1.5707963267948966, partial);
                tessellator.func_78381_a();
                if (!ClientConfig.RENDER_CONFIG.rendering.helpMyFramesAreDying && !ClientConfig.RENDER_CONFIG.rendering.helpMyShadersAreDying) {
                    if (!ClientConfig.RENDER_CONFIG.rendering.vanilla) {
                        ShaderLibrary.UNIVERSE.end();
                    } else {
                        ShaderLibrary.UNIVERSE_DEFAULT.end();
                    }
                } else {
                    ShaderLibrary.ALPHA.end();
                }
            }
        }

        private Vector makePartialPosition(Entity entity, float partialTicks) {
            double x = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
            double y = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
            double z = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
            return new Vector(x, y, z);
        }

        private void renderTextureAroundAxis(BufferBuilder buf, Vector from, Vector to, double angle, float partialTicks) {
            Vector direction = to.subtract(from).normalize();
            Vector perpendicular = direction.perpendicular().normalize();
            Quat quat = Quat.fromAxisAngleRad(direction, (float)angle);
            Vector rotatedPerp = perpendicular.rotate(quat).normalize();
            Vector perpFrom = rotatedPerp.multiply(0.15);
            Vector perpTo = rotatedPerp.multiply(0.15);
            int rgb = 1966132;
            float r = (float)(rgb >>> 16 & 0xFF) / 256.0f;
            float g = (float)(rgb >>> 8 & 0xFF) / 256.0f;
            float b = (float)(rgb & 0xFF) / 256.0f;
            double uMin = 0.0;
            double uMax = 1.0;
            double vMin = 0.0;
            double vMax = 1.0;
            Vector vec = from.add(perpFrom.multiply(-1.0));
            buf.func_181662_b(vec.x, vec.y, vec.z).func_187315_a(uMax, vMax).func_181666_a(r, g, b, 1.0f).func_181675_d();
            vec = from.add(perpFrom);
            buf.func_181662_b(vec.x, vec.y, vec.z).func_187315_a(uMax, vMin).func_181666_a(r, g, b, 1.0f).func_181675_d();
            vec = to.add(perpTo);
            buf.func_181662_b(vec.x, vec.y, vec.z).func_187315_a(uMin, vMin).func_181666_a(r, g, b, 1.0f).func_181675_d();
            vec = to.add(perpTo.multiply(-1.0));
            buf.func_181662_b(vec.x, vec.y, vec.z).func_187315_a(uMin, vMax).func_181666_a(r, g, b, 1.0f).func_181675_d();
        }

        public Vec3d rotate(Vec3d vec, Quaternion quaternion) {
            double vx = vec.field_72450_a;
            double vy = vec.field_72448_b;
            double vz = vec.field_72449_c;
            double rx = quaternion.x;
            double ry = quaternion.y;
            double rz = quaternion.z;
            double rw = quaternion.w;
            double tx = 2.0 * (ry * vz - rz * vy);
            double ty = 2.0 * (rz * vx - rx * vz);
            double tz = 2.0 * (rx * vy - ry * vx);
            double cx = ry * tz - rz * ty;
            double cy = rz * tx - rx * tz;
            double cz = rx * ty - ry * tx;
            double newX = vx + rw * tx + cx;
            double newY = vy + rw * ty + cy;
            double newZ = vz + rw * tz + cz;
            return new Vec3d(newX, newY, newZ);
        }

        public Vec3d perpendicular(Vec3d vec) {
            if (vec.field_72449_c == 0.0) {
                return this.zCrossProduct(vec);
            }
            return this.xCrossProduct(vec);
        }

        public Vec3d xCrossProduct(Vec3d vec) {
            double d = vec.field_72449_c;
            double d1 = -vec.field_72448_b;
            return new Vec3d(0.0, d, d1);
        }

        public Vec3d zCrossProduct(Vec3d vec) {
            double d = vec.field_72448_b;
            double d1 = -vec.field_72450_a;
            return new Vec3d(d, d1, 0.0);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class Events {
        @SubscribeEvent
        public void renderBeamAfterWorld(RenderWorldLastEvent event) {
            float partial = event.getPartialTicks();
            Vector view = RenderMisc.getRenderViewVector(partial);
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            GlStateManager.func_179092_a((int)516, (float)0.003921569f);
            GlStateManager.func_179129_p();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(-view.x), (double)(-view.y), (double)(-view.z));
            if (!ClientConfig.RENDER_CONFIG.rendering.helpMyFramesAreDying) {
                if (!ClientConfig.RENDER_CONFIG.rendering.vanilla) {
                    Minecraft.func_71410_x().func_175598_ae().field_78724_e.func_110577_a(ResourceLibrary.DARK_BACKGROUND);
                } else {
                    Minecraft.func_71410_x().func_175598_ae().field_78724_e.func_110577_a(ResourceLibrary.PORTAL_BACKGROUND);
                }
            }
            for (Beam beam : BEAMS) {
                beam.render(partial);
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179089_o();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GLHelper.BLEND_SRC_ALPHA$ONE_MINUS_SRC_ALPHA.blend();
            GlStateManager.func_179084_k();
        }

        @SubscribeEvent
        public void clientTick(TickEvent.ClientTickEvent event) {
            BEAMS.removeIf(beam -> beam.lifeTime++ > beam.maxLifeTime || beam.referenceTo.get() == null || beam.referenceFrom.get() == null);
        }
    }
}

