/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.client.render.skill;

import arekkuusu.enderskills.api.capability.data.SkillHolder;
import arekkuusu.enderskills.api.helper.NBTHelper;
import arekkuusu.enderskills.client.ClientConfig;
import arekkuusu.enderskills.client.proxy.ClientProxy;
import arekkuusu.enderskills.client.render.entity.EntityThrowableDataRenderer;
import arekkuusu.enderskills.client.render.skill.ProjectileVoid;
import arekkuusu.enderskills.client.render.skill.SkillRenderer;
import arekkuusu.enderskills.client.util.ResourceLibrary;
import arekkuusu.enderskills.client.util.ShaderLibrary;
import arekkuusu.enderskills.client.util.helper.RenderMisc;
import arekkuusu.enderskills.common.EnderSkills;
import arekkuusu.enderskills.common.entity.placeable.EntityPlaceableGrasp;
import arekkuusu.enderskills.common.entity.throwable.EntityThrowableData;
import arekkuusu.enderskills.common.skill.ModAbilities;
import arekkuusu.enderskills.common.skill.ability.offence.ender.Grasp;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GraspRenderer
extends SkillRenderer<Grasp> {
    public GraspRenderer() {
        EntityThrowableDataRenderer.add(ModAbilities.GRASP, (IRenderFactory<? super EntityThrowableData>)((IRenderFactory)ProjectileVoid::new));
    }

    @Override
    public void render(Entity entity, double x, double y, double z, float partialTicks, SkillHolder skillHolder) {
        EntityPlaceableGrasp grasp = NBTHelper.getEntity(EntityPlaceableGrasp.class, skillHolder.data.nbt, "grasp");
        if (grasp != null && skillHolder.tick % 2 == 0) {
            Vec3d vec = new Vec3d((double)(entity.field_70130_N / 2.0f), 0.0, (double)(entity.field_70130_N / 2.0f));
            if (!entity.field_70122_E) {
                BlockPos entityPos = entity.func_180425_c();
                for (int i = 1; i <= 2; ++i) {
                    BlockPos pos = entityPos.func_177979_c(i);
                    if (!this.isSolid(entity.field_70170_p, pos)) continue;
                    vec = new Vec3d(vec.field_72450_a, -(entity.field_70163_u - (double)pos.func_177956_o()) + 1.0, vec.field_72449_c);
                    break;
                }
            }
            this.spawnParticle(vec, entity);
            vec = vec.func_178785_b(2.0943952f);
            this.spawnParticle(vec, entity);
            vec = vec.func_178785_b(2.0943952f);
            this.spawnParticle(vec, entity);
        }
    }

    public boolean isSolid(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_185890_d((IBlockAccess)world, pos) != Block.field_185506_k;
    }

    public void spawnParticle(Vec3d vec, Entity entity) {
        if (ClientProxy.canParticleSpawn()) {
            float angle = (float)entity.field_70173_aa * 1.15f % 360.0f;
            vec = vec.func_178785_b(angle * (float)Math.PI / 180.0f);
            vec = vec.func_178787_e(entity.func_174791_d());
            EnderSkills.getProxy().spawnParticle(entity.field_70170_p, vec, new Vec3d(0.0, 0.1, 0.0), 3.0f, 50, 1966132, ResourceLibrary.GLOW);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class Placeable
    extends Render<EntityPlaceableGrasp> {
        public final int[] colors = new int[]{1966132, 2492226, 3149903, 3676251, 4202088, 4662390, 5122692, 5979276, 6835350, 7757215, 8613545};

        public Placeable(RenderManager renderManager) {
            super(renderManager);
        }

        public void doRender(EntityPlaceableGrasp entity, double x, double y, double z, float entityYaw, float partialTicks) {
            GlStateManager.func_179094_E();
            Vec3d originVec = entity.func_174791_d();
            for (BlockPos pos : entity.getTerrainBlocks()) {
                if (entity.field_70173_aa % 5 == 0 && entity.field_70170_p.field_73012_v.nextDouble() < 0.005 && ClientProxy.canParticleSpawn()) {
                    double posX = (double)pos.func_177958_n() + 1.0 * entity.field_70170_p.field_73012_v.nextDouble();
                    double posY = (double)pos.func_177956_o() + 1.0 + 0.1 * entity.field_70170_p.field_73012_v.nextDouble();
                    double posZ = (double)pos.func_177952_p() + 1.0 * entity.field_70170_p.field_73012_v.nextDouble();
                    EnderSkills.getProxy().spawnParticle(entity.field_70170_p, new Vec3d(posX, posY, posZ), new Vec3d(0.0, 0.1, 0.0), 2.0f, 50, this.colors[entity.field_70170_p.field_73012_v.nextInt(this.colors.length - 1)], ResourceLibrary.GLOW);
                }
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)(x - originVec.field_72450_a), (double)(y - originVec.field_72448_b), (double)(z - originVec.field_72449_c));
                if (!ClientConfig.RENDER_CONFIG.rendering.vanilla || ClientConfig.RENDER_CONFIG.rendering.helpMyFramesAreDying) {
                    this.func_110776_a(ResourceLibrary.DARK_BACKGROUND);
                } else {
                    this.func_110776_a(ResourceLibrary.PORTAL_BACKGROUND);
                }
                GlStateManager.func_179147_l();
                if (!ClientConfig.RENDER_CONFIG.rendering.helpMyFramesAreDying && !ClientConfig.RENDER_CONFIG.rendering.helpMyShadersAreDying) {
                    float fading = MathHelper.func_76131_a((float)(1.0f - (float)(entity.func_180425_c().func_185332_f(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()) / ((double)entity.getRadius() * 1.5))), (float)0.0f, (float)1.0f);
                    if (!ClientConfig.RENDER_CONFIG.rendering.vanilla) {
                        ShaderLibrary.UNIVERSE.begin();
                        ShaderLibrary.UNIVERSE.set("dimensions", Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
                        ShaderLibrary.UNIVERSE.set("yaw", Minecraft.func_71410_x().field_71439_g.field_70177_z * 2.0f * (float)Math.PI / 360.0f);
                        ShaderLibrary.UNIVERSE.set("pitch", -(Minecraft.func_71410_x().field_71439_g.field_70125_A * 2.0f * (float)Math.PI / 360.0f));
                        ShaderLibrary.UNIVERSE.set("color", 0.36f, 0.12f, 0.4f);
                        ShaderLibrary.UNIVERSE.set("ticks", RenderMisc.getRenderPlayerTime());
                        ShaderLibrary.UNIVERSE.set("alpha", 0.9f * fading);
                    } else {
                        ShaderLibrary.UNIVERSE_DEFAULT.begin();
                        ShaderLibrary.UNIVERSE_DEFAULT.set("yaw", Minecraft.func_71410_x().field_71439_g.field_70177_z * 2.0f * (float)Math.PI / 360.0f);
                        ShaderLibrary.UNIVERSE_DEFAULT.set("pitch", -(Minecraft.func_71410_x().field_71439_g.field_70125_A * 2.0f * (float)Math.PI / 360.0f));
                        ShaderLibrary.UNIVERSE_DEFAULT.set("time", RenderMisc.getRenderPlayerTime());
                        ShaderLibrary.UNIVERSE_DEFAULT.set("alpha", 0.9f * fading);
                    }
                }
                double yOffset = 0.005;
                GL11.glEnable((int)3042);
                this.drawVoid(pos, yOffset);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glDisable((int)3042);
                GlStateManager.func_179084_k();
                if (!ClientConfig.RENDER_CONFIG.rendering.helpMyFramesAreDying && !ClientConfig.RENDER_CONFIG.rendering.helpMyShadersAreDying) {
                    if (!ClientConfig.RENDER_CONFIG.rendering.vanilla) {
                        ShaderLibrary.UNIVERSE.end();
                    } else {
                        ShaderLibrary.UNIVERSE_DEFAULT.end();
                    }
                }
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179121_F();
        }

        public void drawVoid(BlockPos pos, double yOffset) {
            GL11.glBlendFunc((int)770, (int)771);
            GlStateManager.func_179094_E();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            double uMin = 0.0;
            double vMin = 0.0;
            double uMax = 1.0;
            double vMax = 1.0;
            double xPos = pos.func_177958_n();
            double yPos = pos.func_177956_o() + 1;
            double zPos = pos.func_177952_p();
            double width = 1.0;
            buffer.func_181662_b(xPos + width, yPos + yOffset, zPos).func_187315_a(uMax, vMin).func_181675_d();
            buffer.func_181662_b(xPos + width, yPos + yOffset, zPos + 1.0).func_187315_a(uMax, vMax).func_181675_d();
            buffer.func_181662_b(xPos, yPos + yOffset, zPos + 1.0).func_187315_a(uMin, vMax).func_181675_d();
            buffer.func_181662_b(xPos, yPos + yOffset, zPos).func_187315_a(uMin, vMin).func_181675_d();
            buffer.func_181662_b(xPos, yPos + yOffset, zPos).func_187315_a(uMin, vMin).func_181675_d();
            buffer.func_181662_b(xPos, yPos + yOffset, zPos + 1.0).func_187315_a(uMin, vMax).func_181675_d();
            buffer.func_181662_b(xPos + width, yPos + yOffset, zPos + 1.0).func_187315_a(uMax, vMax).func_181675_d();
            buffer.func_181662_b(xPos + width, yPos + yOffset, zPos).func_187315_a(uMax, vMin).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179132_a((boolean)false);
            GL11.glBlendFunc((int)770, (int)1);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b(xPos + width, yPos + yOffset + 0.01, zPos).func_187315_a(uMax, vMin).func_181675_d();
            buffer.func_181662_b(xPos + width, yPos + yOffset + 0.01, zPos + 1.0).func_187315_a(uMax, vMax).func_181675_d();
            buffer.func_181662_b(xPos, yPos + yOffset + 0.01, zPos + 1.0).func_187315_a(uMin, vMax).func_181675_d();
            buffer.func_181662_b(xPos, yPos + yOffset + 0.01, zPos).func_187315_a(uMin, vMin).func_181675_d();
            buffer.func_181662_b(xPos, yPos + yOffset + 0.01, zPos).func_187315_a(uMin, vMin).func_181675_d();
            buffer.func_181662_b(xPos, yPos + yOffset + 0.01, zPos + 1.0).func_187315_a(uMin, vMax).func_181675_d();
            buffer.func_181662_b(xPos + width, yPos + yOffset + 0.01, zPos + 1.0).func_187315_a(uMax, vMax).func_181675_d();
            buffer.func_181662_b(xPos + width, yPos + yOffset + 0.01, zPos).func_187315_a(uMax, vMin).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179121_F();
        }

        @Nonnull
        protected ResourceLocation getEntityTexture(EntityPlaceableGrasp entity) {
            return TextureMap.field_110575_b;
        }
    }
}

