/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.client.render.skill;

import arekkuusu.enderskills.api.helper.NBTHelper;
import arekkuusu.enderskills.api.util.Vector;
import arekkuusu.enderskills.client.proxy.ClientProxy;
import arekkuusu.enderskills.client.render.model.ModelFist;
import arekkuusu.enderskills.client.render.skill.SkillRenderer;
import arekkuusu.enderskills.client.util.helper.GLHelper;
import arekkuusu.enderskills.common.skill.ModAbilities;
import arekkuusu.enderskills.common.skill.SkillHelper;
import arekkuusu.enderskills.common.skill.ability.offence.ender.ShadowJab;
import com.google.common.collect.Lists;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ShadowJabRenderer
extends SkillRenderer<ShadowJab> {
    public static final ResourceLocation FOLLOWING = new ResourceLocation("enderskills", "textures/entity/fist.png");
    public static final ModelFist MODEL_FIST = new ModelFist();
    public static final List<Fist> FISTS = Lists.newArrayList();

    public ShadowJabRenderer() {
        MinecraftForge.EVENT_BUS.register((Object)new Events());
    }

    public static class Fist {
        public final int maxLifeTime = 5;
        public final WeakReference<Entity> weakReference;
        public float rotationYaw;
        public float rotationPitch;
        public Vector position;
        public Vector motion;
        public int lifeTime;

        public Fist(Entity entity, double distance) {
            this.weakReference = new WeakReference<Entity>(entity);
            this.position = new Vector(entity.func_70040_Z().func_72432_b());
            this.position = this.position.rotateRandom(entity.field_70170_p.field_73012_v, 40.0f);
            Vector entityPos = new Vector(entity.func_174824_e(1.0f));
            Vector target = entityPos.addVector(this.position.x * distance, this.position.y * distance, this.position.z * distance);
            this.position = this.position.add(entityPos);
            this.motion = target.subtract(this.position);
            this.motion = this.motion.divide(5.0);
            Vector direction = this.motion.normalize();
            this.rotationYaw = (float)direction.toYaw();
            this.rotationPitch = (float)direction.toPitch();
        }

        public void update() {
            Vector motion = this.motion;
            this.position = this.position.add(motion);
        }

        public void render(float partial) {
            GlStateManager.func_179124_c((float)0.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)this.position.x, (double)this.position.y, (double)this.position.z);
            Minecraft.func_71410_x().func_175598_ae().field_78724_e.func_110577_a(FOLLOWING);
            GlStateManager.func_179114_b((float)this.rotationYaw, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)this.rotationPitch, (float)0.0f, (float)0.0f, (float)1.0f);
            MODEL_FIST.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
            GlStateManager.func_179121_F();
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class Events {
        @SubscribeEvent
        public void onEntityTick(LivingEvent.LivingUpdateEvent event) {
            if (event.getEntityLiving().func_130014_f_().field_72995_K && ClientProxy.canParticleSpawn()) {
                EntityLivingBase entity = event.getEntityLiving();
                SkillHelper.getActiveFrom((Entity)entity, ModAbilities.SHADOW_JAB).ifPresent(data -> FISTS.add(new Fist((Entity)entity, NBTHelper.getDouble(data.nbt, "range"))));
            }
        }

        @SubscribeEvent
        public void renderAfterWorld(RenderWorldLastEvent event) {
            float partial = event.getPartialTicks();
            Entity rView = Minecraft.func_71410_x().func_175606_aa();
            if (rView == null) {
                rView = Minecraft.func_71410_x().field_71439_g;
            }
            Entity entity = rView;
            double tx = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partial;
            double ty = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partial;
            double tz = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partial;
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            GlStateManager.func_179092_a((int)516, (float)0.003921569f);
            GlStateManager.func_179129_p();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(-tx), (double)(-ty), (double)(-tz));
            Minecraft.func_71410_x().func_175598_ae().field_78724_e.func_110577_a(FOLLOWING);
            for (Fist fist : FISTS) {
                fist.render(partial);
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179089_o();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GLHelper.BLEND_SRC_ALPHA$ONE_MINUS_SRC_ALPHA.blend();
            GlStateManager.func_179084_k();
        }

        @SubscribeEvent
        public void clientTick(TickEvent.ClientTickEvent event) {
            Iterator<Fist> iterator = FISTS.iterator();
            while (iterator.hasNext()) {
                Fist fist = iterator.next();
                fist.update();
                if (fist.lifeTime++ <= fist.maxLifeTime) continue;
                iterator.remove();
            }
        }
    }
}

