/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.client.render.skill;

import arekkuusu.enderskills.api.registry.Skill;
import arekkuusu.enderskills.client.render.skill.SkillRenderer;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class SkillRendererDispatcher {
    public static final SkillRendererDispatcher INSTANCE = new SkillRendererDispatcher();
    public final Map<Class<? extends Skill>, SkillRenderer<? extends Skill>> skillRendererMap = Maps.newHashMap();

    private SkillRendererDispatcher() {
    }

    @Nullable
    public <T extends Skill> SkillRenderer<T> getRenderer(Class<? extends Skill> skill) {
        SkillRenderer<Skill> skillRenderer = this.skillRendererMap.get(skill);
        if (skillRenderer == null && skill != Skill.class) {
            skillRenderer = INSTANCE.getRenderer(skill.getSuperclass());
            this.skillRendererMap.put(skill, skillRenderer);
        }
        return skillRenderer;
    }

    @Nullable
    public <T extends Skill> SkillRenderer<T> getRenderer(Skill skill) {
        return this.getRenderer(((Object)((Object)skill)).getClass());
    }

    public <T extends Skill> void registerRenderer(Class<T> skill, SkillRenderer<T> renderer) {
        SkillRendererDispatcher.INSTANCE.skillRendererMap.put(skill, renderer);
        renderer.setDispatcher(INSTANCE);
    }
}

