/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.client.render.skill;

import arekkuusu.enderskills.client.ClientConfig;
import arekkuusu.enderskills.client.render.entity.EntityPlaceableDataRenderer;
import arekkuusu.enderskills.client.render.skill.SkillRenderer;
import arekkuusu.enderskills.client.util.ShaderLibrary;
import arekkuusu.enderskills.client.util.helper.GLHelper;
import arekkuusu.enderskills.common.entity.placeable.EntityPlaceableData;
import arekkuusu.enderskills.common.skill.ModAbilities;
import arekkuusu.enderskills.common.skill.ability.offence.wind.Slash;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SlashRenderer
extends SkillRenderer<Slash> {
    public static final ResourceLocation PLACEABLE = new ResourceLocation("enderskills", "textures/entity/slash.png");

    public SlashRenderer() {
        EntityPlaceableDataRenderer.add(ModAbilities.SLASH, (IRenderFactory<? super EntityPlaceableData>)((IRenderFactory)Placeable::new));
    }

    @SideOnly(value=Side.CLIENT)
    public static class Placeable
    extends Render<EntityPlaceableData> {
        public Placeable(RenderManager renderManager) {
            super(renderManager);
        }

        public void doRender(EntityPlaceableData entity, double x, double y, double z, float entityYaw, float partialTicks) {
            if (entity.tick > entity.getLifeTime()) {
                return;
            }
            double progress = ((double)entity.tick + (double)partialTicks) / (double)entity.getLifeTime();
            double scale = (double)((entity.getRadius() + 3.0f) * 2.0f) * progress;
            GLHelper.BLEND_SRC_ALPHA$ONE.blend();
            if (!ClientConfig.RENDER_CONFIG.rendering.helpMyShadersAreDying) {
                ShaderLibrary.ALPHA.begin();
                ShaderLibrary.ALPHA.set("alpha", 0.6f * (1.0f - (float)progress));
            }
            for (int i = -1; i <= 1; ++i) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179140_f();
                GlStateManager.func_179147_l();
                GlStateManager.func_179137_b((double)x, (double)y, (double)z);
                GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
                GlStateManager.func_179094_E();
                GlStateManager.func_179114_b((float)entity.field_70177_z, (float)0.0f, (float)-1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(entity.field_70125_A + (float)(12 * i) - 35.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                this.func_110776_a(this.getEntityTexture(entity));
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder buffer = tessellator.func_178180_c();
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                double yOffset = -(0.5 - 0.25 * progress);
                buffer.func_181662_b(-0.5, yOffset, -0.5).func_187315_a(0.0, 0.0).func_181675_d();
                buffer.func_181662_b(0.5, yOffset, -0.5).func_187315_a(1.0, 0.0).func_181675_d();
                buffer.func_181662_b(0.5, yOffset, 0.5).func_187315_a(1.0, 1.0).func_181675_d();
                buffer.func_181662_b(-0.5, yOffset, 0.5).func_187315_a(0.0, 1.0).func_181675_d();
                buffer.func_181662_b(-0.5, yOffset, 0.5).func_187315_a(0.0, 1.0).func_181675_d();
                buffer.func_181662_b(0.5, yOffset, 0.5).func_187315_a(1.0, 1.0).func_181675_d();
                buffer.func_181662_b(0.5, yOffset, -0.5).func_187315_a(1.0, 0.0).func_181675_d();
                buffer.func_181662_b(-0.5, yOffset, -0.5).func_187315_a(0.0, 0.0).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.func_179121_F();
                GlStateManager.func_179084_k();
                GlStateManager.func_179145_e();
                GlStateManager.func_179121_F();
            }
            if (!ClientConfig.RENDER_CONFIG.rendering.helpMyShadersAreDying) {
                ShaderLibrary.ALPHA.end();
            }
        }

        @Nonnull
        protected ResourceLocation getEntityTexture(EntityPlaceableData entity) {
            return PLACEABLE;
        }
    }
}

