/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.client.render.skill;

import arekkuusu.enderskills.api.capability.Capabilities;
import arekkuusu.enderskills.client.render.skill.SkillRenderer;
import arekkuusu.enderskills.common.skill.ModAbilities;
import arekkuusu.enderskills.common.skill.ability.mobility.wind.SpeedBoost;
import com.google.common.collect.Lists;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SpeedBoostRenderer
extends SkillRenderer<SpeedBoost> {
    public static final WeakHashMap<EntityLivingBase, Vec3d> TRAVELED_VECTORS = new WeakHashMap();
    public static final List<AfterImage> AFTER_IMAGES = Lists.newArrayList();

    public SpeedBoostRenderer() {
        MinecraftForge.EVENT_BUS.register((Object)new Events());
    }

    public static class AfterImage {
        public final WeakReference<EntityLivingBase> reference;
        public final Vec3d positionVector;
        public final int maxLifeTime = 10;
        public int lifeTime;

        public AfterImage(EntityLivingBase entity, Vec3d positionVector) {
            this.reference = new WeakReference<EntityLivingBase>(entity);
            this.positionVector = positionVector;
        }

        public void render() {
            EntityLivingBase entity = (EntityLivingBase)this.reference.get();
            if (entity == null) {
                return;
            }
            int i = entity.func_70070_b();
            if (entity.func_70027_ad()) {
                i = 0xF000F0;
            }
            int j = i % 65536;
            int k = i / 65536;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)this.positionVector.field_72450_a, (double)this.positionVector.field_72448_b, (double)this.positionVector.field_72449_c);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.3f * (1.0f - (float)this.lifeTime / 10.0f)));
            Minecraft.func_71410_x().func_175598_ae().func_188391_a((Entity)entity, 0.0, 0.0, 0.0, entity.field_70177_z, 0.0f, false);
            GlStateManager.func_179121_F();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class Events {
        public static boolean rendering = false;

        @SubscribeEvent
        public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
            EntityLivingBase entity = event.getEntityLiving();
            if (!entity.field_70170_p.field_72995_K) {
                return;
            }
            if (!(entity.field_70159_w == 0.0 && entity.field_70181_x == 0.0 && entity.field_70179_y == 0.0 || entity.func_82150_aj())) {
                Capabilities.get((Entity)entity).filter(c -> c.isActive(ModAbilities.SPEED_BOOST) || c.isActive(ModAbilities.DASH)).ifPresent(c -> {
                    if (!TRAVELED_VECTORS.containsKey(entity)) {
                        TRAVELED_VECTORS.put(entity, entity.func_174791_d());
                    }
                    Vec3d vec = TRAVELED_VECTORS.get(entity);
                    if (entity.func_70011_f(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c) > (double)(entity.field_70130_N / 2.0f)) {
                        TRAVELED_VECTORS.put(entity, entity.func_174791_d());
                        AFTER_IMAGES.add(new AfterImage(entity, entity.func_174791_d()));
                    }
                });
            }
        }

        @SubscribeEvent
        public void clientTick(TickEvent.ClientTickEvent event) {
            AFTER_IMAGES.removeIf(afterImage -> afterImage.lifeTime++ > afterImage.maxLifeTime || afterImage.reference.get() == null);
        }

        @SubscribeEvent
        public void onRenderAfterWorld(RenderWorldLastEvent event) {
            if (!AFTER_IMAGES.isEmpty()) {
                rendering = true;
                GlStateManager.func_179123_a();
                GlStateManager.func_179094_E();
                GlStateManager.func_179132_a((boolean)false);
                GlStateManager.func_179092_a((int)516, (float)0.003921569f);
                GlStateManager.func_179147_l();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                EntityPlayerSP playerEntity = Minecraft.func_71410_x().field_71439_g;
                double x = playerEntity.field_70142_S + (playerEntity.field_70165_t - playerEntity.field_70142_S) * 1.0;
                double y = playerEntity.field_70137_T + (playerEntity.field_70163_u - playerEntity.field_70137_T) * 1.0;
                double z = playerEntity.field_70136_U + (playerEntity.field_70161_v - playerEntity.field_70136_U) * 1.0;
                GlStateManager.func_179137_b((double)(-x), (double)(-y), (double)(-z));
                for (AfterImage afterImage : AFTER_IMAGES) {
                    afterImage.render();
                }
                GlStateManager.func_179084_k();
                GlStateManager.func_179092_a((int)516, (float)0.1f);
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179121_F();
                GlStateManager.func_179099_b();
                rendering = false;
            }
        }
    }
}

