/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.client.render.skill;

import arekkuusu.enderskills.client.ClientConfig;
import arekkuusu.enderskills.client.proxy.ClientProxy;
import arekkuusu.enderskills.client.render.effect.ParticleVanilla;
import arekkuusu.enderskills.client.render.entity.EntityPlaceableDataRenderer;
import arekkuusu.enderskills.client.render.entity.EntityThrowableDataRenderer;
import arekkuusu.enderskills.client.render.skill.ProjectileWind;
import arekkuusu.enderskills.client.render.skill.SkillRenderer;
import arekkuusu.enderskills.client.util.ShaderLibrary;
import arekkuusu.enderskills.client.util.helper.GLHelper;
import arekkuusu.enderskills.common.entity.placeable.EntityPlaceableData;
import arekkuusu.enderskills.common.entity.throwable.EntityThrowableData;
import arekkuusu.enderskills.common.skill.ModAbilities;
import arekkuusu.enderskills.common.skill.SkillHelper;
import arekkuusu.enderskills.common.skill.ability.offence.wind.Suffocate;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SuffocateRenderer
extends SkillRenderer<Suffocate> {
    private static final ResourceLocation PLACEABLE = new ResourceLocation("enderskills", "textures/entity/suffocate.png");

    public SuffocateRenderer() {
        EntityPlaceableDataRenderer.add(ModAbilities.SUFFOCATE, (IRenderFactory<? super EntityPlaceableData>)((IRenderFactory)Placeable::new));
        EntityThrowableDataRenderer.add(ModAbilities.SUFFOCATE, (IRenderFactory<? super EntityThrowableData>)((IRenderFactory)ProjectileWind::new));
    }

    @SideOnly(value=Side.CLIENT)
    public static class Placeable
    extends Render<EntityPlaceableData> {
        public Placeable(RenderManager renderManager) {
            super(renderManager);
        }

        public void doRender(EntityPlaceableData entity, double x, double y, double z, float entityYaw, float partialTicks) {
            double scale = (double)(entity.getRadius() * 2.0f) * MathHelper.func_151237_a((double)((double)entity.tick / 5.0), (double)0.0, (double)1.0);
            if (entity.tick % 10 == 0 && entity.field_70170_p.field_73012_v.nextDouble() < 0.2 && ClientProxy.canParticleSpawn()) {
                Vec3d vec = entity.func_174791_d();
                double posX = vec.field_72450_a + scale * (entity.field_70170_p.field_73012_v.nextDouble() - 0.5);
                double posY = vec.field_72448_b + scale * (entity.field_70170_p.field_73012_v.nextDouble() - 0.5);
                double posZ = vec.field_72449_c + scale * (entity.field_70170_p.field_73012_v.nextDouble() - 0.5);
                float particleScale = 7.0f + 4.0f * (float)entity.field_70170_p.field_73012_v.nextGaussian();
                ParticleVanilla vanilla = new ParticleVanilla(entity.field_70170_p, new Vec3d(posX, posY, posZ), new Vec3d(0.0, 0.0, 0.0), particleScale, 100, 0xFFFFFF, 0);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)vanilla);
            }
            if (MinecraftForgeClient.getRenderPass() != 1) {
                return;
            }
            scale = (double)entity.getRadius() * MathHelper.func_151237_a((double)((double)entity.tick / 10.0), (double)0.0, (double)1.0);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            GLHelper.BLEND_NORMAL.blend();
            if (!ClientConfig.RENDER_CONFIG.rendering.helpMyShadersAreDying) {
                ShaderLibrary.ALPHA.begin();
                ShaderLibrary.ALPHA.set("alpha", SkillRenderer.getDiffuseBlend(entity.tick, entity.getLifeTime(), 0.4f));
            }
            GlStateManager.func_179140_f();
            GlStateManager.func_179147_l();
            this.func_110776_a(this.getEntityTexture(entity));
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b(-scale, -scale, -scale).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(scale, -scale, -scale).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(scale, scale, -scale).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(-scale, scale, -scale).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b(-scale, scale, -scale).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b(scale, scale, -scale).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(scale, -scale, -scale).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(-scale, -scale, -scale).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(scale, -scale, scale).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(-scale, -scale, scale).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(-scale, scale, scale).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(scale, scale, scale).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b(scale, scale, scale).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b(-scale, scale, scale).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(-scale, -scale, scale).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(scale, -scale, scale).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(-scale, -scale, scale).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(-scale, -scale, -scale).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(-scale, scale, -scale).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(-scale, scale, scale).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b(-scale, scale, scale).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b(-scale, scale, -scale).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(-scale, -scale, -scale).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(-scale, -scale, scale).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(scale, -scale, -scale).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(scale, -scale, scale).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(scale, scale, scale).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(scale, scale, -scale).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b(scale, scale, -scale).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b(scale, scale, scale).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(scale, -scale, scale).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(scale, -scale, -scale).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(scale, scale, -scale).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(scale, scale, scale).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(-scale, scale, scale).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b(-scale, scale, -scale).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(-scale, scale, -scale).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(-scale, scale, scale).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b(scale, scale, scale).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(scale, scale, -scale).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(scale, -scale, -scale).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(scale, -scale, scale).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(-scale, -scale, scale).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b(-scale, -scale, -scale).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(-scale, -scale, -scale).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(-scale, -scale, scale).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b(scale, -scale, scale).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(scale, -scale, -scale).func_187315_a(1.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179084_k();
            GlStateManager.func_179145_e();
            if (!ClientConfig.RENDER_CONFIG.rendering.helpMyShadersAreDying) {
                ShaderLibrary.ALPHA.end();
            }
            GLHelper.BLEND_NORMAL.blend();
            GlStateManager.func_179121_F();
        }

        @Nonnull
        protected ResourceLocation getEntityTexture(EntityPlaceableData entity) {
            return PLACEABLE;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class Events {
        @SubscribeEvent
        public void onSoundEffect(PlaySoundAtEntityEvent event) {
            if (SkillHelper.isActive(event.getEntity(), ModAbilities.SUFFOCATE)) {
                event.setVolume(0.0f);
            }
        }
    }
}

