/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.client.render.skill;

import arekkuusu.enderskills.client.ClientConfig;
import arekkuusu.enderskills.client.render.skill.SkillRenderer;
import arekkuusu.enderskills.client.util.ResourceLibrary;
import arekkuusu.enderskills.client.util.ShaderLibrary;
import arekkuusu.enderskills.client.util.helper.RenderMisc;
import arekkuusu.enderskills.common.skill.ability.mobility.ender.Teleport;
import com.google.common.collect.Lists;
import com.sasmaster.glelwjgl.java.CoreGLE;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TeleportRenderer
extends SkillRenderer<Teleport> {
    public static final List<TeleportRift> TELEPORT_RIFTS = Lists.newArrayList();

    public TeleportRenderer() {
        MinecraftForge.EVENT_BUS.register((Object)new Events());
    }

    public static class TeleportRift {
        public ArrayList<Float> pointsWidth = Lists.newArrayList();
        public ArrayList<Vec3d> points = Lists.newArrayList();
        public final WeakReference<EntityLivingBase> reference;
        public final Vec3d positionVector;
        public final int maxLifeTime = 20;
        public final Random random;
        public final CoreGLE gle;
        public final float width;
        public final float height;
        public int lifeTime;

        public TeleportRift(EntityLivingBase entity, Vec3d positionVector) {
            this.reference = new WeakReference<EntityLivingBase>(entity);
            this.positionVector = positionVector;
            this.random = new Random(entity.field_70170_p.field_73012_v.nextLong());
            this.gle = new CoreGLE();
            this.setupShape((Entity)entity);
            this.width = entity.field_70130_N;
            this.height = entity.field_70131_O;
        }

        public void setupShape(Entity entity) {
            this.points.clear();
            this.pointsWidth.clear();
            int steps = 3;
            float girth = entity.field_70130_N;
            double angle = 0.35;
            Vec3d right = new Vec3d(0.0, (double)(entity.field_70131_O / (float)(steps + 1)), 0.0);
            Vec3d left = right.func_186678_a(-1.0);
            Vec3d lr = new Vec3d(0.0, 0.0, 0.0);
            Vec3d ll = new Vec3d(0.0, 0.0, 0.0);
            float dec = girth / (float)steps;
            for (int a = 0; a < steps; ++a) {
                girth -= dec;
                right = right.func_178789_a((float)(this.random.nextGaussian() * angle));
                right = right.func_178785_b((float)(this.random.nextGaussian() * angle));
                lr = lr.func_178787_e(right);
                this.points.add(new Vec3d(lr.field_72450_a, lr.field_72448_b, lr.field_72449_c));
                this.pointsWidth.add(Float.valueOf(girth));
                left = left.func_178789_a((float)(this.random.nextGaussian() * angle));
                left = left.func_178785_b((float)(this.random.nextGaussian() * angle));
                ll = ll.func_178787_e(left);
                this.points.add(0, new Vec3d(ll.field_72450_a, ll.field_72448_b, ll.field_72449_c));
                this.pointsWidth.add(0, Float.valueOf(girth));
            }
            lr = lr.func_178787_e(right);
            this.points.add(new Vec3d(lr.field_72450_a, lr.field_72448_b, lr.field_72449_c));
            this.pointsWidth.add(Float.valueOf(0.0f));
            ll = ll.func_178787_e(left);
            this.points.add(0, new Vec3d(ll.field_72450_a, ll.field_72448_b, ll.field_72449_c));
            this.pointsWidth.add(0, Float.valueOf(0.0f));
        }

        public void render(float partialTicks) {
            EntityLivingBase entity = (EntityLivingBase)this.reference.get();
            if (entity == null) {
                return;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)this.positionVector.field_72450_a, (double)this.positionVector.field_72448_b, (double)this.positionVector.field_72449_c);
            if (!ClientConfig.RENDER_CONFIG.rendering.vanilla || ClientConfig.RENDER_CONFIG.rendering.helpMyFramesAreDying) {
                Minecraft.func_71410_x().func_175598_ae().field_78724_e.func_110577_a(ResourceLibrary.DARK_BACKGROUND);
            } else {
                Minecraft.func_71410_x().func_175598_ae().field_78724_e.func_110577_a(ResourceLibrary.PORTAL_BACKGROUND);
            }
            if (!ClientConfig.RENDER_CONFIG.rendering.helpMyFramesAreDying && !ClientConfig.RENDER_CONFIG.rendering.helpMyShadersAreDying) {
                if (!ClientConfig.RENDER_CONFIG.rendering.vanilla) {
                    ShaderLibrary.UNIVERSE.begin();
                    ShaderLibrary.UNIVERSE.set("dimensions", Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
                    ShaderLibrary.UNIVERSE.set("yaw", Minecraft.func_71410_x().field_71439_g.field_70177_z * 2.0f * (float)Math.PI / 360.0f);
                    ShaderLibrary.UNIVERSE.set("pitch", -(Minecraft.func_71410_x().field_71439_g.field_70125_A * 2.0f * (float)Math.PI / 360.0f));
                    ShaderLibrary.UNIVERSE.set("color", 0.36f, 0.12f, 0.4f);
                    ShaderLibrary.UNIVERSE.set("ticks", RenderMisc.getRenderPlayerTime());
                    ShaderLibrary.UNIVERSE.set("alpha", 0.9f);
                } else {
                    ShaderLibrary.UNIVERSE_DEFAULT.begin();
                    ShaderLibrary.UNIVERSE_DEFAULT.set("yaw", Minecraft.func_71410_x().field_71439_g.field_70177_z * 2.0f * (float)Math.PI / 360.0f);
                    ShaderLibrary.UNIVERSE_DEFAULT.set("pitch", -(Minecraft.func_71410_x().field_71439_g.field_70125_A * 2.0f * (float)Math.PI / 360.0f));
                    ShaderLibrary.UNIVERSE_DEFAULT.set("time", RenderMisc.getRenderPlayerTime());
                    ShaderLibrary.UNIVERSE_DEFAULT.set("alpha", 0.9f);
                }
            }
            float scale = 1.0f;
            int growTime = 10;
            int shrinkTime = 10;
            if (this.lifeTime < growTime) {
                scale = (float)this.lifeTime / (float)growTime;
            } else if (this.lifeTime > shrinkTime) {
                scale = 1.0f - (float)(this.lifeTime - shrinkTime) / 10.0f;
            }
            float amp = 1.0f;
            float stab = 0.92f;
            GL11.glEnable((int)3042);
            for (int q = 0; q <= 3; ++q) {
                if (q < 3) {
                    GlStateManager.func_179132_a((boolean)false);
                }
                GL11.glBlendFunc((int)770, (int)(q < 3 ? 1 : 771));
                if (this.points.size() > 2) {
                    GlStateManager.func_179094_E();
                    double[][] pp = new double[this.points.size()][3];
                    float[][] colours = new float[this.points.size()][4];
                    double[] radii = new double[this.points.size()];
                    for (int a = 0; a < this.points.size(); ++a) {
                        float tick = (float)entity.field_70173_aa + partialTicks + (float)q;
                        if (a > this.points.size() / 2) {
                            tick -= (float)(a * 10);
                        } else if (a < this.points.size() / 2) {
                            tick += (float)(a * 10);
                        }
                        pp[a][0] = this.points.get((int)a).field_72450_a;
                        pp[a][1] = this.points.get((int)a).field_72448_b;
                        pp[a][2] = this.points.get((int)a).field_72449_c;
                        colours[a][0] = 1.0f;
                        colours[a][1] = 1.0f;
                        colours[a][2] = 1.0f;
                        colours[a][3] = 1.0f;
                        double w = 1.0 - Math.sin(tick / 8.0f * amp) * (double)0.1f * (double)stab;
                        radii[a] = (double)this.pointsWidth.get(a).floatValue() * w * (double)(q < 3 ? 1.1f + 0.15f * (float)q : 1.0f) * (double)scale;
                    }
                    this.gle.set_POLYCYL_TESS(6);
                    this.gle.gleSetJoinStyle(1026);
                    this.gle.glePolyCone(pp.length, pp, colours, radii, 1.0f, 0.0f);
                    GlStateManager.func_179121_F();
                }
                if (q >= 3) continue;
                GlStateManager.func_179132_a((boolean)true);
            }
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDisable((int)3042);
            if (!ClientConfig.RENDER_CONFIG.rendering.helpMyFramesAreDying && !ClientConfig.RENDER_CONFIG.rendering.helpMyShadersAreDying) {
                if (!ClientConfig.RENDER_CONFIG.rendering.vanilla) {
                    ShaderLibrary.UNIVERSE.end();
                } else {
                    ShaderLibrary.UNIVERSE_DEFAULT.end();
                }
            }
            GlStateManager.func_179121_F();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class Events {
        @SubscribeEvent
        public void clientTick(TickEvent.ClientTickEvent event) {
            TELEPORT_RIFTS.removeIf(teleportRift -> teleportRift.lifeTime++ > teleportRift.maxLifeTime || teleportRift.reference.get() == null);
        }

        @SubscribeEvent
        public void onRenderAfterWorld(RenderWorldLastEvent event) {
            if (!TELEPORT_RIFTS.isEmpty()) {
                GlStateManager.func_179094_E();
                EntityPlayerSP playerEntity = Minecraft.func_71410_x().field_71439_g;
                double x = playerEntity.field_70142_S + (playerEntity.field_70165_t - playerEntity.field_70142_S) * 1.0;
                double y = playerEntity.field_70137_T + (playerEntity.field_70163_u - playerEntity.field_70137_T) * 1.0;
                double z = playerEntity.field_70136_U + (playerEntity.field_70161_v - playerEntity.field_70136_U) * 1.0;
                GlStateManager.func_179137_b((double)(-x), (double)(-y), (double)(-z));
                for (TeleportRift teleportRift : TELEPORT_RIFTS) {
                    teleportRift.render(event.getPartialTicks());
                }
                GlStateManager.func_179121_F();
            }
        }
    }
}

