/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.client.render.skill;

import arekkuusu.enderskills.client.ClientConfig;
import arekkuusu.enderskills.client.render.entity.EntityPlaceableDataRenderer;
import arekkuusu.enderskills.client.render.entity.EntityThrowableDataRenderer;
import arekkuusu.enderskills.client.render.skill.ProjectileVoid;
import arekkuusu.enderskills.client.render.skill.SkillRenderer;
import arekkuusu.enderskills.client.util.ResourceLibrary;
import arekkuusu.enderskills.client.util.ShaderLibrary;
import arekkuusu.enderskills.client.util.helper.RenderMisc;
import arekkuusu.enderskills.common.entity.placeable.EntityPlaceableData;
import arekkuusu.enderskills.common.entity.throwable.EntityThrowableData;
import arekkuusu.enderskills.common.skill.ModAbilities;
import arekkuusu.enderskills.common.skill.ability.mobility.ender.UnstablePortal;
import com.sasmaster.glelwjgl.java.CoreGLE;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class UnstablePortalRenderer
extends SkillRenderer<UnstablePortal> {
    public UnstablePortalRenderer() {
        EntityPlaceableDataRenderer.add(ModAbilities.UNSTABLE_PORTAL, (IRenderFactory<? super EntityPlaceableData>)((IRenderFactory)Placeable::new));
        EntityThrowableDataRenderer.add(ModAbilities.UNSTABLE_PORTAL, (IRenderFactory<? super EntityThrowableData>)((IRenderFactory)ProjectileVoid::new));
    }

    @SideOnly(value=Side.CLIENT)
    public static class Placeable
    extends Render<EntityPlaceableData> {
        public final CoreGLE gle = new CoreGLE();

        public Placeable(RenderManager renderManager) {
            super(renderManager);
        }

        public void doRender(EntityPlaceableData entity, double x, double y, double z, float entityYaw, float partialTicks) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            float scale = 1.0f;
            int growTime = 10;
            int shrinkTime = entity.getLifeTime() - 10;
            if (entity.tick < growTime) {
                scale = (float)entity.tick / (float)growTime;
            } else if (entity.tick > shrinkTime) {
                scale = 1.0f - (float)(entity.tick - shrinkTime) / 10.0f;
            }
            this.func_110776_a(this.getEntityTexture(entity));
            if (!ClientConfig.RENDER_CONFIG.rendering.helpMyFramesAreDying && !ClientConfig.RENDER_CONFIG.rendering.helpMyShadersAreDying) {
                if (!ClientConfig.RENDER_CONFIG.rendering.vanilla) {
                    ShaderLibrary.UNIVERSE.begin();
                    ShaderLibrary.UNIVERSE.set("dimensions", Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
                    ShaderLibrary.UNIVERSE.set("yaw", Minecraft.func_71410_x().field_71439_g.field_70177_z * 2.0f * (float)Math.PI / 360.0f);
                    ShaderLibrary.UNIVERSE.set("pitch", -(Minecraft.func_71410_x().field_71439_g.field_70125_A * 2.0f * (float)Math.PI / 360.0f));
                    ShaderLibrary.UNIVERSE.set("color", 0.9f, 0.12f, 0.4f);
                    ShaderLibrary.UNIVERSE.set("ticks", RenderMisc.getRenderPlayerTime() * 75.0f);
                    ShaderLibrary.UNIVERSE.set("alpha", 0.9f);
                } else {
                    ShaderLibrary.UNIVERSE_DEFAULT.begin();
                    ShaderLibrary.UNIVERSE_DEFAULT.set("yaw", Minecraft.func_71410_x().field_71439_g.field_70177_z * 2.0f * (float)Math.PI / 360.0f);
                    ShaderLibrary.UNIVERSE_DEFAULT.set("pitch", -(Minecraft.func_71410_x().field_71439_g.field_70125_A * 2.0f * (float)Math.PI / 360.0f));
                    ShaderLibrary.UNIVERSE_DEFAULT.set("time", RenderMisc.getRenderPlayerTime() * 75.0f);
                    ShaderLibrary.UNIVERSE_DEFAULT.set("alpha", 0.9f);
                }
            }
            GL11.glEnable((int)3042);
            float stab = 0.7f;
            float ticks = RenderMisc.getRenderPlayerTime() * 6.0f;
            if (entity.tick > growTime && entity.tick < shrinkTime) {
                scale = (float)((double)scale + Math.sin(ticks / 8.0f) * (double)0.1f * (double)stab);
            }
            for (int q = 0; q <= 3; ++q) {
                GlStateManager.func_179094_E();
                float s = entity.getRadius() * (q < 3 ? 1.1f + 0.05f * (float)q : 1.0f) * scale;
                GlStateManager.func_179152_a((float)s, (float)s, (float)s);
                if (q < 3) {
                    GlStateManager.func_179132_a((boolean)false);
                }
                GL11.glBlendFunc((int)770, (int)(q < 3 ? 1 : 771));
                RenderMisc.drawCubeRaw();
                if (q < 3) {
                    GlStateManager.func_179132_a((boolean)true);
                }
                GlStateManager.func_179121_F();
            }
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDisable((int)3042);
            if (!ClientConfig.RENDER_CONFIG.rendering.helpMyFramesAreDying && !ClientConfig.RENDER_CONFIG.rendering.helpMyShadersAreDying) {
                if (!ClientConfig.RENDER_CONFIG.rendering.vanilla) {
                    ShaderLibrary.UNIVERSE.end();
                } else {
                    ShaderLibrary.UNIVERSE_DEFAULT.end();
                }
            }
            GlStateManager.func_179121_F();
        }

        @Nonnull
        protected ResourceLocation getEntityTexture(EntityPlaceableData entity) {
            if (!ClientConfig.RENDER_CONFIG.rendering.vanilla || ClientConfig.RENDER_CONFIG.rendering.helpMyFramesAreDying) {
                return ResourceLibrary.DARK_BACKGROUND;
            }
            return ResourceLibrary.PORTAL_BACKGROUND;
        }
    }
}

