/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.client.render.skill;

import arekkuusu.enderskills.client.ClientConfig;
import arekkuusu.enderskills.client.render.skill.SkillRenderer;
import arekkuusu.enderskills.client.util.ResourceLibrary;
import arekkuusu.enderskills.client.util.ShaderLibrary;
import arekkuusu.enderskills.client.util.helper.RenderMisc;
import arekkuusu.enderskills.common.skill.ability.mobility.ender.Warp;
import com.google.common.collect.Lists;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class WarpRenderer
extends SkillRenderer<Warp> {
    public static final List<WarpRift> WARP_RIFTS = Lists.newArrayList();

    public WarpRenderer() {
        MinecraftForge.EVENT_BUS.register((Object)new Events());
    }

    public static class WarpRift {
        public final WeakReference<EntityLivingBase> reference;
        public final Vec3d positionVector;
        public final int maxLifeTime = 20;
        private final boolean inverse;
        public final Random random;
        public final float width;
        public final float height;
        public int lifeTime;

        public WarpRift(EntityLivingBase entity, Vec3d positionVector, boolean inverse) {
            this.reference = new WeakReference<EntityLivingBase>(entity);
            this.positionVector = positionVector;
            this.inverse = inverse;
            this.random = new Random(entity.field_70170_p.field_73012_v.nextLong());
            this.width = entity.field_70130_N;
            this.height = entity.field_70131_O;
        }

        public void render(float partialTicks) {
            EntityLivingBase entity = (EntityLivingBase)this.reference.get();
            if (entity == null) {
                return;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)this.positionVector.field_72450_a, (double)this.positionVector.field_72448_b, (double)this.positionVector.field_72449_c);
            if (!ClientConfig.RENDER_CONFIG.rendering.vanilla || ClientConfig.RENDER_CONFIG.rendering.helpMyFramesAreDying) {
                Minecraft.func_71410_x().func_175598_ae().field_78724_e.func_110577_a(ResourceLibrary.DARK_BACKGROUND);
            } else {
                Minecraft.func_71410_x().func_175598_ae().field_78724_e.func_110577_a(ResourceLibrary.PORTAL_BACKGROUND);
            }
            GlStateManager.func_179147_l();
            float scale = 1.0f;
            int growTime = 10;
            int shrinkTime = 10;
            if (this.lifeTime < growTime) {
                scale = (float)this.lifeTime / (float)growTime;
            } else if (this.lifeTime > shrinkTime) {
                scale = 1.0f - (float)(this.lifeTime - shrinkTime) / 10.0f;
            }
            double yOffset = this.inverse ? -0.001 : 0.001;
            float width = this.width * 1.5f * scale;
            float alpha = 0.4f;
            GL11.glEnable((int)3042);
            for (int i = 0; i < 4; ++i) {
                this.drawVoid(width, RenderMisc.getRenderPlayerTime() - (float)i, yOffset, alpha, true);
                this.drawVoid(width * 0.9f, RenderMisc.getRenderPlayerTime() - (float)i, yOffset, alpha, true);
                this.drawVoid(width * 0.8f, RenderMisc.getRenderPlayerTime() - (float)i, yOffset, alpha, false);
                yOffset += this.inverse ? -0.012 : 0.012;
                alpha = (float)((double)alpha * 0.8);
            }
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDisable((int)3042);
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }

        public void drawVoid(float width, float ticks, double yOffset, float alpha, boolean outline) {
            if (outline) {
                GlStateManager.func_179132_a((boolean)false);
            }
            GL11.glBlendFunc((int)770, (int)(outline ? 1 : 771));
            if (!ClientConfig.RENDER_CONFIG.rendering.helpMyFramesAreDying && !ClientConfig.RENDER_CONFIG.rendering.helpMyShadersAreDying) {
                if (!ClientConfig.RENDER_CONFIG.rendering.vanilla) {
                    ShaderLibrary.UNIVERSE.begin();
                    ShaderLibrary.UNIVERSE.set("dimensions", Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
                    ShaderLibrary.UNIVERSE.set("yaw", Minecraft.func_71410_x().field_71439_g.field_70177_z * 2.0f * (float)Math.PI / 360.0f);
                    ShaderLibrary.UNIVERSE.set("pitch", -(Minecraft.func_71410_x().field_71439_g.field_70125_A * 2.0f * (float)Math.PI / 360.0f));
                    ShaderLibrary.UNIVERSE.set("color", 0.36f, 0.12f, 0.4f);
                    ShaderLibrary.UNIVERSE.set("ticks", ticks);
                    ShaderLibrary.UNIVERSE.set("alpha", alpha);
                } else {
                    ShaderLibrary.UNIVERSE_DEFAULT.begin();
                    ShaderLibrary.UNIVERSE_DEFAULT.set("yaw", Minecraft.func_71410_x().field_71439_g.field_70177_z * 2.0f * (float)Math.PI / 360.0f);
                    ShaderLibrary.UNIVERSE_DEFAULT.set("pitch", -(Minecraft.func_71410_x().field_71439_g.field_70125_A * 2.0f * (float)Math.PI / 360.0f));
                    ShaderLibrary.UNIVERSE_DEFAULT.set("time", ticks);
                    ShaderLibrary.UNIVERSE_DEFAULT.set("alpha", alpha);
                }
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)0.0, (double)yOffset, (double)0.0);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b((double)width, 0.0, (double)(-width)).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b((double)width, 0.0, (double)width).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b((double)(-width), 0.0, (double)width).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b((double)(-width), 0.0, (double)(-width)).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b((double)(-width), 0.0, (double)(-width)).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b((double)(-width), 0.0, (double)width).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b((double)width, 0.0, (double)width).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b((double)width, 0.0, (double)(-width)).func_187315_a(1.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
            if (!ClientConfig.RENDER_CONFIG.rendering.helpMyFramesAreDying && !ClientConfig.RENDER_CONFIG.rendering.helpMyShadersAreDying) {
                if (!ClientConfig.RENDER_CONFIG.rendering.vanilla) {
                    ShaderLibrary.UNIVERSE.end();
                } else {
                    ShaderLibrary.UNIVERSE_DEFAULT.end();
                }
            }
            if (outline) {
                GlStateManager.func_179132_a((boolean)true);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class Events {
        @SubscribeEvent
        public void clientTick(TickEvent.ClientTickEvent event) {
            WARP_RIFTS.removeIf(warpRift -> warpRift.lifeTime++ > warpRift.maxLifeTime || warpRift.reference.get() == null);
        }

        @SubscribeEvent
        public void onRenderAfterWorld(RenderWorldLastEvent event) {
            if (!WARP_RIFTS.isEmpty()) {
                GlStateManager.func_179094_E();
                EntityPlayerSP playerEntity = Minecraft.func_71410_x().field_71439_g;
                double x = playerEntity.field_70142_S + (playerEntity.field_70165_t - playerEntity.field_70142_S) * 1.0;
                double y = playerEntity.field_70137_T + (playerEntity.field_70163_u - playerEntity.field_70137_T) * 1.0;
                double z = playerEntity.field_70136_U + (playerEntity.field_70161_v - playerEntity.field_70136_U) * 1.0;
                GlStateManager.func_179137_b((double)(-x), (double)(-y), (double)(-z));
                for (WarpRift warpRift : WARP_RIFTS) {
                    warpRift.render(event.getPartialTicks());
                }
                GlStateManager.func_179121_F();
            }
        }
    }
}

