/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.client.render.skill.status;

import arekkuusu.enderskills.client.ClientConfig;
import arekkuusu.enderskills.client.render.skill.SkillRenderer;
import arekkuusu.enderskills.client.util.ShaderLibrary;
import arekkuusu.enderskills.client.util.helper.GLHelper;
import arekkuusu.enderskills.common.skill.ModEffects;
import arekkuusu.enderskills.common.skill.SkillHelper;
import arekkuusu.enderskills.common.skill.effect.Invulnerable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class InvulnerableRenderer
extends SkillRenderer<Invulnerable> {
    private static final ResourceLocation FOLLOWING_HEAD = new ResourceLocation("enderskills", "textures/entity/nearby_invincibility_0.png");

    public InvulnerableRenderer() {
        MinecraftForge.EVENT_BUS.register((Object)new Events());
    }

    @SideOnly(value=Side.CLIENT)
    public static class Events {
        public final String key = ModEffects.INVULNERABLE.getRegistryName() + ":tick";

        @SubscribeEvent
        public void onLivingPreRender(RenderLivingEvent.Post<EntityLivingBase> event) {
            if (this.getTick((Entity)event.getEntity()) > 0) {
                EntityLivingBase entity = event.getEntity();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)event.getX(), (double)(event.getY() + (double)entity.field_70131_O + 0.5), (double)event.getZ());
                GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)((float)entity.field_70173_aa * 0.75f % 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                GLHelper.BLEND_SRC_ALPHA$ONE.blend();
                if (!ClientConfig.RENDER_CONFIG.rendering.helpMyShadersAreDying) {
                    ShaderLibrary.ALPHA.begin();
                    ShaderLibrary.ALPHA.set("alpha", 0.5f * (float)this.getTick((Entity)entity) / 10.0f);
                }
                GlStateManager.func_179140_f();
                GlStateManager.func_179147_l();
                this.bindTexture(FOLLOWING_HEAD);
                this.drawHeadWithOffset(0.2);
                GlStateManager.func_179084_k();
                GlStateManager.func_179145_e();
                if (!ClientConfig.RENDER_CONFIG.rendering.helpMyShadersAreDying) {
                    ShaderLibrary.ALPHA.end();
                }
                GLHelper.BLEND_NORMAL.blend();
                GlStateManager.func_179121_F();
            }
        }

        @SubscribeEvent
        public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
            if (!event.getEntityLiving().field_70170_p.field_72995_K) {
                return;
            }
            boolean active = SkillHelper.isActive(event.getEntity(), ModEffects.INVULNERABLE);
            if (active) {
                if (this.getTick(event.getEntity()) < 10) {
                    this.setTick(event.getEntity(), this.getTick(event.getEntity()) + 1);
                }
            } else if (this.getTick(event.getEntity()) > 0) {
                this.setTick(event.getEntity(), this.getTick(event.getEntity()) - 1);
            }
        }

        public int getTick(Entity entity) {
            NBTTagCompound nbt = entity.getEntityData();
            return nbt.func_74764_b(this.key) ? nbt.func_74762_e(this.key) : -1;
        }

        public void setTick(Entity entity, int tick) {
            NBTTagCompound nbt = entity.getEntityData();
            nbt.func_74768_a(this.key, tick);
        }

        public void bindTexture(ResourceLocation location) {
            Minecraft.func_71410_x().func_175598_ae().field_78724_e.func_110577_a(location);
        }

        public void drawHeadWithOffset(double scale) {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b(-scale, -scale, -scale).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(scale, -scale, -scale).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(scale, scale, -scale).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(-scale, scale, -scale).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b(-scale, scale, -scale).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b(scale, scale, -scale).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(scale, -scale, -scale).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(-scale, -scale, -scale).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(scale, -scale, scale).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(-scale, -scale, scale).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(-scale, scale, scale).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(scale, scale, scale).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b(scale, scale, scale).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b(-scale, scale, scale).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(-scale, -scale, scale).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(scale, -scale, scale).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(-scale, -scale, scale).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(-scale, -scale, -scale).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(-scale, scale, -scale).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(-scale, scale, scale).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b(-scale, scale, scale).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b(-scale, scale, -scale).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(-scale, -scale, -scale).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(-scale, -scale, scale).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(scale, -scale, -scale).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(scale, -scale, scale).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(scale, scale, scale).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(scale, scale, -scale).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b(scale, scale, -scale).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b(scale, scale, scale).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(scale, -scale, scale).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(scale, -scale, -scale).func_187315_a(0.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
        }
    }
}

