/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.client.render.skill.status;

import arekkuusu.enderskills.client.render.skill.SkillRenderer;
import arekkuusu.enderskills.common.skill.ModEffects;
import arekkuusu.enderskills.common.skill.SkillHelper;
import arekkuusu.enderskills.common.skill.effect.Overheal;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class OverhealRenderer
extends SkillRenderer<Overheal> {
    private static final ResourceLocation RES_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");

    public OverhealRenderer() {
        MinecraftForge.EVENT_BUS.register((Object)new Events());
    }

    @SideOnly(value=Side.CLIENT)
    public static class Events {
        public final String tickKey = ModEffects.OVERHEAL.getRegistryName() + ":tick";

        @SubscribeEvent
        public void onLivingPostRender(RenderLivingEvent.Post<EntityLivingBase> event) {
            Render render = Minecraft.func_71410_x().func_175598_ae().func_78713_a((Entity)event.getEntity());
            if (!(render instanceof RenderLivingBase)) {
                return;
            }
            if (this.getTick((Entity)event.getEntity()) > 0) {
                RenderLivingBase livingRender = (RenderLivingBase)render;
                EntityLivingBase entity = event.getEntity();
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)event.getX(), (double)event.getY(), (double)event.getZ());
                GlStateManager.func_179147_l();
                GlStateManager.func_179132_a((boolean)false);
                GlStateManager.func_179143_c((int)514);
                GlStateManager.func_179140_f();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                GlStateManager.func_179094_E();
                GlStateManager.func_179131_c((float)0.38f, (float)0.608f, (float)0.19f, (float)(1.0f * ((float)this.getTick((Entity)entity) / 10.0f)));
                Minecraft.func_71410_x().func_110434_K().func_110577_a(RES_ITEM_GLINT);
                GlStateManager.func_179128_n((int)5890);
                GlStateManager.func_179152_a((float)0.25f, (float)0.25f, (float)0.25f);
                float i = (float)(Minecraft.func_71386_F() % 5000L) / 5000.0f * 6.0f;
                GlStateManager.func_179109_b((float)i, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179128_n((int)5888);
                this.renderModel((RenderLivingBase<EntityLivingBase>)livingRender, entity, event.getPartialRenderTick());
                GlStateManager.func_179121_F();
                GlStateManager.func_179094_E();
                GlStateManager.func_179131_c((float)0.38f, (float)0.608f, (float)0.19f, (float)(1.0f * ((float)this.getTick((Entity)entity) / 10.0f)));
                Minecraft.func_71410_x().func_110434_K().func_110577_a(RES_ITEM_GLINT);
                GlStateManager.func_179128_n((int)5890);
                GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
                float i0 = (float)(Minecraft.func_71386_F() % 6873L) / 6873.0f * 6.0f;
                GlStateManager.func_179109_b((float)(-i0), (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)40.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179128_n((int)5888);
                this.renderModel((RenderLivingBase<EntityLivingBase>)livingRender, entity, event.getPartialRenderTick());
                GlStateManager.func_179121_F();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                GlStateManager.func_179145_e();
                GlStateManager.func_179143_c((int)515);
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179084_k();
                GlStateManager.func_179121_F();
                GlStateManager.func_179128_n((int)5890);
                GlStateManager.func_179096_D();
                GlStateManager.func_179128_n((int)5888);
            }
        }

        public void renderModel(RenderLivingBase<EntityLivingBase> render, EntityLivingBase entity, float partialTicks) {
            boolean flag1;
            boolean flag = this.isVisible(entity);
            boolean bl = flag1 = !flag && !entity.func_98034_c((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            if (flag || flag1) {
                boolean shouldSit = entity.func_184218_aH() && entity.func_184187_bx() != null && entity.func_184187_bx().shouldRiderSit();
                ModelBase base = render.func_177087_b();
                float f = this.interpolateRotation(entity.field_70760_ar, entity.field_70761_aq, partialTicks);
                float f1 = this.interpolateRotation(entity.field_70758_at, entity.field_70759_as, partialTicks);
                float f2 = f1 - f;
                float f7 = entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * partialTicks;
                float f8 = this.handleRotationFloat(entity, partialTicks);
                this.applyRotations(entity, f, partialTicks);
                float f4 = render.func_188322_c(entity, partialTicks);
                float f5 = 0.0f;
                float f6 = 0.0f;
                if (shouldSit && entity.func_184187_bx() instanceof EntityLivingBase) {
                    EntityLivingBase entitylivingbase = (EntityLivingBase)entity.func_184187_bx();
                    f = this.interpolateRotation(entitylivingbase.field_70760_ar, entitylivingbase.field_70761_aq, partialTicks);
                    f2 = f1 - f;
                    float f3 = MathHelper.func_76142_g((float)f2);
                    if (f3 < -85.0f) {
                        f3 = -85.0f;
                    }
                    if (f3 >= 85.0f) {
                        f3 = 85.0f;
                    }
                    f = f1 - f3;
                    if (f3 * f3 > 2500.0f) {
                        f += f3 * 0.2f;
                    }
                    f2 = f1 - f;
                }
                if (!entity.func_184218_aH()) {
                    f5 = entity.field_184618_aE + (entity.field_70721_aZ - entity.field_184618_aE) * partialTicks;
                    f6 = entity.field_184619_aG - entity.field_70721_aZ * (1.0f - partialTicks);
                    if (entity.func_70631_g_()) {
                        f6 *= 3.0f;
                    }
                    if (f5 > 1.0f) {
                        f5 = 1.0f;
                    }
                    f2 = f1 - f;
                }
                if (flag1) {
                    GlStateManager.func_187408_a((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
                }
                base.func_78088_a((Entity)entity, f6, f5, f8, f2, f7, f4);
                if (flag1) {
                    GlStateManager.func_187440_b((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
                }
            }
        }

        public void applyRotations(EntityLivingBase entityLiving, float rotationYaw, float partialTicks) {
            GlStateManager.func_179114_b((float)(180.0f - rotationYaw), (float)0.0f, (float)1.0f, (float)0.0f);
            if (entityLiving.field_70725_aQ > 0) {
                float f = ((float)entityLiving.field_70725_aQ + partialTicks - 1.0f) / 20.0f * 1.6f;
                if ((f = MathHelper.func_76129_c((float)f)) > 1.0f) {
                    f = 1.0f;
                }
                GlStateManager.func_179114_b((float)(f * 90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            } else {
                String s = TextFormatting.func_110646_a((String)entityLiving.func_70005_c_());
                if (("Dinnerbone".equals(s) || "Grumm".equals(s)) && (!(entityLiving instanceof EntityPlayer) || ((EntityPlayer)entityLiving).func_175148_a(EnumPlayerModelParts.CAPE))) {
                    GlStateManager.func_179109_b((float)0.0f, (float)(entityLiving.field_70131_O + 0.1f), (float)0.0f);
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                }
            }
        }

        public float interpolateRotation(float prevYawOffset, float yawOffset, float partialTicks) {
            float f;
            for (f = yawOffset - prevYawOffset; f < -180.0f; f += 360.0f) {
            }
            while (f >= 180.0f) {
                f -= 360.0f;
            }
            return prevYawOffset + partialTicks * f;
        }

        public float handleRotationFloat(EntityLivingBase livingBase, float partialTicks) {
            return (float)livingBase.field_70173_aa + partialTicks;
        }

        public boolean isVisible(EntityLivingBase livingBase) {
            return !livingBase.func_82150_aj();
        }

        public void bindTexture(ResourceLocation location) {
            Minecraft.func_71410_x().func_175598_ae().field_78724_e.func_110577_a(location);
        }

        @SubscribeEvent
        public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
            if (!event.getEntityLiving().field_70170_p.field_72995_K) {
                return;
            }
            boolean active = SkillHelper.isActive(event.getEntity(), ModEffects.OVERHEAL);
            if (active) {
                if (this.getTick(event.getEntity()) < 10) {
                    this.setTick(event.getEntity(), this.getTick(event.getEntity()) + 1);
                }
            } else if (this.getTick(event.getEntity()) > 0) {
                this.setTick(event.getEntity(), this.getTick(event.getEntity()) - 1);
            }
        }

        public int getTick(Entity entity) {
            NBTTagCompound nbt = entity.getEntityData();
            return nbt.func_74764_b(this.tickKey) ? nbt.func_74762_e(this.tickKey) : -1;
        }

        public void setTick(Entity entity, int tick) {
            NBTTagCompound nbt = entity.getEntityData();
            nbt.func_74768_a(this.tickKey, tick);
        }
    }
}

