/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.client.render.tile;

import arekkuusu.enderskills.client.ClientConfig;
import arekkuusu.enderskills.client.util.ResourceLibrary;
import arekkuusu.enderskills.client.util.ShaderLibrary;
import arekkuusu.enderskills.client.util.helper.RenderMisc;
import arekkuusu.enderskills.client.util.helper.TextHelper;
import arekkuusu.enderskills.common.block.tile.TileAltar;
import arekkuusu.enderskills.common.item.ModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBook;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TileAltarRenderer
extends TileEntitySpecialRenderer<TileAltar> {
    private static final ResourceLocation TEXTURE_BOOK = new ResourceLocation("enderskills", "textures/entity/altar_book.png");
    private final ModelBook modelBook = new ModelBook();

    public void render(TileAltar tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (MinecraftForgeClient.getRenderPass() == 0) {
            float rotation;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 1.25), (double)(z + 0.5));
            float limbSwing = (float)tile.tickCount + partialTicks;
            GlStateManager.func_179109_b((float)0.0f, (float)(0.1f + MathHelper.func_76126_a((float)(limbSwing * 0.1f)) * 0.01f), (float)0.0f);
            for (rotation = tile.bookRotation - tile.bookRotationPrev; rotation >= (float)Math.PI; rotation -= (float)Math.PI * 2) {
            }
            while (rotation < (float)(-Math.PI)) {
                rotation += (float)Math.PI * 2;
            }
            GlStateManager.func_179114_b((float)(-(tile.bookRotationPrev + rotation * partialTicks) * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)80.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            this.func_147499_a(TEXTURE_BOOK);
            float limbSwingAmount = tile.pageFlipPrev + (tile.pageFlip - tile.pageFlipPrev) * partialTicks + 0.25f;
            float ageInTicks = tile.pageFlipPrev + (tile.pageFlip - tile.pageFlipPrev) * partialTicks + 0.75f;
            limbSwingAmount = MathHelper.func_76131_a((float)((limbSwingAmount - (float)MathHelper.func_76140_b((double)limbSwingAmount)) * 1.6f - 0.3f), (float)0.0f, (float)1.0f);
            ageInTicks = MathHelper.func_76131_a((float)((ageInTicks - (float)MathHelper.func_76140_b((double)ageInTicks)) * 1.6f - 0.3f), (float)0.0f, (float)1.0f);
            GlStateManager.func_179089_o();
            this.modelBook.func_78088_a(null, limbSwing, limbSwingAmount, ageInTicks, tile.bookSpreadPrev + (tile.bookSpread - tile.bookSpreadPrev) * partialTicks, 0.0f, 0.0625f);
            GlStateManager.func_179129_p();
            GlStateManager.func_179121_F();
            if (tile.getLevel() == 1.0 && !tile.isUltimate() && tile.bookSpread > 0.5f) {
                ShaderLibrary.ALPHA.begin();
                ShaderLibrary.ALPHA.set("alpha", 0.5f);
                GlStateManager.func_179094_E();
                GlStateManager.func_179147_l();
                GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 1.45), (double)(z + 0.5));
                GlStateManager.func_179114_b((float)((float)tile.tickCount * 0.5f % 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                RenderMisc.renderItemStack(new ItemStack(ModItems.CRYSTAL_MATRIX));
                GlStateManager.func_179084_k();
                GlStateManager.func_179121_F();
                ShaderLibrary.ALPHA.end();
            }
        }
        if (MinecraftForgeClient.getRenderPass() == 1 && tile.lastLevelAnimationTimer > 0) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + (double)0.01f), (double)(z + 0.5));
            GlStateManager.func_179147_l();
            if (!ClientConfig.RENDER_CONFIG.rendering.vanilla || ClientConfig.RENDER_CONFIG.rendering.helpMyFramesAreDying) {
                this.func_147499_a(ResourceLibrary.DARK_BACKGROUND);
            } else {
                this.func_147499_a(ResourceLibrary.PORTAL_BACKGROUND);
            }
            if (!ClientConfig.RENDER_CONFIG.rendering.helpMyFramesAreDying) {
                if (!ClientConfig.RENDER_CONFIG.rendering.vanilla) {
                    ShaderLibrary.UNIVERSE.begin();
                    ShaderLibrary.UNIVERSE.set("dimensions", Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
                    ShaderLibrary.UNIVERSE.set("yaw", Minecraft.func_71410_x().field_71439_g.field_70177_z * 2.0f * (float)Math.PI / 360.0f);
                    ShaderLibrary.UNIVERSE.set("pitch", -(Minecraft.func_71410_x().field_71439_g.field_70125_A * 2.0f * (float)Math.PI / 360.0f));
                    ShaderLibrary.UNIVERSE.set("color", 0.36f, 0.12f, 0.4f);
                    ShaderLibrary.UNIVERSE.set("ticks", RenderMisc.getRenderPlayerTime());
                    ShaderLibrary.UNIVERSE.set("alpha", 0.9f * ((float)tile.lastLevelAnimationTimer / 50.0f));
                } else {
                    ShaderLibrary.UNIVERSE_DEFAULT.begin();
                    ShaderLibrary.UNIVERSE_DEFAULT.set("yaw", Minecraft.func_71410_x().field_71439_g.field_70177_z * 2.0f * (float)Math.PI / 360.0f);
                    ShaderLibrary.UNIVERSE_DEFAULT.set("pitch", -(Minecraft.func_71410_x().field_71439_g.field_70125_A * 2.0f * (float)Math.PI / 360.0f));
                    ShaderLibrary.UNIVERSE_DEFAULT.set("time", RenderMisc.getRenderPlayerTime());
                    ShaderLibrary.UNIVERSE_DEFAULT.set("alpha", 0.9f * ((float)tile.lastLevelAnimationTimer / 50.0f));
                }
            }
            GL11.glEnable((int)3042);
            this.drawVoid();
            float scale = 1.0f + (float)tile.lastLevelAnimationTimer / 50.0f * 4.0f;
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            RenderMisc.drawObj(0xFFFFFF, (float)tile.lastLevelAnimationTimer / 50.0f, RenderMisc.sphereId);
            GL11.glDisable((int)3042);
            if (!ClientConfig.RENDER_CONFIG.rendering.helpMyFramesAreDying) {
                if (!ClientConfig.RENDER_CONFIG.rendering.vanilla) {
                    ShaderLibrary.UNIVERSE.end();
                } else {
                    ShaderLibrary.UNIVERSE_DEFAULT.end();
                }
            }
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
        if (!tile.isUltimate() && tile.getLevel() == 1.0) {
            this.func_190053_a(true);
            this.func_190052_a(tile, TextHelper.translate("altar_drop_line_0", new Object[0]), x, y + 0.75, z, 2);
            this.func_190052_a(tile, TextHelper.translate("altar_drop_line_1", new Object[0]), x, y + 0.5, z, 2);
            this.func_190053_a(false);
        }
    }

    public void drawVoid() {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        double width = 5.0;
        buffer.func_181662_b(width, 0.0, -width).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b(width, 0.0, width).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b(-width, 0.0, width).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b(-width, 0.0, -width).func_187315_a(0.0, 0.0).func_181675_d();
        buffer.func_181662_b(-width, 0.0, -width).func_187315_a(0.0, 0.0).func_181675_d();
        buffer.func_181662_b(-width, 0.0, width).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b(width, 0.0, width).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b(width, 0.0, -width).func_187315_a(1.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }
}

