/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.client.util;

import arekkuusu.enderskills.api.registry.Skill;
import com.google.common.collect.Sets;
import java.util.Objects;
import java.util.Set;
import net.minecraft.util.ResourceLocation;

public class ResourceLibrary {
    public static final Set<ResourceLocation> ATLAS_SET = Sets.newHashSet();
    public static final ResourceLocation DARK_BACKGROUND = new ResourceLocation("enderskills", "textures/entity/dark_background.png");
    public static final ResourceLocation PORTAL_BACKGROUND = new ResourceLocation("textures/entity/end_portal.png");
    public static final ResourceLocation PLUS = ResourceLibrary.createAtlasTexture("enderskills", "effect", "plus");
    public static final ResourceLocation MINUS = ResourceLibrary.createAtlasTexture("enderskills", "effect", "minus");
    public static final ResourceLocation MOTE = ResourceLibrary.createAtlasTexture("enderskills", "effect", "mote");
    public static final ResourceLocation SPIRAL = ResourceLibrary.createAtlasTexture("enderskills", "effect", "spiral");
    public static final ResourceLocation SPIT = ResourceLibrary.createAtlasTexture("enderskills", "effect", "spit");
    public static final ResourceLocation SKULL = ResourceLibrary.createAtlasTexture("enderskills", "effect", "skull");
    public static final ResourceLocation DROPLET = ResourceLibrary.createAtlasTexture("enderskills", "effect", "droplet");
    public static final ResourceLocation CROSS = ResourceLibrary.createAtlasTexture("enderskills", "effect", "cross");
    public static final ResourceLocation ANGRY = ResourceLibrary.createAtlasTexture("enderskills", "effect", "angry");
    public static final ResourceLocation GLOW = ResourceLibrary.createAtlasTexture("enderskills", "effect", "glow_particle");
    public static final ResourceLocation BLOOD = ResourceLibrary.createAtlasTexture("enderskills", "blocks", "blood");
    public static final ResourceLocation VOLT_PARTICLE = ResourceLibrary.createAtlasTexture("enderskills", "effect", "volt_particle");
    public static final ResourceLocation RAIN = ResourceLibrary.createAtlasTexture("enderskills", "effect", "rain");
    public static final ResourceLocation POTION_TEXTURES;
    public static final ResourceLocation ENDURANCE_BACKGROUND;
    public static final ResourceLocation ENDURANCE_BACKGROUND_;
    public static final ResourceLocation SKILL_BACKGROUND;

    public static ResourceLocation createAtlasTexture(String modId, String folder, String name) {
        return new ResourceLocation(modId, folder + "/" + name);
    }

    public static ResourceLocation getSkillTexture(Skill skill) {
        Objects.requireNonNull(skill.getRegistryName());
        return new ResourceLocation(skill.getRegistryName().func_110624_b(), "skills/" + skill.getRegistryName().func_110623_a());
    }

    static {
        ATLAS_SET.add(PLUS);
        ATLAS_SET.add(MINUS);
        ATLAS_SET.add(MOTE);
        ATLAS_SET.add(SPIRAL);
        ATLAS_SET.add(SPIT);
        ATLAS_SET.add(SKULL);
        ATLAS_SET.add(DROPLET);
        ATLAS_SET.add(CROSS);
        ATLAS_SET.add(ANGRY);
        ATLAS_SET.add(GLOW);
        ATLAS_SET.add(BLOOD);
        ATLAS_SET.add(VOLT_PARTICLE);
        ATLAS_SET.add(RAIN);
        POTION_TEXTURES = new ResourceLocation("enderskills", "textures/gui/potions.png");
        ENDURANCE_BACKGROUND = new ResourceLocation("enderskills", "textures/gui/endurance_background.png");
        ENDURANCE_BACKGROUND_ = new ResourceLocation("enderskills", "textures/gui/endurance_background_.png");
        SKILL_BACKGROUND = new ResourceLocation("enderskills", "textures/gui/skill_background.png");
    }
}

