/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.client.util.helper;

import arekkuusu.enderskills.client.util.helper.IModel;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class ModelHelper {
    public static void registerModels() {
        for (Block block : Block.field_149771_c) {
            if (!(block instanceof IModel)) continue;
            ((IModel)block).registerModel();
        }
        for (Item item : Item.field_150901_e) {
            if (!(item instanceof IModel)) continue;
            ((IModel)item).registerModel();
        }
    }

    public static void registerModel(Block block, int meta, ModelResourceLocation location) {
        Item item = Item.func_150898_a((Block)block);
        if (item == Items.field_190931_a) {
            throw new UnsupportedOperationException("This block has no Item!");
        }
        ModelHelper.registerModel(item, meta, location);
    }

    public static void registerModel(Item item, int meta, ModelResourceLocation location) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)location);
    }

    public static void registerModel(Block block, int meta, String variant) {
        Item item = Item.func_150898_a((Block)block);
        if (item == Items.field_190931_a) {
            throw new UnsupportedOperationException("This block has no Item!");
        }
        ModelHelper.registerModel(item, meta, variant);
    }

    public static void registerModel(Item item, int meta, String variant) {
        ModelResourceLocation location = new ModelResourceLocation(item.getRegistryName(), variant);
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)location);
    }

    public static void registerModel(Block block, int meta) {
        Item item = Item.func_150898_a((Block)block);
        if (item == Items.field_190931_a) {
            throw new UnsupportedOperationException("This block has no Item!");
        }
        ModelHelper.registerModel(item, meta);
    }

    public static void registerModel(Item item, int meta) {
        ModelResourceLocation location = new ModelResourceLocation(item.getRegistryName(), "");
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)location);
    }

    public static <T extends Enum<T>> void registerModel(Block block, Class<T> clazz) {
        Item item = Item.func_150898_a((Block)block);
        if (item == Items.field_190931_a) {
            throw new UnsupportedOperationException("This block has no Item!");
        }
        ModelHelper.registerModel(item, clazz);
    }

    public static <T extends Enum<T>> void registerModel(Item item, Class<T> clazz) {
        for (Enum t : (Enum[])clazz.getEnumConstants()) {
            ResourceLocation location = new ResourceLocation(item.getRegistryName() + "/" + ((IStringSerializable)t).func_176610_l());
            ModelResourceLocation modelResourceLocation = new ModelResourceLocation(location, "");
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)t.ordinal(), (ModelResourceLocation)modelResourceLocation);
        }
    }
}

