/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.client.util.helper;

import arekkuusu.enderskills.api.util.Vector;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.Sphere;

@SideOnly(value=Side.CLIENT)
public final class RenderMisc {
    public static int sphereId = 0;
    public static int cubeId = 0;
    private static final Random RAND = new Random();

    public static void init() {
        Sphere sphere = new Sphere();
        sphereId = RenderMisc.create(() -> {
            GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            sphere.draw(1.0f, 32, 16);
            GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        });
        cubeId = RenderMisc.create(() -> RenderMisc.drawCubeRaw());
    }

    public static void drawObj(int color, float alpha, int id) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)alpha);
        GlStateManager.func_179148_o((int)id);
    }

    public static void drawCubeRaw() {
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder bb = tes.func_178180_c();
        bb.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bb.func_181662_b(-0.5, 0.5, -0.5).func_181675_d();
        bb.func_181662_b(0.5, 0.5, -0.5).func_181675_d();
        bb.func_181662_b(0.5, -0.5, -0.5).func_181675_d();
        bb.func_181662_b(-0.5, -0.5, -0.5).func_181675_d();
        bb.func_181662_b(0.5, 0.5, 0.5).func_181675_d();
        bb.func_181662_b(-0.5, 0.5, 0.5).func_181675_d();
        bb.func_181662_b(-0.5, -0.5, 0.5).func_181675_d();
        bb.func_181662_b(0.5, -0.5, 0.5).func_181675_d();
        bb.func_181662_b(0.5, 0.5, -0.5).func_181675_d();
        bb.func_181662_b(0.5, 0.5, 0.5).func_181675_d();
        bb.func_181662_b(0.5, -0.5, 0.5).func_181675_d();
        bb.func_181662_b(0.5, -0.5, -0.5).func_181675_d();
        bb.func_181662_b(-0.5, 0.5, 0.5).func_181675_d();
        bb.func_181662_b(-0.5, 0.5, -0.5).func_181675_d();
        bb.func_181662_b(-0.5, -0.5, -0.5).func_181675_d();
        bb.func_181662_b(-0.5, -0.5, 0.5).func_181675_d();
        bb.func_181662_b(-0.5, 0.5, 0.5).func_181675_d();
        bb.func_181662_b(0.5, 0.5, 0.5).func_181675_d();
        bb.func_181662_b(0.5, 0.5, -0.5).func_181675_d();
        bb.func_181662_b(-0.5, 0.5, -0.5).func_181675_d();
        bb.func_181662_b(-0.5, -0.5, -0.5).func_181675_d();
        bb.func_181662_b(0.5, -0.5, -0.5).func_181675_d();
        bb.func_181662_b(0.5, -0.5, 0.5).func_181675_d();
        bb.func_181662_b(-0.5, -0.5, 0.5).func_181675_d();
        tes.func_78381_a();
    }

    public static int create(Runnable r) {
        int res = GLAllocation.func_74526_a((int)1);
        GlStateManager.func_187423_f((int)res, (int)4864);
        r.run();
        GlStateManager.func_187415_K();
        return res;
    }

    public static float getRenderWorldTime(float partialTicks) {
        return ((float)Minecraft.func_71386_F() + partialTicks) / 20.0f;
    }

    public static float getRenderPlayerTime() {
        return Minecraft.func_71410_x().field_71439_g.field_70173_aa;
    }

    public static Vector getRenderViewVector(float partial) {
        Entity rView = Minecraft.func_71410_x().func_175606_aa();
        if (rView == null) {
            rView = Minecraft.func_71410_x().field_71439_g;
        }
        Entity entity = rView;
        double tx = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partial;
        double ty = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partial;
        double tz = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partial;
        return new Vector(tx, ty, tz);
    }

    public static Vector getRenderViewVector(Entity entity, float partial) {
        double tx = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partial;
        double ty = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partial;
        double tz = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partial;
        return new Vector(tx, ty, tz);
    }

    public static void renderBeams(float age, int number, int startRBG, int endRGB, float size) {
        GL11.glDisable((int)3553);
        GL11.glShadeModel((int)7425);
        GL11.glDisable((int)3008);
        RAND.setSeed(432L);
        float r_ = (float)(startRBG >>> 16 & 0xFF) / 256.0f;
        float g_ = (float)(startRBG >>> 8 & 0xFF) / 256.0f;
        float b_ = (float)(startRBG & 0xFF) / 256.0f;
        float r = (float)(endRGB >>> 16 & 0xFF) / 256.0f;
        float g = (float)(endRGB >>> 8 & 0xFF) / 256.0f;
        float b = (float)(endRGB & 0xFF) / 256.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        float rotation = age % 500.0f;
        int i = 0;
        while ((float)i < (float)number) {
            GlStateManager.func_179114_b((float)(RAND.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(RAND.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(RAND.nextFloat() * 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)(RAND.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(RAND.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(RAND.nextFloat() * 360.0f + rotation * 90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            float min = size * 0.5f;
            float resized = RAND.nextFloat() * size + min;
            float sizeMulti = RAND.nextFloat() * min + min * 0.5f;
            bufferbuilder.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            bufferbuilder.func_181662_b(0.0, 0.0, 0.0).func_181666_a(r_, g_, b_, 1.0f).func_181675_d();
            bufferbuilder.func_181662_b(-0.866 * (double)sizeMulti, (double)resized, (double)(-0.5f * sizeMulti)).func_181666_a(r, g, b, 0.0f).func_181675_d();
            bufferbuilder.func_181662_b(0.866 * (double)sizeMulti, (double)resized, (double)(-0.5f * sizeMulti)).func_181666_a(r, g, b, 0.0f).func_181675_d();
            bufferbuilder.func_181662_b(0.0, (double)resized, (double)(1.0f * sizeMulti)).func_181666_a(r, g, b, 0.0f).func_181675_d();
            bufferbuilder.func_181662_b(-0.866 * (double)sizeMulti, (double)resized, (double)(-0.5f * sizeMulti)).func_181666_a(r, g, b, 0.0f).func_181675_d();
            tessellator.func_78381_a();
            ++i;
        }
        GL11.glEnable((int)3008);
        GL11.glShadeModel((int)7424);
        GL11.glEnable((int)3553);
    }

    public static void drawRect(int left, int top, int right, int bottom, int color) {
        if (left < right) {
            int i = left;
            left = right;
            right = i;
        }
        if (top < bottom) {
            int j = top;
            top = bottom;
            bottom = j;
        }
        float r = (float)(color >>> 24 & 0xFF) / 256.0f;
        float g = (float)(color >>> 16 & 0xFF) / 256.0f;
        float b = (float)(color >>> 8 & 0xFF) / 256.0f;
        float a = (float)(color & 0xFF) / 256.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179090_x();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_181662_b((double)left, (double)bottom, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        bufferbuilder.func_181662_b((double)right, (double)bottom, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        bufferbuilder.func_181662_b((double)right, (double)top, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        bufferbuilder.func_181662_b((double)left, (double)top, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
    }

    public static void draw8Rect(int x, int y, int width, int height) {
        Gui.func_152125_a((int)x, (int)y, (float)0.0f, (float)155.0f, (int)3, (int)3, (int)3, (int)3, (float)256.0f, (float)256.0f);
        Gui.func_152125_a((int)(x + width - 3), (int)y, (float)6.0f, (float)155.0f, (int)3, (int)3, (int)3, (int)3, (float)256.0f, (float)256.0f);
        Gui.func_152125_a((int)x, (int)(y + height - 3), (float)0.0f, (float)161.0f, (int)3, (int)3, (int)3, (int)3, (float)256.0f, (float)256.0f);
        Gui.func_152125_a((int)(x + width - 3), (int)(y + height - 3), (float)6.0f, (float)161.0f, (int)3, (int)3, (int)3, (int)3, (float)256.0f, (float)256.0f);
        Gui.func_152125_a((int)(x + 3), (int)y, (float)4.0f, (float)155.0f, (int)1, (int)3, (int)(width - 6), (int)3, (float)256.0f, (float)256.0f);
        Gui.func_152125_a((int)x, (int)(y + 3), (float)0.0f, (float)159.0f, (int)3, (int)1, (int)3, (int)(height - 6), (float)256.0f, (float)256.0f);
        Gui.func_152125_a((int)(x + width - 3), (int)(y + 3), (float)6.0f, (float)159.0f, (int)3, (int)1, (int)3, (int)(height - 6), (float)256.0f, (float)256.0f);
        Gui.func_152125_a((int)(x + 3), (int)(y + height - 3), (float)4.0f, (float)161.0f, (int)1, (int)3, (int)(width - 6), (int)3, (float)256.0f, (float)256.0f);
        Gui.func_152125_a((int)(x + 3), (int)(y + 3), (float)4.0f, (float)159.0f, (int)1, (int)1, (int)(width - 6), (int)(height - 6), (float)256.0f, (float)256.0f);
    }

    public static void renderEntityOnFire(Entity entity, double x, double y, double z) {
        if (entity.func_70027_ad()) {
            return;
        }
        GlStateManager.func_179140_f();
        TextureMap texturemap = Minecraft.func_71410_x().func_147117_R();
        TextureAtlasSprite textureatlassprite = texturemap.func_110572_b("minecraft:blocks/fire_layer_0");
        TextureAtlasSprite textureatlassprite1 = texturemap.func_110572_b("minecraft:blocks/fire_layer_1");
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
        float f = entity.field_70130_N * 1.4f;
        GlStateManager.func_179152_a((float)f, (float)f, (float)f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        float f1 = 0.5f;
        float f2 = 0.0f;
        float f3 = entity.field_70131_O / f;
        float f4 = (float)(entity.field_70163_u - entity.func_174813_aQ().field_72338_b);
        GlStateManager.func_179114_b((float)(-Minecraft.func_71410_x().func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)(-0.3f + (float)((int)f3) * 0.02f));
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float f5 = 0.0f;
        int i = 0;
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        while (f3 > 0.0f) {
            TextureAtlasSprite textureatlassprite2 = i % 2 == 0 ? textureatlassprite : textureatlassprite1;
            Minecraft.func_71410_x().func_175598_ae().field_78724_e.func_110577_a(TextureMap.field_110575_b);
            float f6 = textureatlassprite2.func_94209_e();
            float f7 = textureatlassprite2.func_94206_g();
            float f8 = textureatlassprite2.func_94212_f();
            float f9 = textureatlassprite2.func_94210_h();
            if (i / 2 % 2 == 0) {
                float f10 = f8;
                f8 = f6;
                f6 = f10;
            }
            bufferbuilder.func_181662_b((double)(f1 - 0.0f), (double)(0.0f - f4), (double)f5).func_187315_a((double)f8, (double)f9).func_181675_d();
            bufferbuilder.func_181662_b((double)(-f1 - 0.0f), (double)(0.0f - f4), (double)f5).func_187315_a((double)f6, (double)f9).func_181675_d();
            bufferbuilder.func_181662_b((double)(-f1 - 0.0f), (double)(1.4f - f4), (double)f5).func_187315_a((double)f6, (double)f7).func_181675_d();
            bufferbuilder.func_181662_b((double)(f1 - 0.0f), (double)(1.4f - f4), (double)f5).func_187315_a((double)f8, (double)f7).func_181675_d();
            f3 -= 0.45f;
            f4 -= 0.45f;
            f1 *= 0.9f;
            f5 += 0.03f;
            ++i;
        }
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179145_e();
    }

    public static void renderItemStack(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemBlock) {
            GlStateManager.func_179109_b((float)0.0f, (float)-0.1f, (float)0.0f);
        }
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179091_B();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        Minecraft.func_71410_x().func_175598_ae().field_78724_e.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderItem render = Minecraft.func_71410_x().func_175599_af();
        IBakedModel model = render.func_184393_a(stack, null, null);
        IBakedModel transformedModel = ForgeHooksClient.handleCameraTransforms((IBakedModel)model, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GROUND, (boolean)false);
        render.func_180454_a(stack, transformedModel);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        Minecraft.func_71410_x().func_175598_ae().field_78724_e.func_110581_b(TextureMap.field_110575_b).func_174935_a();
        GlStateManager.func_179101_C();
    }

    public static void makeUpDownTranslation(float tick, float max, float speed) {
        GlStateManager.func_179137_b((double)0.0, (double)RenderMisc.getInterpolated(tick, max, speed), (double)0.0);
    }

    public static double getInterpolated(float tick, float max, float speed) {
        float angle = 0.0f;
        double toDegrees = Math.PI / 180;
        if ((angle += speed * tick) > 360.0f) {
            angle -= 360.0f;
        }
        return (double)max * Math.sin((double)angle * toDegrees);
    }
}

