/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.client.util.resource;

import arekkuusu.enderskills.client.util.resource.shader.ShaderResource;
import arekkuusu.enderskills.common.EnderSkills;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.ProgressManager;
import org.apache.commons.io.IOUtils;
import org.lwjgl.opengl.ARBShaderObjects;

public class ShaderManager
implements IResourceManagerReloadListener {
    private static final List<ShaderResource> SHADER_RESOURCES = Lists.newArrayList();
    private static final int VERTEX = 35633;
    private static final int FRAGMENT = 35632;
    public static final ShaderManager INSTANCE = new ShaderManager();
    private static boolean reloading;

    public static ShaderResource load(@Nullable String vsh, @Nullable String fsh) {
        ShaderResource resource = new ShaderResource(vsh, fsh);
        SHADER_RESOURCES.add(resource);
        return resource;
    }

    public static int create(IResourceManager manager, @Nullable ResourceLocation vsh, @Nullable ResourceLocation fsh) {
        int vshId = 0;
        int fshId = 0;
        int program = 0;
        if (vsh != null) {
            vshId = ShaderManager.parse(manager, vsh, 35633);
        }
        if (fsh != null) {
            fshId = ShaderManager.parse(manager, fsh, 35632);
        }
        if (vsh != null || fsh != null) {
            program = ARBShaderObjects.glCreateProgramObjectARB();
        }
        if (vsh != null) {
            OpenGlHelper.func_153178_b((int)program, (int)vshId);
        }
        if (fsh != null) {
            OpenGlHelper.func_153178_b((int)program, (int)fshId);
        }
        OpenGlHelper.func_153179_f((int)program);
        if (OpenGlHelper.func_153157_c((int)program, (int)35714) == 0) {
            return 0;
        }
        if (OpenGlHelper.func_153157_c((int)program, (int)35715) == 0) {
            return 0;
        }
        return program;
    }

    private static int parse(IResourceManager manager, ResourceLocation location, int type) {
        int shader = OpenGlHelper.func_153195_b((int)type);
        try {
            InputStream inputStream = manager.func_110536_a(location).func_110527_b();
            String lines = IOUtils.readLines((InputStream)inputStream, (String)"UTF-8").stream().collect(Collectors.joining("\n"));
            ARBShaderObjects.glShaderSourceARB((int)shader, (CharSequence)lines);
            OpenGlHelper.func_153170_c((int)shader);
            inputStream.close();
            if (OpenGlHelper.func_153157_c((int)shader, (int)35713) == 0) {
                String info = OpenGlHelper.func_153166_e((int)shader, (int)35716);
                throw new RuntimeException("Error creating shader: " + info);
            }
        }
        catch (IOException e) {
            EnderSkills.LOG.warn("[Shader Resource] Failed to load shader " + location.toString());
            OpenGlHelper.func_153180_a((int)shader);
            e.printStackTrace();
        }
        return shader;
    }

    public void func_110549_a(IResourceManager manager) {
        ProgressManager.ProgressBar bar = ProgressManager.push((String)"Reloading Shader Manager", (int)0);
        reloading = true;
        SHADER_RESOURCES.forEach(shader -> shader.reload(manager));
        reloading = false;
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
    }

    public static boolean isReloading() {
        return reloading;
    }
}

