/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.client.util.sprite;

import arekkuusu.enderskills.client.util.helper.RenderMisc;
import arekkuusu.enderskills.client.util.sprite.SpriteResource;
import arekkuusu.enderskills.client.util.sprite.UVFrame;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SpriteFrameResource
extends SpriteResource {
    private final int rows;
    private final int columns;
    private final double frames;
    private final double u;
    private final double v;

    public SpriteFrameResource(ResourceLocation location, int rows, int columns) {
        super(location);
        this.columns = columns;
        this.rows = rows;
        this.u = 1.0 / (double)columns;
        this.v = 1.0 / (double)rows;
        this.frames = rows * columns;
    }

    @Override
    public void bind() {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.getLocation());
    }

    @Override
    public UVFrame getFrame() {
        return this.getFrame(RenderMisc.getRenderPlayerTime());
    }

    public UVFrame getFrame(float ticks) {
        int frame = (int)((double)ticks % this.frames);
        double u = (double)frame % (double)this.columns * this.getU();
        double v = (double)frame / (double)this.columns * this.getV();
        return new UVFrame(u, u + this.getU(), v, v + this.getV());
    }

    public double getU() {
        return this.u;
    }

    public double getV() {
        return this.v;
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    public double getFrames() {
        return this.frames;
    }
}

