/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.common;

import arekkuusu.enderskills.api.EnderSkillsAPI;
import arekkuusu.enderskills.api.helper.NBTHelper;
import arekkuusu.enderskills.api.registry.Skill;
import arekkuusu.enderskills.common.skill.IConfigSync;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;

@Config(modid="enderskills", name="enderskills/global")
public final class CommonConfig {
    @Config.Comment(value={"Global Values"})
    @Config.LangKey(value="enderskills.config.global")
    public static Values CONFIG = new Values();
    @Config.Ignore
    protected static Values CONFIG_SYNC = new Values();

    public static Values getValues() {
        return CONFIG;
    }

    public static Values getSyncValues() {
        return CONFIG_SYNC;
    }

    @Deprecated
    public static void initSyncConfig() {
        CommonConfig.getSyncValues().skill.defaultHumanTeam = CommonConfig.getValues().skill.defaultHumanTeam;
        CommonConfig.getSyncValues().skill.defaultAnimalTeam = CommonConfig.getValues().skill.defaultAnimalTeam;
        EnderSkillsAPI.defaultHumanTeam = CommonConfig.getSyncValues().skill.defaultHumanTeam;
        EnderSkillsAPI.defaultAnimalTeam = CommonConfig.getSyncValues().skill.defaultAnimalTeam;
        CommonConfig.getSyncValues().skill.globalCooldown = CommonConfig.getValues().skill.globalCooldown;
        CommonConfig.getSyncValues().skill.globalTime = CommonConfig.getValues().skill.globalTime;
        CommonConfig.getSyncValues().skill.globalRange = CommonConfig.getValues().skill.globalRange;
        CommonConfig.getSyncValues().skill.globalEffectiveness = CommonConfig.getValues().skill.globalEffectiveness;
        CommonConfig.getSyncValues().skill.extra.globalNegativeEffect = CommonConfig.getValues().skill.extra.globalNegativeEffect;
        CommonConfig.getSyncValues().skill.extra.globalPositiveEffect = CommonConfig.getValues().skill.extra.globalPositiveEffect;
        CommonConfig.getSyncValues().skill.extra.globalNeutralEffect = CommonConfig.getValues().skill.extra.globalNeutralEffect;
        CommonConfig.getSyncValues().advancement.oneTreePerClass = CommonConfig.getValues().advancement.oneTreePerClass;
        CommonConfig.getSyncValues().advancement.xp.globalCostMultiplier = CommonConfig.getValues().advancement.xp.globalCostMultiplier;
        CommonConfig.getSyncValues().advancement.xp.retryXPReturn = CommonConfig.getValues().advancement.xp.retryXPReturn;
        CommonConfig.getSyncValues().advancement.xp.xpStoreTariff = CommonConfig.getValues().advancement.xp.xpStoreTariff;
        CommonConfig.getSyncValues().advancement.xp.xpTakeTariff = CommonConfig.getValues().advancement.xp.xpTakeTariff;
        CommonConfig.getSyncValues().advancement.maxResetUnlocks = CommonConfig.getValues().advancement.maxResetUnlocks;
        CommonConfig.getSyncValues().advancement.levels.function = CommonConfig.getValues().advancement.levels.function;
        CommonConfig.getSyncValues().advancement.levels.defaultLevel = CommonConfig.getValues().advancement.levels.defaultLevel;
        CommonConfig.getSyncValues().worldGen.enderOreQuantity = CommonConfig.getValues().worldGen.enderOreQuantity;
        CommonConfig.getSyncValues().worldGen.enderOreSpawnRate = CommonConfig.getValues().worldGen.enderOreSpawnRate;
        CommonConfig.getSyncValues().worldGen.enderOreSpawnHeightMax = CommonConfig.getValues().worldGen.enderOreSpawnHeightMax;
        CommonConfig.getSyncValues().worldGen.enderOreSpawnHeightMin = CommonConfig.getValues().worldGen.enderOreSpawnHeightMin;
        CommonConfig.getSyncValues().worldGen.enderOreSpawnDimensions = CommonConfig.getValues().worldGen.enderOreSpawnDimensions;
        CommonConfig.getSyncValues().worldGen.enderOreItemDropsMin = CommonConfig.getValues().worldGen.enderOreItemDropsMin;
        CommonConfig.getSyncValues().worldGen.enderOreItemDropsMax = CommonConfig.getValues().worldGen.enderOreItemDropsMax;
        IForgeRegistry registry = GameRegistry.findRegistry(Skill.class);
        for (Map.Entry entry : registry.getEntries()) {
            if (!(entry.getValue() instanceof IConfigSync)) continue;
            ((IConfigSync)entry.getValue()).initSyncConfig();
        }
    }

    @Deprecated
    public static void writeSyncConfig(NBTTagCompound compound) {
        compound.func_74757_a("advancement.oneTreePerClass", CommonConfig.getValues().advancement.oneTreePerClass);
        compound.func_74780_a("advancement.xp.globalCostMultiplier", CommonConfig.getValues().advancement.xp.globalCostMultiplier);
        compound.func_74780_a("advancement.xp.costIncrement", CommonConfig.getValues().advancement.xp.costIncrement);
        compound.func_74780_a("advancement.xp.retryXPReturn", CommonConfig.getValues().advancement.xp.retryXPReturn);
        compound.func_74780_a("advancement.xp.xpStoreTariff", CommonConfig.getValues().advancement.xp.xpStoreTariff);
        compound.func_74780_a("advancement.xp.xpTakeTariff", CommonConfig.getValues().advancement.xp.xpTakeTariff);
        compound.func_74768_a("advancement.maxResetUnlocks", CommonConfig.getValues().advancement.maxResetUnlocks);
        NBTHelper.setArray(compound, "advancement.levels.function", CommonConfig.getValues().advancement.levels.function);
        compound.func_74768_a("advancement.levels.defaultLevel", CommonConfig.getValues().advancement.levels.defaultLevel);
        compound.func_74757_a("defaultHumanTeam", CommonConfig.getValues().skill.defaultHumanTeam);
        compound.func_74757_a("defaultAnimalTeam", CommonConfig.getValues().skill.defaultAnimalTeam);
        compound.func_74780_a("globalCooldown", CommonConfig.getValues().skill.globalCooldown);
        compound.func_74780_a("globalTime", CommonConfig.getValues().skill.globalTime);
        compound.func_74780_a("globalRange", CommonConfig.getValues().skill.globalRange);
        compound.func_74780_a("globalEffectiveness", CommonConfig.getValues().skill.globalEffectiveness);
        compound.func_74780_a("extra.globalNegativeEffect", CommonConfig.getValues().skill.extra.globalNegativeEffect);
        compound.func_74780_a("extra.globalPositiveEffect", CommonConfig.getValues().skill.extra.globalPositiveEffect);
        compound.func_74780_a("extra.globalNeutralEffect", CommonConfig.getValues().skill.extra.globalNeutralEffect);
        EnderSkillsAPI.EXPRESSION_FUNCTION_CACHE.clear();
        EnderSkillsAPI.EXPRESSION_CACHE.clear();
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public static void readSyncConfig(NBTTagCompound compound) {
        CommonConfig.getSyncValues().advancement.oneTreePerClass = compound.func_74767_n("advancement.xp.oneTreePerClass");
        CommonConfig.getSyncValues().advancement.xp.globalCostMultiplier = compound.func_74769_h("advancement.xp.globalCostMultiplier");
        CommonConfig.getSyncValues().advancement.xp.costIncrement = compound.func_74769_h("advancement.xp.costIncrement");
        CommonConfig.getSyncValues().advancement.xp.retryXPReturn = compound.func_74769_h("advancement.xp.retryXPReturn");
        CommonConfig.getSyncValues().advancement.xp.xpStoreTariff = compound.func_74769_h("advancement.xp.xpStoreTariff");
        CommonConfig.getSyncValues().advancement.xp.xpTakeTariff = compound.func_74769_h("advancement.xp.xpTakeTariff");
        CommonConfig.getSyncValues().advancement.maxResetUnlocks = compound.func_74762_e("advancement.maxResetUnlocks");
        CommonConfig.getSyncValues().advancement.levels.function = NBTHelper.getArray(compound, "advancement.levels.function");
        CommonConfig.getSyncValues().advancement.levels.defaultLevel = compound.func_74762_e("advancement.levels.defaultLevel");
        CommonConfig.getSyncValues().skill.defaultHumanTeam = compound.func_74767_n("defaultHumanTeam");
        CommonConfig.getSyncValues().skill.defaultAnimalTeam = compound.func_74767_n("defaultAnimalTeam");
        CommonConfig.getSyncValues().skill.globalCooldown = compound.func_74769_h("globalCooldown");
        CommonConfig.getSyncValues().skill.globalTime = compound.func_74769_h("globalTime");
        CommonConfig.getSyncValues().skill.globalRange = compound.func_74769_h("globalRange");
        CommonConfig.getSyncValues().skill.globalEffectiveness = compound.func_74769_h("globalEffectiveness");
        CommonConfig.getSyncValues().skill.extra.globalNegativeEffect = compound.func_74769_h("extra.globalNegativeEffect");
        CommonConfig.getSyncValues().skill.extra.globalPositiveEffect = compound.func_74769_h("extra.globalPositiveEffect");
        CommonConfig.getSyncValues().skill.extra.globalNeutralEffect = compound.func_74769_h("extra.globalNeutralEffect");
        EnderSkillsAPI.defaultHumanTeam = CommonConfig.getSyncValues().skill.defaultHumanTeam;
        EnderSkillsAPI.defaultAnimalTeam = CommonConfig.getSyncValues().skill.defaultAnimalTeam;
        EnderSkillsAPI.EXPRESSION_FUNCTION_CACHE.clear();
        EnderSkillsAPI.EXPRESSION_CACHE.clear();
    }

    public static class Values {
        public final SkillGlobalConfig skill = new SkillGlobalConfig();
        public final SkillAdvancementConfig advancement = new SkillAdvancementConfig();
        public final WorldGen worldGen = new WorldGen();
        @Config.Comment(value={"Syncs config reloads to all players in the server upon connecting or reloading server config files, if you are a dedicated server owner you might want this turned off"})
        public boolean syncValuesToClient = true;

        public static class WorldGen {
            @Config.Comment(value={"How many ore veins per chunk?"})
            @Config.RangeInt(min=0)
            public int enderOreSpawnRate = 11;
            @Config.Comment(value={"How rare the ore is 0 to 1"})
            @Config.RangeDouble(min=0.0, max=1.0)
            public double enderOreSpawnChance = 1.0;
            @Config.Comment(value={"How many ore per spawn?"})
            @Config.RangeInt(min=0)
            public int enderOreQuantity = 4;
            @Config.Comment(value={"Min spawn height?"})
            @Config.RangeInt(min=0)
            public int enderOreSpawnHeightMin = 0;
            @Config.Comment(value={"Max spawn height?"})
            @Config.RangeInt(min=0)
            public int enderOreSpawnHeightMax = 32;
            @Config.Comment(value={"Max spawn height?"})
            @Config.RangeInt(min=0)
            public int[] enderOreSpawnDimensions = new int[]{0};
            @Config.Comment(value={"Min number of dust dropped?"})
            @Config.RangeInt(min=0)
            public int enderOreItemDropsMin = 1;
            @Config.Comment(value={"Max number of dust dropped?"})
            @Config.RangeInt(min=0)
            public int enderOreItemDropsMax = 4;
        }

        public static class SkillAdvancementConfig {
            public final Experience xp = new Experience();
            public final Levels levels = new Levels();
            public boolean oneTreePerClass = true;
            public int maxResetUnlocks = 2;

            public static class Levels {
                public String[] function = new String[]{"(0+){0}", "(1+){1}", "(2+){x/2}", "(3+){x/4}", "(4+){x/6}", "(5+){x/8}", "(6+){x/10}", "(7+){x/12}", "(8+){x/14}", "(9+){x/(2 ^ x) * 0.1}"};
                public int defaultLevel = 1;
            }

            public static class Experience {
                @Config.Comment(value={"Cost increment of all advancements"})
                public double globalCostMultiplier = 1.0;
                @Config.Comment(value={"Cost increment when switching trees"})
                public double costIncrement = 0.5;
                @Config.Comment(value={"Percentage of all xp spent that is returned on reset"})
                public double retryXPReturn = 0.8;
                @Config.Comment(value={"Percentage of xp stored"})
                public double xpStoreTariff = 1.0;
                @Config.Comment(value={"Percentage of xp taken"})
                public double xpTakeTariff = 0.8;
            }
        }

        public static class SkillGlobalConfig {
            public final Extra extra = new Extra();
            @Config.Comment(value={"Disallows abilities to target humans"})
            public boolean defaultHumanTeam = true;
            @Config.Comment(value={"Disallows abilities to target passive mobs"})
            public boolean defaultAnimalTeam = false;
            public double globalCooldown = 1.0;
            public double globalTime = 1.0;
            public double globalRange = 1.0;
            public double globalEffectiveness = 1.0;

            public static class Extra {
                public double globalPositiveEffect = 0.5;
                public double globalNegativeEffect = 0.4;
                public double globalNeutralEffect = 1.0;
            }
        }
    }
}

