/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.common;

import arekkuusu.enderskills.api.capability.AdvancementCapability;
import arekkuusu.enderskills.api.capability.EnduranceCapability;
import arekkuusu.enderskills.api.capability.PowerBoostCapability;
import arekkuusu.enderskills.api.capability.SkillGroupCapability;
import arekkuusu.enderskills.api.capability.SkilledEntityCapability;
import arekkuusu.enderskills.common.CommonConfig;
import arekkuusu.enderskills.common.command.CommandAdvancement;
import arekkuusu.enderskills.common.command.CommandCooldownReset;
import arekkuusu.enderskills.common.command.CommandEnduranceReset;
import arekkuusu.enderskills.common.command.CommandReload;
import arekkuusu.enderskills.common.command.CommandSkill;
import arekkuusu.enderskills.common.command.CommandWeight;
import arekkuusu.enderskills.common.handler.GuiHandler;
import arekkuusu.enderskills.common.handler.WorldGenOre;
import arekkuusu.enderskills.common.handler.WorldGuardHelper;
import arekkuusu.enderskills.common.item.ModItems;
import arekkuusu.enderskills.common.network.PacketHandler;
import arekkuusu.enderskills.common.potion.ModPotionTypes;
import arekkuusu.enderskills.common.proxy.IProxy;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="enderskills", name="Ender Skills", version="1.12.2-1.8.0.1", acceptedMinecraftVersions="[1.12.2]")
public class EnderSkills {
    @SidedProxy(clientSide="arekkuusu.enderskills.client.proxy.ClientProxy", serverSide="arekkuusu.enderskills.common.proxy.ServerProxy")
    private static IProxy proxy;
    private static final EnderSkills INSTANCE;
    public static final Logger LOG;

    private EnderSkills() {
    }

    public static IProxy getProxy() {
        return proxy;
    }

    @Mod.InstanceFactory
    public static EnderSkills getInstance() {
        return INSTANCE;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit(event);
        SkilledEntityCapability.init();
        SkillGroupCapability.init();
        EnduranceCapability.init();
        AdvancementCapability.init();
        PowerBoostCapability.init();
        PacketHandler.init();
        if (WorldGuardHelper.isEventHelperLoaded()) {
            MinecraftForge.EVENT_BUS.register((Object)new WorldGuardHelper());
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init(event);
        ModItems.init();
        ModPotionTypes.init();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenOre(), (int)0);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
        CommonConfig.initSyncConfig();
    }

    @Mod.EventHandler
    public void onServerLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandReload());
        event.registerServerCommand((ICommand)new CommandSkill());
        event.registerServerCommand((ICommand)new CommandWeight());
        event.registerServerCommand((ICommand)new CommandCooldownReset());
        event.registerServerCommand((ICommand)new CommandEnduranceReset());
        event.registerServerCommand((ICommand)new CommandAdvancement());
    }

    static {
        INSTANCE = new EnderSkills();
        LOG = LogManager.getLogger((String)"Ender Skills");
    }
}

