/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.common.block;

import arekkuusu.enderskills.client.util.helper.IModel;
import arekkuusu.enderskills.client.util.helper.ModelHelper;
import arekkuusu.enderskills.common.block.ModBlocks;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBase
extends Block
implements IModel {
    public BlockBase(String id, Material material) {
        super(material);
        this.func_180632_j(this.defaultState());
        ModBlocks.setRegistry(this, id);
    }

    public Block setHarvestLevel(Tool lvl, ToolLevel i) {
        this.setHarvestLevel(lvl.name, i.ordinal());
        return this;
    }

    public Block setSound(SoundType type) {
        return super.func_149672_a(type);
    }

    public IBlockState defaultState() {
        return this.field_176227_L.func_177621_b();
    }

    public <T extends TileEntity> Optional<T> getTile(Class<T> clazz, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return clazz.isInstance(tile) ? Optional.of(tile) : Optional.empty();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        ModelHelper.registerModel((Block)this, 0);
    }

    public static enum ToolLevel {
        WOOD_GOLD,
        STONE,
        IRON,
        DIAMOND;

    }

    public static enum Tool {
        PICK("pickaxe"),
        AXE("axe"),
        SHOVEL("shovel");

        final String name;

        private Tool(String name) {
            this.name = name;
        }
    }
}

