/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.enderskills.common.block.tile;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileBase
extends TileEntity {
    public boolean isClientWorld() {
        return this.field_145850_b.field_72995_K;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    <T extends Comparable<T>> Optional<T> getStateValue(IProperty<T> property, BlockPos pos) {
        IBlockState state = this.field_145850_b.func_180495_p(pos);
        return state.func_177227_a().contains(property) ? Optional.of(state.func_177229_b(property)) : Optional.empty();
    }

    <T> Optional<T> getCapability(IBlockAccess world, BlockPos pos, @Nullable EnumFacing facing, Capability<T> capability) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile.hasCapability(capability, facing)) {
            return Optional.ofNullable(tile.getCapability(capability, facing));
        }
        return Optional.empty();
    }

    <T extends TileEntity> Optional<T> getTile(Class<T> clazz, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return clazz.isInstance(tile) ? Optional.of(tile) : Optional.empty();
    }

    public double func_145835_a(double x, double y, double z) {
        return Math.sqrt(super.func_145835_a(x, y, z));
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound tag = pkt.func_148857_g();
        super.func_145839_a(tag);
        this.readSync(tag);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = new NBTTagCompound();
        super.func_189515_b(tag);
        this.writeSync(tag);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.readNBT(tag);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        this.writeNBT(tag);
        return tag;
    }

    void readNBT(NBTTagCompound compound) {
    }

    void writeNBT(NBTTagCompound compound) {
    }

    public final void sync() {
        if (!this.field_145850_b.field_72995_K) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 2);
        }
    }

    void writeSync(NBTTagCompound compound) {
        this.writeNBT(compound);
    }

    @SideOnly(value=Side.CLIENT)
    void readSync(NBTTagCompound compound) {
        this.readNBT(compound);
    }
}

